/**
 * Class Name	: CharSet
 * Description	: CharSet Ŭ
 * Date 				: 2003/03/20
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/03/20 first created.
 */

package com.conv2.imageGS.Util;

import java.io.UnsupportedEncodingException;

/**
 * Unicode character set ȯ.
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */
public final class CharSet 
{
	private CharSet() {}

	/**
	 * ISO8859_1 ڵ ڿ KSC5601 ȯѴ.
	 *
	 * @param str8859 8859_1 encoding String
	 * @return KSC5601 ȯ String
	 */
	public static String toKor( String str8859 ) 
	{
		
		if( str8859 == null ) return null;
		
		String str5601 = null;
		
		try 
		{
			str5601 = new String( str8859.getBytes("8859_1"), "KSC5601" );
		} 
		catch( UnsupportedEncodingException e ) 
		{
			str5601 = new String( str8859 );
		}
		
		return str5601;
	}

	/**
	 * KSC5601 ڵ ڿ ISO8859_1 ȯѴ.
	 *
	 * @param str5601 KSC5601 encoding String
	 * @return ISO8859_1 ȯ String
	 */
	public static String toEng( String str5601 ) {
	
		if( str5601 == null ) return null;
		
		String str8859 = null;
		
		try 
		{
			str8859 = new String( str5601.getBytes("KSC5601"), "8859_1" );
		} 
		catch( UnsupportedEncodingException e ) 
		{
			str8859 = new String( str5601 );
		}
		
		return str8859;
	}

}