/**
 * Class Name	: DiffIMG
 * Description	: ΰ  
 * Date 				: 2003/03/22
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2003/03/22 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;
import com.conv2.imageGS.IMGFileIO.*;
import java.io.*;

/**
 * ΰ   Ѵ. ,     ˻  Ѵ.<br>
 * , raw   ʴ´.<p>  
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public class DiffIMG
{
	private DiffIMG() {}	

	/**
	 * ΰ   Ѵ.  true, ٸ false ȯѴ.
	 * 
	 * @param Image_fname1  1
	 * @param Image_fname2  2
	 * @exception  ImageGSException Image1 Ǵ Image2  ϳ  
	 */	
	public static boolean comp(String Image_fname1, String Image_fname2) throws ImageGSException
	{
		boolean retval = true;
		int extName_start = 0;
		String extName = null;
		String ext1 = null;
		String ext2 = null;
		
		// ϸ null ϶ 
		if(Image_fname1 == null || Image_fname2 == null)
		{
			throw new ImageGSException( "DiffIMG.comp() >>  " + Image_fname1 + " or " + Image_fname2 + " is .. "
				+ ErrorMsg.ERRORUSERVALUEISNULL );	
		}
		
		//   üũ
		File fp = new File(Image_fname1);
		
		if(fp.exists() == false)
		{
			throw new ImageGSException("DiffIMG.comp() >> " + Image_fname1 + " : "   
				+ ErrorMsg.ERRORTHISFILEISNOTEXIST );
		}
		
		fp = new File(Image_fname2);
		
		if(fp.exists() == false)
		{
			throw new ImageGSException("DiffIMG.comp() >> " + Image_fname2 + " : "   
				+ ErrorMsg.ERRORTHISFILEISNOTEXIST );
		}
		
		// Ȯڸ  üũ
		extName_start = Image_fname1.lastIndexOf("."); // Ȯڸ ۵Ǵ ġ
		ext1 = Image_fname1.substring(extName_start+1).toLowerCase(); // ҹڷ ȯ.
		
		extName_start = Image_fname2.lastIndexOf("."); // Ȯڸ ۵Ǵ ġ
		ext2 = Image_fname1.substring(extName_start+1).toLowerCase(); // ҹڷ ȯ.

		if( ext1.equals("bmp") || ext1.equals("jpg") || ext1.equals("jpeg") || ext1.equals("png") ||
		    ext1.equals("ppm") || ext1.equals("gif") )
		{
			// ignore			
		}
		// ̿   ʴ´ٴ  Ȳ .
		else 
		{
			throw new ImageGSException("DiffIMG.comp() >> "  + Image_fname1 + " : "  
				+ ErrorMsg.ERRORNOTSUPPORTFORMAT  );
		} 				

		if( ext2.equals("bmp") || ext2.equals("jpg") || ext2.equals("jpeg") || ext2.equals("png") ||
		    ext2.equals("ppm") || ext2.equals("gif"))
		{
			// ignore
		}
		// ̿   ʴ´ٴ  Ȳ .
		else 
		{
			throw new ImageGSException("DiffIMG.comp() >> "  + Image_fname2 + " : "  
				+ ErrorMsg.ERRORNOTSUPPORTFORMAT  );
		} 				
		
		// Image_fname1 Image_fname2 ȭҰ Ѵ.
		IMGFileIO gs = new IMGFileIO();

		gs.readFileName(Image_fname1);
		short[][] RedChannel1 = gs.getRedChannel();
		short[][] GreenChannel1 = gs.getGreenChannel();
		short[][] BlueChannel1 = gs.getBlueChannel();
		 
		gs.readFileName(Image_fname2);
		short[][] RedChannel2 = gs.getRedChannel();
		short[][] GreenChannel2 = gs.getGreenChannel();
		short[][] BlueChannel2 = gs.getBlueChannel();
		
		// Ѵ.
		if(!DiffIMGBuf.comp(RedChannel1, RedChannel2)) retval = false;
		if(!DiffIMGBuf.comp(GreenChannel1, GreenChannel2)) retval = false;
		if(!DiffIMGBuf.comp(BlueChannel1, BlueChannel2)) retval = false;
				 
		return retval; 
	}
} 


