/**
 * Class Name	: DimemnsionTrans
 * Description	: 2 <-> 1 ȯ  Ŭ
 * Date 				: 2002/09/08
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/09/08 first created.
 */
package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * 2 <-> 1 ȯѴ.  double/integer/short Ѵ. <br>
 * width  ȿ Ѵ. <p>
 * 
 * ó ó ӵ ø  1 ۷ ϴ 찡 ִ. <br>
 * ̸ Ͽ ̸ ϴ ̴. <br>
 * ⼭  imageGS API  2   ؾ Ѵ.<p>
 *
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.0
 */

public class DimensionTrans
{
	/**
	 * 
	 */
	private DimensionTrans() {}
	
	/**
	 * double type 2 ۸ 1 ۷ ȯѴ.
	 * 
	 * @param	Buf	double type 2  
	 * @param	Buf_height	Buf 
	 * @param	Buf_width	Buf ʺ 
	 * @return	double type 1 
	 * @exception ImageGSException
	 */
	public static double[] Double2SingleArray(double [][] Buf, int Buf_height, int Buf_width) throws ImageGSException
	{
		double [] RetSingleArray = null;

		int i = 0;
		int j = 0;
		int pixels = 0;
		
		// Step 1 : Buf nullΰ?
		if(Buf == null)
		{
			throw new ImageGSException (" DimensionTrans.Double2SingleArray() >> "
				+ ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// Step 2 : Buf_height, Buf_width  ˻
		if(Buf_height < 0 || Buf_width < 0)
		{
			throw new ImageGSException (" DimensionTrans.Double2SingleArray() >> "
				+ ErrorMsg.ERRORBUFHEIGHTORWIDTHISLESSTHANZERO );
		}
			
		// Step 3 : 1 RetSingleArray ޸𸮸 ҴѴ.
		RetSingleArray = new double[Buf_height * Buf_width];
		
		// Step 4 : 2 1 ȯѴ.
		while(true)
		{
			RetSingleArray[pixels] = Buf[i][j];
			pixels++;		
			
			if( j != (Buf_width -1) )
			{
				j++;
			}
			else if( j == (Buf_width -1) )
			{
				i++;
				
				if(i == Buf_height) 
				{
					break;
				}
				
				j=0;	
			}
		}				
		
		return RetSingleArray;
	}
	
	/**
	 * double type 1 ۸ 2 ۷ ȯѴ.
	 * 
	 * @param	Buf	double type 2  
	 * @param	Buf_height	Buf 
	 * @param	Buf_width	Buf ʺ
	 * @return	double type 1 
	 * @exception ImageGSException
	 */
	public static double[][] Single2DoubleArray(double [] Buf, int Buf_height, int Buf_width) throws ImageGSException
	{
		double [][] RetDoubleArray = null;

		int i = 0;

		int height = 0;
		int width = 0;
				
		// Step 1 : Buf nullΰ?
		if(Buf == null)
		{
			throw new ImageGSException (" DimensionTrans.Single2DoubleArray() >> " 
				+ ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// Step 2 : Buf_height, Buf_width  ˻
		if(Buf_height < 0 || Buf_width < 0)
		{
			throw new ImageGSException (" DimensionTrans.Double2SingleArray() >> " 
				+ ErrorMsg.ERRORBUFHEIGHTORWIDTHISLESSTHANZERO );
		}
		
		// Step 3 : 2  RetDoubleArray  ޸𸮸 ҴѴ.
		RetDoubleArray = InitIMGBuf.DoubleIMGBuf(Buf_height, Buf_width);
		
		// Step 4 : 1 buf 2 buf ȯѴ.
		for(i=0; i<Buf_height * Buf_width; i++)
		{
			if(width == Buf_width)
			{
				height++;
				width = 0;	
			}	
			RetDoubleArray[height][width] = Buf[i];
			width++;
		} 
		
		return RetDoubleArray;
	}	


	/**
	 * integer type 2 ۸ 1 ۷ ȯѴ.
	 * 
	 * @param	Buf	integer type 2  
	 * @param	Buf_height	Buf 
	 * @param	Buf_width	Buf ʺ 
	 * @return	integer type 1 
	 * @exception ImageGSException
	 */
	public static int[] Double2SingleArray(int [][] Buf, int Buf_height, int Buf_width) throws ImageGSException
	{
		int [] RetSingleArray = null;

		int i = 0;
		int j = 0;
		int pixels = 0;
		
		// Step 1 : Buf nullΰ?
		if(Buf == null)
		{
			throw new ImageGSException (" DimensionTrans.Double2SingleArray() >> " 
				+ ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// Step 2 : Buf_height, Buf_width  ˻
		if(Buf_height < 0 || Buf_width < 0)
		{
			throw new ImageGSException (" DimensionTrans.Double2SingleArray() >> " 
				+ ErrorMsg.ERRORBUFHEIGHTORWIDTHISLESSTHANZERO );
		}
			
		// Step 3 : 1 RetSingleArray ޸𸮸 ҴѴ.
		RetSingleArray = new int[Buf_height * Buf_width];
		
		// Step 4 : 2 1 ȯѴ.
		while(true)
		{
			RetSingleArray[pixels] = Buf[i][j];
			pixels++;		
			
			if( j != (Buf_width -1) )
			{
				j++;
			}
			else if( j == (Buf_width -1) )
			{
				i++;
				
				if(i == Buf_height) 
				{
					break;
				}
				
				j=0;	
			}
		}				
		
		return RetSingleArray;
	}
	
	/**
	 * integer type 1 ۸ 2 ۷ ȯѴ.
	 * 
	 * @param	Buf	integer type 2  
	 * @param	Buf_height	Buf 
	 * @param	Buf_width	Buf ʺ 
	 * @return	integer type 1 
	 * @exception ImageGSException
	 */
	public static int[][] Single2DoubleArray(int [] Buf, int Buf_height, int Buf_width) throws ImageGSException
	{
		int [][] RetDoubleArray = null;

		int i = 0;

		int height = 0;
		int width = 0;
				
		// Step 1 : Buf nullΰ?
		if(Buf == null)
		{
			throw new ImageGSException (" DimensionTrans.Single2DoubleArray() >> " 
				+ ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// Step 2 : Buf_height, Buf_width  ˻
		if(Buf_height < 0 || Buf_width < 0)
		{
			throw new ImageGSException (" DimensionTrans.Double2SingleArray() >> " 
				+ ErrorMsg.ERRORBUFHEIGHTORWIDTHISLESSTHANZERO );
		}
		
		// Step 3 : 2  RetDoubleArray  ޸𸮸 ҴѴ.
		RetDoubleArray = InitIMGBuf.IntegerIMGBuf(Buf_height, Buf_width);
		
		// Step 4 : 1 buf 2 buf ȯѴ.
		for(i=0; i<Buf_height * Buf_width; i++)
		{
			if(width == Buf_width)
			{
				height++;
				width = 0;	
			}	
			RetDoubleArray[height][width] = Buf[i];
			width++;
		} 
		
		return RetDoubleArray;
	}	
		
	/**
	 * short type 2 ۸ 1 ۷ ȯѴ.
	 * 
	 * @param	Buf	short type 2  
	 * @param	Buf_height	Buf 
	 * @param	Buf_width	Buf ʺ
	 * @return	short type 1 
	 * @exception ImageGSException
	 */
	public static short[] Double2SingleArray(short [][] Buf, int Buf_height, int Buf_width) throws ImageGSException
	{
		short [] RetSingleArray = null;

		int i = 0;
		int j = 0;
		int pixels = 0;
		
		// Step 1 : Buf nullΰ?
		if(Buf == null)
		{
			throw new ImageGSException (" DimensionTrans.Double2SingleArray() >> " 
				+ ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// Step 2 : Buf_height, Buf_width  ˻
		if(Buf_height < 0 || Buf_width < 0)
		{
			throw new ImageGSException (" DimensionTrans.Double2SingleArray() >> " 
				+ ErrorMsg.ERRORBUFHEIGHTORWIDTHISLESSTHANZERO );
		}
			
		// Step 3 : 1 RetSingleArray ޸𸮸 ҴѴ.
		RetSingleArray = new short[Buf_height * Buf_width];
		
		// Step 4 : 2 1 ȯѴ.
		while(true)
		{
			RetSingleArray[pixels] = Buf[i][j];
			pixels++;		
			
			if( j != (Buf_width -1) )
			{
				j++;
			}
			else if( j == (Buf_width -1) )
			{
				i++;
				
				if(i == Buf_height) 
				{
					break;
				}
				
				j=0;	
			}
		}				
		
		return RetSingleArray;
	}
	
	/**
	 * short type 1 ۸ 2 ۷ ȯѴ.
	 * 
	 * @param	Buf	short type 2  
	 * @param	Buf_height	Buf 
	 * @param	Buf_width	Buf ʺ
	 * @return	short type 1 
	 * @exception ImageGSException
	 */
	public static short[][] Single2DoubleArray(short [] Buf, int Buf_height, int Buf_width) throws ImageGSException
	{
		short [][] RetDoubleArray = null;

		int i = 0;

		int height = 0;
		int width = 0;
				
		// Step 1 : Buf nullΰ?
		if(Buf == null)
		{
			throw new ImageGSException (" DimensionTrans.Single2DoubleArray() >> " 
				+ ErrorMsg.ERRORTHISBUFISNULL );
		}
		
		// Step 2 : Buf_height, Buf_width  ˻
		if(Buf_height < 0 || Buf_width < 0)
		{
			throw new ImageGSException (" DimensionTrans.Double2SingleArray() >> " 
				+ ErrorMsg.ERRORBUFHEIGHTORWIDTHISLESSTHANZERO );
		}
		
		// Step 3 : 2  RetDoubleArray  ޸𸮸 ҴѴ.
		RetDoubleArray = InitIMGBuf.ShortIMGBuf(Buf_height, Buf_width);
		
		// Step 4 : 1 buf 2 buf ȯѴ.
		for(i=0; i<Buf_height * Buf_width; i++)
		{
			if(width == Buf_width)
			{
				height++;
				width = 0;	
			}	
			RetDoubleArray[height][width] = Buf[i];
			width++;
		} 
		
		return RetDoubleArray;
	}	
}