/**
 * Class Name	: GetRandomKey
 * Description	:   Ŭ
 * Date 				: 2003/01/06
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/01/05 first created.
 */

package com.conv2.imageGS.Util;

import java.util.*;

/**
 *  Ѵ. ִ 25ڸ̴. ӽ  Ǵ 丮,   ϰ    ̴. 
 *  
 * @author Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * @version 1.0.1
 */
public final class GetRandomKey
{
	private GetRandomKey() {}

	/**
	 * ִ  25  ڷ ̷  Ͽ ȯѴ. 
	 * 
	 * @return   (25ڸ) 
	 */
	public static String getNumber()
	{
		return getNumber(25);	
	}
		
	/**
	 * ־ ̸  ڷ ̷  Ͽ ȯѴ. 
	 * 
	 * @param keyLength	  
	 * @return    
	 */
	public static String getNumber(int keyLength)
	{
		return get(keyLength, 0);
	}	

	/**
	 * ִ  25  ڿ Ͽ ȯѴ. 
	 * 
	 * @return   (25ڸ) 
	 */
	public static String getString()
	{
		return getString(25);	
	}
		
	/**
	 * ־ ̸  ڿ Ͽ ȯѴ.
	 * 
	 * @param keyLength	  
	 * @return    
	 */
	public static String getString(int keyLength)
	{
		return get(keyLength, 1);
	}	
		
	private static String get(int keyLength, int method)
	{
		// keyLength ̰ 0, 25ڸ ̻   1, 30 Ѵ.
		if(keyLength <=0) keyLength = 1;
		else if(keyLength > 25) keyLength = 25;
		
		StringBuffer result = new StringBuffer();

		// Random  gauss  ̷  
		// Radom(long seed)
		//  ð seed  ϹǷ ִ 19ڸ̴.
		Random time_rand = new Random(System.currentTimeMillis());
		result.append(Math.abs(time_rand.nextLong()));

		// ּ 1ڸ ٿش. ᱹ ּҴ 20ڸ, ִ 25ڸ  ̴.
		Random num_rand = new Random();
		result.append(margin_zero(6, String.valueOf( (int) (Math.abs( num_rand.nextGaussian() * 10000000 )))));

		//   random 2 ȣϴ   ð ȣ  ù° κ   Ƿ,
		// ޺κп   ٿμ ߺ  ̰ Ϸ ̴.
				 			
		//  Ű ̰ ʰ ȴٸ,
		if(keyLength >= result.length())
			keyLength = result.length();
		 
		// method  0̸ , 1̸ ڿ(base64 encoding)
		String retval = null;
		if(method == 0)
		{
			retval = result.substring(0, keyLength);	
		}
		else if(method == 1)
		{
			String tmp = Base64.encoding(result.substring(0, keyLength));
			retval = tmp.substring(0, keyLength);
		}
		
		return retval;
	}
	
	private static String margin_zero(int length, String str)
	{
		StringBuffer sb = new StringBuffer();
		int str_length = str.length();
		
		if(str_length >= length) length = 0; 
		else length = length - str_length;
		
		for(int i=0; i<length; i++)
		{
			sb.append("0");	
		}
		
		sb.append(str);
		
		return sb.toString();	

	}
}
