/**
 * Class Name	: TypeConv2GrayIMG
 * Description	: Double <-> Short type Gray Image buf ȯ  Ŭ
 * Date 				: 2002/09/03
 * Author			: Moon-Ho, Lee (conv2@nvision.gsnu.ac.kr)
 * History			: 2002/09/03 first created.
 */

package com.conv2.imageGS.Util;

import com.conv2.imageGS.ErrorMsg.*;
import com.conv2.imageGS.Exception.*;

/**
 * short <-> double, integer<->short, integer<-> short gray image buf ȯѴ. <p>
 * 
 * @author conv2@nvision.gsnu.ac.kr
 * @version 1.0.0
 */
public final class TypeConv2GrayIMG
{
	/**
	 * 
	 */
	private TypeConv2GrayIMG() {}

   /**
     * type casting (double -> short).
     * 
	 * @param	DoubleGrayIMG	double type  ϵ  
     * @return    short type  height x width ũ ϵ  ۸ ȯ
     * @exception ImageGSException DoubleGrayIMG ϶
     */
	public static short[][] Double2ShortGrayIMG(double[][] DoubleGrayIMG) throws  ImageGSException
	{
		short[][] ResultIMG = null;		
		int DoubleGrayIMG_height = 0;
		int DoubleGrayIMG_width = 0;
		int i = 0;
		int j = 0;
		
		
		// GrayIMG null   ܻȲ .
		if(DoubleGrayIMG == null) {
			throw new  ImageGSException("Double2ShortGrayIMG >> "  + ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 		
		}	
		
		DoubleGrayIMG_height = DoubleGrayIMG.length;
		DoubleGrayIMG_width = DoubleGrayIMG[DoubleGrayIMG_height-1].length;
			
		ResultIMG = (short [][]) InitIMGBuf.ShortIMGBuf(DoubleGrayIMG_height, DoubleGrayIMG_width);

		for(i=0; i<DoubleGrayIMG_height; i++)
		{
			for(j=0; j<DoubleGrayIMG_width; j++)
			{
				ResultIMG[i][j] = (short)DoubleGrayIMG[i][j];
			}	
		}
		
		return ResultIMG;
	}

  /**
     * type casting (double -> integer).
     * 
	 * @param	IntegerGrayIMG	integer type  ϵ  
     * @return    short type  height x width ũ ϵ  ۸ ȯ
     * @exception ImageGSException DoubleGrayIMG ϶
     */
	public static int[][] Double2IntegerGrayIMG(double[][] DoubleGrayIMG) throws  ImageGSException
	{
		int[][] ResultIMG = null;		
		int DoubleGrayIMG_height = 0;
		int DoubleGrayIMG_width = 0;
		int i = 0;
		int j = 0;

		// GrayIMG null   ܻȲ .
		if(DoubleGrayIMG == null) {
			throw new  ImageGSException("Double2IntegerGrayIMG >> "  + ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 		
		}	
		
		DoubleGrayIMG_height = DoubleGrayIMG.length;
		DoubleGrayIMG_width = DoubleGrayIMG[DoubleGrayIMG_height-1].length;
			
		ResultIMG = InitIMGBuf.IntegerIMGBuf(DoubleGrayIMG_height, DoubleGrayIMG_width);

		for(i=0; i<DoubleGrayIMG_height; i++)
		{
			for(j=0; j<DoubleGrayIMG_width; j++)
			{
				ResultIMG[i][j] = (int)DoubleGrayIMG[i][j];
			}	
		}
		
		return ResultIMG;
	}
	
   /**
     * type casting (short -> double).
     * 
	 * @param	ShortGrayIMG	short type  ϵ  
     * @return    double type  height x width ũ ϵ  ۸ ȯ
     * @exception ImageGSException ShortGrayIMG ϶
     */
	public static double[][] Short2DoubleGrayIMG(short[][] ShortGrayIMG) throws  ImageGSException
	{
		double[][] ResultIMG = null;		
		int ShortGrayIMG_height = 0;
		int ShortGrayIMG_width = 0;
		int i = 0;
		int j = 0;
		
		// ShortGrayIMG null   ܻȲ .
		if(ShortGrayIMG == null) {
			throw new  ImageGSException("Short2DoubleGrayIMG >> "  + ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG);	
		}	
		
		ShortGrayIMG_height = ShortGrayIMG.length;
		ShortGrayIMG_width = ShortGrayIMG[ShortGrayIMG_height-1].length;
			
		ResultIMG = (double [][]) InitIMGBuf.DoubleIMGBuf(ShortGrayIMG_height, ShortGrayIMG_width);

		for(i=0; i<ShortGrayIMG_height; i++)
		{
			for(j=0; j<ShortGrayIMG_width; j++)
			{
				ResultIMG[i][j] = (double)ShortGrayIMG[i][j];
			}	
		}
		
		return ResultIMG;
	}

   /**
     * type casting (short -> integer).
     * 
	 * @param	ShortGrayIMG	short type  ϵ  
     * @return    double type  height x width ũ ϵ  ۸ ȯ
     * @exception ImageGSException ShortGrayIMG ϶
     */
	public static int[][] Short2IntegerGrayIMG(short[][] ShortGrayIMG) throws  ImageGSException
	{
		int[][] ResultIMG = null;		
		int ShortGrayIMG_height = 0;
		int ShortGrayIMG_width = 0;
		int i = 0;
		int j = 0;
		
		// ShortGrayIMG null   ܻȲ .
		if(ShortGrayIMG == null) {
			throw new  ImageGSException("Short2IntegerGrayIMG >> "  + ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG);	
		}	
		
		ShortGrayIMG_height = ShortGrayIMG.length;
		ShortGrayIMG_width = ShortGrayIMG[ShortGrayIMG_height-1].length;
		
		ResultIMG = (int [][]) InitIMGBuf.IntegerIMGBuf(ShortGrayIMG_height, ShortGrayIMG_width);

		for(i=0; i<ShortGrayIMG_height; i++)
		{
			for(j=0; j<ShortGrayIMG_width; j++)
			{
				ResultIMG[i][j] = (int)ShortGrayIMG[i][j];
			}	
		}
		
		return ResultIMG;
	}

   /**
     * type casting (integer -> double).
     * 
	 * @param	IntegerGrayIMG	integer type  ϵ  
     * @return    short type  height x width ũ ϵ  ۸ ȯ
     * @exception ImageGSException IntegerGrayIMG ϶
     */
	public static double[][] Integer2DoubleGrayIMG(int[][] IntegerGrayIMG) throws  ImageGSException
	{
		double[][] ResultIMG = null;		
		int IntegerGrayIMG_height = 0;
		int IntegerGrayIMG_width = 0;
		int i = 0;
		int j = 0;
		
		// GrayIMG null   ܻȲ .
		if(IntegerGrayIMG == null) {
			throw new  ImageGSException("Integer2ShortGrayIMG >> "  + ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 		
		}	
		
		IntegerGrayIMG_height = IntegerGrayIMG.length;
		IntegerGrayIMG_width = IntegerGrayIMG[IntegerGrayIMG_height-1].length;
			
		ResultIMG = (double [][]) InitIMGBuf.DoubleIMGBuf(IntegerGrayIMG_height, IntegerGrayIMG_width);

		for(i=0; i<IntegerGrayIMG_height; i++)
		{
			for(j=0; j<IntegerGrayIMG_width; j++)
			{
				ResultIMG[i][j] = (double)IntegerGrayIMG[i][j];
			}	
		}
		
		return ResultIMG;
	}
	
   /**
     * type casting (integer -> short).
     * 
	 * @param	IntegerGrayIMG	integer type  ϵ  
     * @return    short type  height x width ũ ϵ  ۸ ȯ
     * @exception ImageGSException IntegerGrayIMG ϶
     */
	public static short[][] Integer2ShortGrayIMG(int[][] IntegerGrayIMG) throws  ImageGSException
	{
		short[][] ResultIMG = null;		
		int IntegerGrayIMG_height = 0;
		int IntegerGrayIMG_width = 0;
		int i = 0;
		int j = 0;
		
		// GrayIMG null   ܻȲ .
		if(IntegerGrayIMG == null) {
			throw new  ImageGSException("Integer2ShortGrayIMG >> "  + ErrorMsg.ERRORUNKNOWNSIZEOFGRAYIMG); 		
		}	
		
		IntegerGrayIMG_height = IntegerGrayIMG.length;
		IntegerGrayIMG_width = IntegerGrayIMG[IntegerGrayIMG_height-1].length;
		
		ResultIMG = (short [][]) InitIMGBuf.ShortIMGBuf(IntegerGrayIMG_height, IntegerGrayIMG_width);

		for(i=0; i<IntegerGrayIMG_height; i++)
		{
			for(j=0; j<IntegerGrayIMG_width; j++)
			{
				ResultIMG[i][j] = (short)IntegerGrayIMG[i][j];
			}	
		}
		
		return ResultIMG;
	}
}