package map;
import java.awt.FlowLayout;
import javax.swing.JButton;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.WindowConstants;
import javax.swing.SwingUtilities;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class JFrameMap extends JFrame {
	{
		//Set Look & Feel
		try {
			javax.swing.UIManager.setLookAndFeel(javax.swing.UIManager.getSystemLookAndFeelClassName());
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	public static final long serialVersionUID = 4844551909667423229L;
	public JTextField jTextSource;
	public JLabel jLabelDestination;
	public JLabel jLabelSource;
	public JButton jButtonErase;
	public JButton jButtonApply;
	public JTextField jTextDestination;
	public JPanelPaint jPanelPaint=new JPanelPaint();
	
	// ̺Ʈ ó inner Ŭ
	public class ButtonHandler implements ActionListener {
		public void actionPerformed(ActionEvent event) {
			if (event.getSource() == jButtonApply) {
				if (!jTextSource.getText().equals(new String(""))) {
					if (jTextDestination.getText().equals(new String(""))) {
						jPanelPaint.enableCity(jTextSource.getText());
					} else {
						jPanelPaint.enableCity(jTextSource.getText(), jTextDestination.getText());
					}
				}
			}
			if (event.getSource() == jButtonErase) {
				jPanelPaint.eraseAll();
			}
		}
	}

	public JFrameMap() {
		super();
		initGUI();
		
		// ̺Ʈ ڵ鷯 
		ButtonHandler buttonHandler = new ButtonHandler();
		jButtonApply.addActionListener(buttonHandler);
		jButtonErase.addActionListener(buttonHandler);
		


	}
	
	public void initGUI() {
		try {
			FlowLayout thisLayout = new FlowLayout();
			getContentPane().setLayout(thisLayout);
			setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
			this.setTitle("\uc9c0\ub3c4\ub85c \ubcf4\uae30");
			{
				jLabelSource = new JLabel();
				getContentPane().add(jLabelSource);
				jLabelSource.setText("\ucd9c\ubc1c \uc9c0\uc810 - \uc608\uc0c1 \ub3c4\ucc29 \uc9c0\uc810");
			}
			{
				jTextSource = new JTextField();
				getContentPane().add(jTextSource);
				jTextSource.setPreferredSize(new java.awt.Dimension(30, 21));
				jTextSource.setSize(30, 21);
			}
			{
				jLabelDestination = new JLabel();
				getContentPane().add(jLabelDestination);
				jLabelDestination.setText("-");
			}
			{
				jTextDestination = new JTextField();
				getContentPane().add(jTextDestination);
				jTextDestination.setPreferredSize(new java.awt.Dimension(30, 21));
			}
			{
				jButtonApply = new JButton();
				getContentPane().add(jButtonApply);
				jButtonApply.setText("\ud45c\uc2dc \ud574\uc918!");
			}
			{
				jButtonErase = new JButton();
				getContentPane().add(jButtonErase);
				jButtonErase.setText("\uc9c0\uc6b0\uae30");
			}
			{
				getContentPane().add(jPanelPaint);
				//jPanelPaint.setPreferredSize(new java.awt.Dimension(452, 642));

			}
			pack();
			this.setSize(469, 715);
			
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	public void click(){
		if (!jTextSource.getText().equals(new String(""))) {
			if (jTextDestination.getText().equals(new String(""))) {
				jPanelPaint.enableCity(jTextSource.getText());
			} else {
				jPanelPaint.enableCity(jTextSource.getText(), jTextDestination.getText());
			}
		}
	}
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				JFrameMap inst = new JFrameMap();
				inst.setLocationRelativeTo(null);
				inst.setVisible(true);
			}
		});
	}
}