package map;
import java.util.Vector;
import java.util.Iterator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ImageIcon;
import javax.swing.WindowConstants;

public class JPanelPaint extends JPanel {
	
	{
		try {
			javax.swing.UIManager.setLookAndFeel(javax.swing.UIManager.getSystemLookAndFeelClassName());
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	public static final long serialVersionUID = -193096281977522236L;
	public ImageIcon imageIconMap;
	public City seoul;				// 
	public City hanam;				// ϳ
	public City chuncheon;			// õ
	public City hongcheon;			// ȫõ
	public City gangneung;			// 
	public City donghae;			// 
	public City samcheok;			// ô
	public City yeongjongIsland;	// 
	public City singal;			// Ű
	public City icheon;			// õ
	public City yeoju;				// 
	public City wonju;				// 
	public City jecheon;			// õ
	public City pyeongtaek;		// 
	public City anseong;			// ȼ
	public City chungju;			// 
	public City dangjin;			// 
	public City cheonan;			// õ
	public City jincheon;			// õ
	public City cheongju;			// û
	public City gongju;			// 
	public City daejeon;			// 
	public City sangju;			// 
	public City andong;			// ȵ
	public City yeongdeok;			// 
	public City seocheon;			// õ
	public City nonsan;			// 
	public City gunsan;			// 
	public City iksan;				// ͻ
	public City muju;				// 
	public City gimcheon;			// õ
	public City pohang;			// 
	public City daegu;				// 뱸
	public City jangsu;			// 
	public City gochang;			// â
	public City hamyang;			// Ծ
	public City hyeonpung;			// ǳ
	public City cheongdo;			// û
	public City eonyang;			// 
	public City ulsan;				// 
	public City busan;				// λ
	public City miryang;			// о
	public City naengjeong;		// 
	public City masan;				// 
	public City jinju;				// 
	public City gwangyang;			// 
	public City suncheon;			// õ
	public City gwangju;			// 
	public City muan;				// 
	public City mokpo;				// 
	public Vector<City> vecCity;
	public int width;
	public int height;

	// ׽Ʈ..  ޼ҵ  ʴ´!
	public static void main(String[] args) {
		JFrame frame = new JFrame();
		JPanelPaint panelPaint = new JPanelPaint();
		frame.getContentPane().add(panelPaint);
		frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		frame.pack();
		frame.setVisible(true);
	}
	
	// Constructor
	public JPanelPaint() {
		super();
		initGUI();
		generateTopography();
		initVector();
	}
	
	public void initGUI() {
		try {
			imageIconMap = new ImageIcon(getClass().getClassLoader().getResource("map/skorea.gif"));
			width = imageIconMap.getIconWidth();
			height = imageIconMap.getIconHeight();
			this.setPreferredSize(new java.awt.Dimension(width,	height));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
		
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2d = (Graphics2D)g;
		
		//  
		imageIconMap.paintIcon(this, g, 0, 0);
		
		// ÿ ׶ ǥ
		Iterator<City> iter = vecCity.iterator();
		while (iter.hasNext()) {
			City c = iter.next();
			if (c.isVisible())
				c.drawCircle(g2d);
		}
		instructions(g2d, width - 200, height - 75);
	}
	
	public void instructions(Graphics2D g, int x, int y) {
		g.setStroke(new BasicStroke(4.0f));
		g.setColor(Color.BLACK);
		g.drawString("**          **", x + 56, y + 12);
		
		// ʷϻ ׶̿   ǥ
		int xGreen = x;
		int yGreen = y + 25;
		g.setColor(Color.GREEN.brighter());
		g.fill(new Ellipse2D.Double(xGreen + 1, yGreen + 1, 14.0, 14.0));
		g.setColor(Color.GREEN.darker());
		g.draw(new Ellipse2D.Double(xGreen, yGreen, 16.0, 16.0));
		g.setColor(Color.BLACK);
		g.drawString(" ġ Ǵ ľǵ ֱ ġ", xGreen + 20, yGreen + 12);
		
		//  ׶̿   ǥ
		int xRed = x;
		int yRed = y + 50;
		g.setColor(Color.RED.brighter());
		g.fill(new Ellipse2D.Double(xRed + 1, yRed + 1, 14.0, 14.0));
		g.setColor(Color.RED.darker());
		g.draw(new Ellipse2D.Double(xRed, yRed, 16.0, 16.0));
		g.setColor(Color.BLACK);
		g.drawString("   Ǵ ", xRed + 20, yRed + 12);
	}
	
	public void enableCity(String cityCode) {
		Iterator<City> iter = vecCity.iterator();
		while (iter.hasNext()) {
			City c = iter.next();
			if (c.getIdx().equals(cityCode)) {
				c.setColor(Color.GREEN);
				c.setVisible(true);
			}
		}
		repaint();
	}
	
	public void enableCity(String source, String destination) {
		Iterator<City> iter = vecCity.iterator();
		
		while (iter.hasNext()) {
			City c = iter.next();
			if (c.getIdx().equals(source)) {
				c.setColor(Color.GREEN);
				c.setVisible(true);
			} else if (c.getIdx().equals(destination)) {
				c.setColor(Color.RED);
				c.setVisible(true);
			}
		}
		repaint();
	}
	
	public void disableCity(String cityCode) {
		Iterator<City> iter = vecCity.iterator();
		while (iter.hasNext()) {
			City c = iter.next();
			if (c.getIdx().equals(cityCode))
				c.setVisible(false);
		}
		repaint();
	}
	
	public void eraseAll() {
		Iterator<City> iter = vecCity.iterator();
		while (iter.hasNext()) {
			iter.next().setVisible(false);
		}
		repaint();
	}

	public void generateTopography() {
		seoul = new City("0001", "", 145.0, 156.0);
		hanam = new City("1029", "ϳ", 169.0, 155.0);
		chuncheon = new City("2013", "õ", 233.0, 104.0);
		hongcheon = new City("2016", "ȫõ", 244.0, 131.0);
		gangneung = new City("2001", "", 333.0, 119.0);
		donghae = new City("2003", "", 359.0, 158.0);
		samcheok = new City("2004", "ô", 380.0, 183.0);
		yeongjongIsland = new City("1031", "", 62.0, 201.0);
		singal = new City("1032", "Ű", 152.0, 193.0);
		icheon = new City("1025", "õ", 190.0, 193.0);
		yeoju = new City("1019", "", 209.0, 196.0);
		wonju = new City("2009", "", 246.0, 180.0);
		jecheon = new City("3107", "õ", 271.0, 210.0);
		pyeongtaek = new City("1027", "", 130.0, 223.0);
		anseong = new City("1015", "ȼ", 158.0, 221.0);
		chungju = new City("3112", "", 236.0, 227.0);
		dangjin = new City("3205", "", 111.0, 242.0);
		cheonan = new City("3213", "õ", 160.0, 261.0);
		jincheon = new City("3109", "õ", 196.0, 248.0);
		cheongju = new City("3111", "û", 185.0, 287.0);
		gongju = new City("3202", "", 145.0, 313.0);
		daejeon = new City("0006", "", 185.0, 316.0);
		sangju = new City("5109", "", 274.0, 309.0);
		andong = new City("5111", "ȵ", 320.0, 299.0);
		yeongdeok = new City("5112", "", 397.0, 266.0);
		seocheon = new City("3209", "õ", 90.0, 343.0);
		nonsan = new City("3204", "", 142.0, 356.0);
		gunsan = new City("4102", "", 104.0, 361.0);
		iksan = new City("4109", "ͻ", 144.0, 377.0);
		muju = new City("4105", "", 204.0, 376.0);
		gimcheon = new City("5106", "õ", 277.0, 346.0);
		pohang = new City("5123", "", 391.0, 358.0);
		daegu = new City("0004", "뱸", 307.0, 383.0);
		jangsu = new City("4111", "", 200.0, 408.0);
		gochang = new City("4101", "â", 78.0, 451.0);
		hamyang = new City("5221", "Ծ", 219.0, 434.0);
		hyeonpung = new City("5224", "ǳ", 295.0, 414.0);
		cheongdo = new City("5120", "û", 322.0, 417.0);
		eonyang = new City("5211", "", 370.0, 427.0);
		ulsan = new City("5212", "", 400.0, 429.0);
		busan = new City("0002", "λ", 363.0, 480.0);
		miryang = new City("5207", "о", 340.0, 442.0);
		naengjeong = new City("5223", "", 333.0, 480.0);
		masan = new City("5206", "", 301.0, 481.0);
		jinju = new City("5214", "", 258.0, 500.0);
		gwangyang = new City("4204", "", 212.0, 530.0);
		suncheon = new City("4210", "õ", 187.0, 524.0);
		gwangju = new City("0005", "", 121.0, 481.0);
		muan = new City("4222", "", 41.0, 515.0);
		mokpo = new City("4208", "", 20.0, 540.0);
	}

	public void initVector() {
		vecCity = new Vector<City>();
		vecCity.add(seoul);
		vecCity.add(hanam);		
		vecCity.add(chuncheon);
		vecCity.add(hongcheon);
		vecCity.add(gangneung);
		vecCity.add(donghae);
		vecCity.add(samcheok);
		vecCity.add(yeongjongIsland);
		vecCity.add(singal);
		vecCity.add(icheon);
		vecCity.add(yeoju);
		vecCity.add(wonju);
		vecCity.add(jecheon);
		vecCity.add(pyeongtaek);
		vecCity.add(anseong);
		vecCity.add(chungju);
		vecCity.add(dangjin);
		vecCity.add(cheonan);
		vecCity.add(jincheon);
		vecCity.add(cheongju);
		vecCity.add(gongju);
		vecCity.add(daejeon);
		vecCity.add(sangju);
		vecCity.add(andong);
		vecCity.add(yeongdeok);
		vecCity.add(seocheon);
		vecCity.add(nonsan);
		vecCity.add(gunsan);
		vecCity.add(iksan);
		vecCity.add(muju);
		vecCity.add(gimcheon);
		vecCity.add(pohang);
		vecCity.add(daegu);
		vecCity.add(jangsu);
		vecCity.add(gochang);
		vecCity.add(hamyang);
		vecCity.add(hyeonpung);
		vecCity.add(cheongdo);
		vecCity.add(eonyang);
		vecCity.add(ulsan);
		vecCity.add(busan);
		vecCity.add(miryang);
		vecCity.add(naengjeong);
		vecCity.add(masan);
		vecCity.add(jinju);
		vecCity.add(gwangyang);
		vecCity.add(suncheon);
		vecCity.add(gwangju);
		vecCity.add(muan);
		vecCity.add(mokpo);
	}
	
}
