CK_BattleField = {};

function Ck_ProcessBF() 
    local status, mapName, instanceID, levelRangeMin, levelRangeMax, teamSize, registeredMatch;

    -- if in a battleground, 0 for Horde and 1 for Alliance 
    local winner = GetBattlefieldWinner();
    if (winner) then
	for i=1, MAX_BATTLEFIELD_QUEUES do
            status, mapName, instanceID, levelRangeMin, levelRangeMax, teamSize, registeredMatch = GetBattlefieldStatus(i);
            if ( status == "active" ) then
                --CensusKr_Print(mapName .. " " .. instanceID .. ": " .. winner);
                Ck_SaveBF(mapName, instanceID, winner);
            end
        end        
    end
end

--[[
realm
    mapName
        instanceId
            date = w,w,w...
]]
function Ck_SaveBF(mapName, instanceID, winner)
    local localDate = CensusPlus_DetermineServerDate();
    local realm = GetRealmName();
    local char = UnitName("player");

    if (CK_BattleField[realm] == nil) then
        CK_BattleField[realm] = {};
    end
    if (CK_BattleField[realm][char] == nil) then
        CK_BattleField[realm][char] = {};
    end
    if (CK_BattleField[realm][char][mapName] == nil) then
        CK_BattleField[realm][char][mapName] = {};
    end
    if (CK_BattleField[realm][char][mapName][instanceID] == nil) then
        CK_BattleField[realm][char][mapName][instanceID] = {};
    end
    if (CK_BattleField[realm][char][mapName][instanceID][localDate] == nil) then
        CK_BattleField[realm][char][mapName][instanceID][localDate] = "";
    end
    if (CK_BattleField[realm][char][mapName][instanceID][localDate] ~= "") then
        CK_BattleField[realm][char][mapName][instanceID][localDate] = CK_BattleField[realm][char][mapName][instanceID][localDate] .. ",";
    end
    CK_BattleField[realm][char][mapName][instanceID][localDate] = winner;
end
