CK_Item = {};
CK_Quest = {};
CK_Vendor = {};

function Ck_ProcessVendor()
    local zone = GetRealZoneText();
    local npc = UnitName("target");
    if (CK_Vendor[zone] == nil) then
        CK_Vendor[zone] = {};
    end
    local v = nil;
    if (CK_Vendor[zone][npc] == nil) then
        --CensusKr_Print("New Vendor... " .. npc .. " " .. zone);
        CK_Vendor[zone][npc] = {i={}, t="", f=""};
        v = CK_Vendor[zone][npc];
        v.t = Ck_TooltipUnit("target");
        v.f = UnitFactionGroup("target");
    else
        v = CK_Vendor[zone][npc];
    end
    
    local num = GetMerchantNumItems();
    --CensusKr_Print("Num: " .. num);
    for i=1, num do 
        local itemLink = GetMerchantItemLink(i);
        --CensusKr_Print(gsub(itemLink, "\124", "\124\124"));
        local itemKey = Ck_SaveItem(itemLink);
        if (itemKey == nil) then
            return;
        end
        local _, _, price, quantity, numAvailable, _, extendedCost = GetMerchantItemInfo(i);
        if (v.i[itemKey] == nil) then
            local item = {};
            local priceFormat = "%s,%s,%s,%s,%s"; -- price, quantity, numavailable, honor, arena
            if (extendedCost == nil) then
                item = string.format(priceFormat, price, quantity, numAvailable, 0, 0);
            else
                local honorPoints, arenaPoints, itemCount = GetMerchantItemCostInfo(i);
                if (honorPoints == nil) then
                    honorPoints = 0;
                end
                if (arenaPoints == nil) then
                    arenaPoints = 0;
                end
                item.p = string.format(priceFormat, price, quantity, numAvailable, honorPoints, arenaPoints, reqItems);

                item.e = {};
                if (itemCount > 0) then
                    for j=1, itemCount do
                        local itemTexture, itemValue = GetMerchantItemCostItem(i, j);
                        local tooltip = Ck_TooltipVendor(i, j);
                        item.e[itemTexture] = {v=itemValue, t=tooltip};
                    end
                end
            end
            v.i[itemKey] = item;
        end
    end
end

function Ck_ProcessQuest()
    local zone = GetRealZoneText();
    local npc = UnitName("target");
    local title = GetTitleText();
    if (title == nil) then
        return;
    end
    if (npc == nil) then
        npc = "N/A";
    end
    local quest = string.format("%s - %s (%s)", zone, title, npc);
    if (CK_Quest[quest] ~= nil) then
        return;
    end

    local num = GetNumQuestRewards();
    local items = "";
    for i=1, num do 
        local itemLink = GetQuestItemLink("reward", i);
        local itemKey = Ck_SaveItem(itemLink);
        if (itemKey == nil) then
            return;
        end
        if items ~= "" then
            items = items .. ",";
        end
        items = items .. itemKey;
    end
    if (items ~= "") then
        CK_Quest[quest] = items;
        --CensusKr_Print("New Quest... " .. quest);
    end
end

function Ck_SaveItem(itemLink)
    local itemId = Ck_getItemIdByLink(itemLink);
    if (itemId == nil) then
        return nil;
    end
    local name, link, rarity, level, reqlevel, itype, subtype, _, equipLoc, texture = GetItemInfo(itemLink);
    local itemKey = itemId .. "_" .. name;
    local ff = false;
    for _, sitem in pairs(CK_SavedItem) do
        if (itemKey == sitem) then
            ff = true;
            break;
        end
    end
    if (ff) then 
        return itemKey;
    end
    if (CK_Item[itemKey] == nil) then
        --CensusKr_Print("New Item... " .. name);
        CK_Item[itemKey] = {};
        CK_Item[itemKey].itemid = itemId;
        CK_Item[itemKey].name = name;
        CK_Item[itemKey].rarity = rarity;
        CK_Item[itemKey].level = level;
        CK_Item[itemKey].reqlevel = reqlevel;
        CK_Item[itemKey].type = itype;
        CK_Item[itemKey].subtype = subtype;
        CK_Item[itemKey].equipLoc = equipLoc;
        CK_Item[itemKey].texture = texture;
        CK_Item[itemKey].tooltip = Ck_Tooltip(link);
    end;
    return itemKey;
end

function Ck_getItemIdByLink(itemLink)
    if (itemLink == nil) then
        return nil;
    end
    local found, _, itemString = string.find(itemLink, "^|%x+|H(.+)|h%[.+%]");
    if (itemString == nil) then
        return nil;
    end
    --CensusKr_Print("itemString: " .. itemString);
    local found, _, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = string.find(itemString, "^item:(%d+):(%d+):(%d+):(%d+):(%d+):(%d+):(%-?%d+):(%-?%d+)")
    --CensusKr_Print("itemId: " .. itemId);
    return itemId;
end

function Ck_Tooltip(itemLink)
    local TooltipNameBase = "CK_Tooltip";
    local tooltipFrame = getglobal(TooltipNameBase);
    tooltipFrame:SetOwner(TargetFrame, "ANCHOR_BOTTOMRIGHT");
    tooltipFrame:SetHyperlink(itemLink);
    local htmlstr = nil;
    for idx = 1, tooltipFrame:NumLines() do
        local textLeft = nil;
        local textRight = nil;
        ttext = getglobal(TooltipNameBase.."TextLeft"..idx);
        if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil) then
            textLeft = "<div>" .. ttext:GetText() .. "</div>";
        end
        ttext = getglobal(TooltipNameBase.."TextRight"..idx);
        if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil) then
            textRight = "<div style='float:right;'>" .. ttext:GetText() .. "</div>";
        end
        if (textLeft or textRight) then
        --[[
            if ( textRight) then
                textRight = "\t"..textRight;
            else
                textRight = "";
            end
            ]]
            if (textRight == nil) then
                textRight = "";
            end

            if ( htmlstr ~= nil ) then
                --htmlstr = htmlstr .. "<br />" .. textLeft .. textRight;
                --htmlstr = htmlstr .. textLeft .. textRight;
                htmlstr = htmlstr .. textRight .. textLeft;
            else
                --htmlstr = textLeft .. textRight;
                htmlstr = textRight .. textLeft;
            end
        end
    end
    htmlstr = string.gsub(htmlstr, "\n", "<br />");
    tooltipFrame:ClearLines();
    tooltipFrame:Hide();
    return htmlstr;	
end

function Ck_TooltipUnit(unit)
    local TooltipNameBase = "CK_Tooltip";
    local tooltipFrame = getglobal(TooltipNameBase);
    tooltipFrame:SetOwner(TargetFrame, "ANCHOR_BOTTOMRIGHT");
    tooltipFrame:SetUnit(unit);
    local htmlstr = nil;
    for idx = 1, tooltipFrame:NumLines() do
        local textLeft = nil;
        local textRight = nil;
        ttext = getglobal(TooltipNameBase.."TextLeft"..idx);
        if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil) then
            textLeft = "<div>" .. ttext:GetText() .. "</div>";
        end
        ttext = getglobal(TooltipNameBase.."TextRight"..idx);
        if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil) then
            textRight = "<div style='float:right;'>" .. ttext:GetText() .. "</div>";
        end
        if (textLeft or textRight) then
        --[[
            if ( textRight) then
                textRight = "\t"..textRight;
            else
                textRight = "";
            end
            ]]
            if (textRight == nil) then
                textRight = "";
            end

            if ( htmlstr ~= nil ) then
                --htmlstr = htmlstr .. "<br />" .. textLeft .. textRight;
                --htmlstr = htmlstr .. textLeft .. textRight;
                htmlstr = htmlstr .. textRight .. textLeft;
            else
                --htmlstr = textLeft .. textRight;
                htmlstr = textRight .. textLeft;
            end
        end
    end
    htmlstr = string.gsub(htmlstr, "\n", "<br />");
    tooltipFrame:ClearLines();
    tooltipFrame:Hide();
    return htmlstr;	
end

function Ck_TooltipVendor(index, i)
    local TooltipNameBase = "CK_Tooltip";
    local tooltipFrame = getglobal(TooltipNameBase);
    tooltipFrame:SetOwner(TargetFrame, "ANCHOR_BOTTOMRIGHT");
    tooltipFrame:SetMerchantCostItem(index, i);
    local htmlstr = nil;
    for idx = 1, tooltipFrame:NumLines() do
        local textLeft = nil;
        local textRight = nil;
        ttext = getglobal(TooltipNameBase.."TextLeft"..idx);
        if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil) then
            textLeft = "<div>" .. ttext:GetText() .. "</div>";
        end
        ttext = getglobal(TooltipNameBase.."TextRight"..idx);
        if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil) then
            textRight = "<div style='float:right;'>" .. ttext:GetText() .. "</div>";
        end
        if (textLeft or textRight) then
        --[[
            if ( textRight) then
                textRight = "\t"..textRight;
            else
                textRight = "";
            end
            ]]
            if (textRight == nil) then
                textRight = "";
            end

            if ( htmlstr ~= nil ) then
                --htmlstr = htmlstr .. "<br />" .. textLeft .. textRight;
                --htmlstr = htmlstr .. textLeft .. textRight;
                htmlstr = htmlstr .. textRight .. textLeft;
            else
                --htmlstr = textLeft .. textRight;
                htmlstr = textRight .. textLeft;
            end
        end
    end
    htmlstr = string.gsub(htmlstr, "\n", "<br />");
    tooltipFrame:ClearLines();
    tooltipFrame:Hide();
    return htmlstr;	
end
