/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import unisql.jdbc.driver.UniSQLGloInputStream;
import unisql.jdbc.driver.UniSQLGloOutputStream;
import unisql.jdbc.driver.UniSQLGloReader;
import unisql.jdbc.driver.UniSQLGloWriter;
import unisql.sql.UniSQLOID;

public class UniSQLClob
extends UniSQLOID
implements Clob {
    static final int READ_CHAR_BUFFER_SIZE = 8192;
    private static final int READ_BYTE_BUFFER_SIZE = 8193;
    private String charsetName;
    private StringBuffer clobData;
    private int clobByteLength;
    private int clobLength;
    private int gloNextReadPos;
    private int gloPos;
    private int clobPos;
    private byte[] byteBuffer;
    private boolean end_of_glo;

    public UniSQLClob(UniSQLOID uniSQLOID, String string) {
        super(uniSQLOID);
        this.charsetName = string;
        this.clobData = new StringBuffer("");
        this.gloNextReadPos = 1;
        this.clobPos = 0;
        this.end_of_glo = false;
        this.clobLength = -1;
        this.clobByteLength = -1;
        this.byteBuffer = new byte[8193];
    }

    public synchronized long length() throws SQLException {
        this.read_clob_part(Integer.MAX_VALUE, 1);
        return this.clobLength;
    }

    public synchronized String getSubString(long l, int n) throws SQLException {
        if (l < 1L) {
            throw new IndexOutOfBoundsException();
        }
        if (n <= 0) {
            return "";
        }
        int n2 = this.read_clob_part((int)l, n);
        return this.clobData.substring(0, n2);
    }

    public synchronized Reader getCharacterStream() throws SQLException {
        return new UniSQLGloReader(this);
    }

    public InputStream getAsciiStream() throws SQLException {
        return new UniSQLGloInputStream(this);
    }

    public synchronized long position(String string, long l) throws SQLException {
        byte[] byArray = this.string2bytes(string);
        return this.gloBinarySearch(l, byArray, 0, byArray.length);
    }

    public synchronized long position(Clob clob, long l) throws SQLException {
        String string = clob.getSubString(1L, 4096);
        return this.position(string, l);
    }

    public synchronized int setString(long l, String string) throws SQLException {
        if (string == null || string.length() <= 0) {
            return 0;
        }
        if (l < 1L) {
            throw new IndexOutOfBoundsException();
        }
        int n = this.read_clob_part((int)l, string.length());
        byte[] byArray = this.string2bytes(string);
        if (n < string.length()) {
            if (n > 0) {
                this.gloTruncate(this.gloPos);
            }
            this.clobData.setLength(0);
            this.clobByteLength = this.gloPos - 1;
            this.clobLength = this.clobPos - 1;
            this.gloNextReadPos = this.gloPos;
            int n2 = (int)l - this.clobPos - this.clobData.length();
            int n3 = this.clobByteLength + n2 + 1;
            this.gloWrite(n3, byArray, 0, byArray.length);
            this.clobByteLength = n3 + byArray.length - 1;
            this.clobLength += n2 + string.length();
        } else {
            int n4 = this.string2bytes(this.clobData.substring(0, string.length())).length;
            if (n4 < byArray.length) {
                this.gloWrite(this.gloPos, byArray, 0, n4);
                this.gloInsert(this.gloPos + n4, byArray, n4, byArray.length - n4);
            } else {
                int n5 = n4 - byArray.length;
                this.gloWrite(this.gloPos, byArray, 0, byArray.length);
                if (n5 > 0) {
                    this.gloDelete(this.gloPos + byArray.length, n5);
                }
            }
            this.clobData.setLength(0);
            this.clobData.append(string);
            this.gloNextReadPos = this.gloPos + byArray.length;
        }
        return string.length();
    }

    public synchronized int setString(long l, String string, int n, int n2) throws SQLException {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (string == null || n2 <= 0) {
            return 0;
        }
        if (n + n2 >= string.length()) {
            if (n != 0) {
                string = string.substring(n);
            }
        } else {
            string = string.substring(n, n2);
        }
        return this.setString(l, string);
    }

    public synchronized OutputStream setAsciiStream(long l) throws SQLException {
        int n = this.read_clob_part((int)l, 10);
        int n2 = n <= 0 ? this.clobByteLength + (int)l - this.clobPos - this.clobData.length() + 1 : this.gloPos;
        return new UniSQLGloOutputStream(this, n2);
    }

    public synchronized Writer setCharacterStream(long l) throws SQLException {
        return new UniSQLGloWriter(this, (int)l);
    }

    public synchronized void truncate(long l) throws SQLException {
        if (l < 0L) {
            return;
        }
        if (this.read_clob_part((int)l, 1) <= 0) {
            return;
        }
        this.clobData.setLength(1);
        this.clobByteLength = this.gloPos - 1 + this.string2bytes(this.clobData.toString()).length;
        this.gloNextReadPos = this.clobByteLength + 1;
        this.clobLength = this.clobPos;
        this.gloTruncate(this.clobByteLength);
    }

    synchronized int getChars(int n, int n2, char[] cArray, int n3) throws SQLException {
        if (n2 <= 0) {
            return 0;
        }
        int n4 = this.read_clob_part(n, n2);
        this.clobData.getChars(0, n4, cArray, n3);
        return n4;
    }

    private int read_clob_part(int n, int n2) throws SQLException {
        if (this.clobLength >= 0 && n > this.clobLength) {
            this.gloPos = this.gloNextReadPos = this.clobByteLength + 1;
            this.clobPos = this.clobLength + 1;
            this.clobData.setLength(0);
            return 0;
        }
        if (this.clobPos == 0 || n < this.clobPos) {
            this.gloNextReadPos = 1;
            this.gloPos = 1;
            this.clobPos = 1;
            this.clobData.setLength(0);
            this.glo_read();
        }
        while (n >= this.clobPos + this.clobData.length()) {
            this.gloPos = this.gloNextReadPos;
            this.clobPos += this.clobData.length();
            this.clobData.setLength(0);
            if (this.end_of_glo) {
                return 0;
            }
            this.glo_read();
        }
        int n3 = n - this.clobPos;
        if (n3 > 0) {
            this.clobPos = n;
            this.gloPos += this.string2bytes(this.clobData.substring(0, n3)).length;
            this.clobData.delete(0, n3);
        }
        while (n2 > this.clobData.length()) {
            if (this.end_of_glo) {
                return this.clobData.length();
            }
            this.glo_read();
        }
        return n2;
    }

    private void glo_read() throws SQLException {
        int n = this.gloRead(this.gloNextReadPos, 8193, this.byteBuffer, 0);
        this.gloNextReadPos += n;
        this.end_of_glo = n < 8193;
        StringBuffer stringBuffer = new StringBuffer(this.bytes2string(this.byteBuffer, 0, n));
        if (this.end_of_glo) {
            this.clobLength = this.clobPos + this.clobData.length() + stringBuffer.length() - 1;
            this.clobByteLength = this.gloNextReadPos - 1;
        } else {
            this.gloNextReadPos -= this.string2bytes(stringBuffer.substring(stringBuffer.length() - 1)).length;
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        this.clobData.append(stringBuffer);
    }

    private byte[] string2bytes(String string) throws SQLException {
        try {
            return string.getBytes(this.charsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.unknown, unsupportedEncodingException.getMessage());
        }
    }

    private String bytes2string(byte[] byArray, int n, int n2) throws SQLException {
        try {
            return new String(byArray, n, n2, this.charsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.unknown, unsupportedEncodingException.getMessage());
        }
    }
}

