/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import unisql.jdbc.driver.UniSQLConnectionPoolDataSource;

class UniSQLConnectionEventListener
implements ConnectionEventListener {
    private Vector availableConnections = new Vector();
    private UniSQLConnectionPoolDataSource cpds;

    UniSQLConnectionEventListener(UniSQLConnectionPoolDataSource uniSQLConnectionPoolDataSource) {
        this.cpds = uniSQLConnectionPoolDataSource;
    }

    public synchronized void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (pooledConnection == null) {
            return;
        }
        this.availableConnections.add(pooledConnection);
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (pooledConnection == null) {
            return;
        }
        try {
            pooledConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized Connection getConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection;
        if (this.availableConnections.size() <= 0) {
            pooledConnection = this.cpds.getPooledConnection(string, string2);
            pooledConnection.addConnectionEventListener(this);
            this.availableConnections.add(pooledConnection);
        }
        pooledConnection = (PooledConnection)this.availableConnections.remove(0);
        return pooledConnection.getConnection();
    }
}

