/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import unisql.jdbc.driver.UniSQLConnectionEventListener;
import unisql.jdbc.driver.UniSQLConnectionPoolDataSource;

abstract class UniSQLConnectionPoolManager {
    private static Hashtable connectionPooltable = new Hashtable();
    private static Hashtable poolDataSourceTable = new Hashtable();

    UniSQLConnectionPoolManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection getConnection(UniSQLConnectionPoolDataSource uniSQLConnectionPoolDataSource, String string, String string2) throws SQLException {
        UniSQLConnectionEventListener uniSQLConnectionEventListener;
        String string3 = uniSQLConnectionPoolDataSource.getDataSourceID(string);
        Hashtable hashtable = connectionPooltable;
        synchronized (hashtable) {
            uniSQLConnectionEventListener = (UniSQLConnectionEventListener)connectionPooltable.get(string3);
            if (uniSQLConnectionEventListener == null) {
                uniSQLConnectionEventListener = UniSQLConnectionPoolManager.addConnectionPool(string3, uniSQLConnectionPoolDataSource);
            }
        }
        return uniSQLConnectionEventListener.getConnection(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UniSQLConnectionPoolDataSource getConnectionPoolDataSource(String string) throws SQLException {
        UniSQLConnectionPoolDataSource uniSQLConnectionPoolDataSource;
        Hashtable hashtable = poolDataSourceTable;
        synchronized (hashtable) {
            uniSQLConnectionPoolDataSource = (UniSQLConnectionPoolDataSource)poolDataSourceTable.get(string);
            if (uniSQLConnectionPoolDataSource == null) {
                try {
                    InitialContext initialContext = new InitialContext();
                    uniSQLConnectionPoolDataSource = (UniSQLConnectionPoolDataSource)initialContext.lookup(string);
                }
                catch (NamingException namingException) {
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.unknown, namingException.toString());
                }
                poolDataSourceTable.put(string, uniSQLConnectionPoolDataSource);
            }
        }
        return uniSQLConnectionPoolDataSource;
    }

    private static UniSQLConnectionEventListener addConnectionPool(String string, UniSQLConnectionPoolDataSource uniSQLConnectionPoolDataSource) {
        UniSQLConnectionEventListener uniSQLConnectionEventListener = new UniSQLConnectionEventListener(uniSQLConnectionPoolDataSource);
        connectionPooltable.put(string, uniSQLConnectionEventListener);
        return uniSQLConnectionEventListener;
    }
}

