/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDDriver;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import unisql.jdbc.jci.UConnection;
import unisql.jdbc.jci.UJCIManager;

public class UniSQLDriver
implements Driver {
    static final int major_version = 7;
    static final int minor_version = 1;
    static final int patch_version = 0;
    static final int build_serial_number = 1014;
    static final String default_hostname = "localhost";
    static final int default_port = 3456;
    static final String default_user = "public";
    static final String default_password = "";
    private static final String CONNECTION_PROPERTY_CHARSET = "charset";

    public Connection connect(String string, Properties properties) throws SQLException {
        Properties properties2;
        String string2;
        String string3;
        String string4;
        int n;
        String string5;
        String string6;
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (string.toLowerCase().startsWith("jdbc:default:connection:")) {
            return this.defaultConnection();
        }
        try {
            string6 = string.substring(12);
            string5 = string6.substring(0, string6.indexOf(58));
            if (string5.length() == 0) {
                string5 = default_hostname;
            }
            n = (string6 = string6.substring(string6.indexOf(58) + 1)).indexOf(58) > 0 ? Integer.valueOf(string6.substring(0, string6.indexOf(58))) : 3456;
            string4 = (string6 = string6.substring(string6.indexOf(58) + 1)).substring(0, string6.indexOf(58));
            if (string4.length() == 0) {
                string4 = null;
            }
            if ((string3 = (string6 = string6.substring(string6.indexOf(58) + 1)).substring(0, string6.indexOf(58))).length() == 0) {
                string3 = null;
            }
            if ((string2 = (string6 = string6.substring(string6.indexOf(58) + 1)).substring(0, string6.indexOf(58))).length() == 0) {
                string2 = null;
            }
            string6 = string6.substring(string6.lastIndexOf(58) + 1);
            properties2 = this.make_param_info(string6);
        }
        catch (Exception exception) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url);
        }
        string6 = properties.getProperty("user");
        if (string6 != null) {
            string3 = string6;
        }
        if ((string6 = properties.getProperty("password")) != null) {
            string2 = string6;
        }
        if (string4 == null) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.no_dbname);
        }
        if (string3 == null) {
            string3 = default_user;
        }
        if (string2 == null) {
            string2 = default_password;
        }
        UConnection uConnection = UJCIManager.connect(string5, n, string4, string3, string2);
        string6 = properties.getProperty(CONNECTION_PROPERTY_CHARSET);
        if (string6 == null) {
            string6 = properties2.getProperty(CONNECTION_PROPERTY_CHARSET);
        }
        if (string6 != null) {
            try {
                uConnection.setCharset(string6);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("UnsupportedEncodingException : " + string6);
            }
        }
        return new CUBRIDConnection(uConnection, string, string3);
    }

    public Connection defaultConnection() throws SQLException {
        return null;
    }

    public boolean acceptsURL(String string) throws SQLException {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().startsWith("jdbc:unisql:") || string.toLowerCase().startsWith("jdbc:cubrid:") || string.toLowerCase().startsWith("jdbc:default:connection:");
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 7;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private Properties make_param_info(String string) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        int n = string.indexOf(63);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        do {
            String string2;
            if ((n = string.indexOf(38)) < 0) {
                string2 = string;
                string = null;
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            n = string2.indexOf(61);
            if (n < 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (string3.length() <= 0 || string4.length() <= 0) continue;
            properties.setProperty(string3, string4);
        } while (string != null);
        return properties;
    }

    static {
        try {
            DriverManager.registerDriver(new UniSQLDriver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            DriverManager.registerDriver(new CUBRIDDriver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

