/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import unisql.jdbc.driver.UniSQLResultSetWithoutQuery;
import unisql.jdbc.jci.UColumnInfo;

public class UniSQLResultSetMetaData
implements ResultSetMetaData {
    private String[] col_name;
    private int[] col_type;
    private int[] ele_type;
    private String[] col_type_name;
    private String[] ele_type_name;
    private int[] col_prec;
    private int[] col_scale;
    private String[] col_table;
    private int[] col_null;
    private String[] col_class_name;

    protected UniSQLResultSetMetaData(UColumnInfo[] uColumnInfoArray) {
        this.col_name = new String[uColumnInfoArray.length];
        this.col_type = new int[uColumnInfoArray.length];
        this.ele_type = new int[uColumnInfoArray.length];
        this.col_type_name = new String[uColumnInfoArray.length];
        this.ele_type_name = new String[uColumnInfoArray.length];
        this.col_prec = new int[uColumnInfoArray.length];
        this.col_scale = new int[uColumnInfoArray.length];
        this.col_table = new String[uColumnInfoArray.length];
        this.col_null = new int[uColumnInfoArray.length];
        this.col_class_name = new String[uColumnInfoArray.length];
        block44: for (int i = 0; i < uColumnInfoArray.length; ++i) {
            this.col_name[i] = uColumnInfoArray[i].getColumnName();
            this.col_prec[i] = uColumnInfoArray[i].getColumnPrecision();
            this.col_scale[i] = uColumnInfoArray[i].getColumnScale();
            this.col_table[i] = uColumnInfoArray[i].getClassName();
            this.col_type_name[i] = null;
            this.col_class_name[i] = uColumnInfoArray[i].getFQDN();
            this.col_null[i] = uColumnInfoArray[i].isNullable() ? 1 : 0;
            switch (uColumnInfoArray[i].getColumnType()) {
                case 1: {
                    this.col_type_name[i] = "CHAR";
                    this.col_type[i] = 1;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 2: {
                    this.col_type_name[i] = "VARCHAR";
                    this.col_type[i] = 12;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 5: {
                    if (this.col_prec[i] == 8) {
                        this.col_type_name[i] = "BIT";
                        this.col_type[i] = -7;
                        this.ele_type[i] = -1;
                        continue block44;
                    }
                    this.col_type_name[i] = "BIT";
                    this.col_type[i] = -2;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 6: {
                    this.col_type_name[i] = "BIT VARYING";
                    this.col_type[i] = -3;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 9: {
                    this.col_type_name[i] = "SMALLINT";
                    this.col_type[i] = 5;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 8: {
                    this.col_type_name[i] = "INTEGER";
                    this.col_type[i] = 4;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 11: {
                    this.col_type_name[i] = "FLOAT";
                    this.col_type[i] = 7;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 12: {
                    this.col_type_name[i] = "DOUBLE";
                    this.col_type[i] = 8;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 7: {
                    this.col_type_name[i] = "NUMERIC";
                    this.col_type[i] = 2;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 10: {
                    this.col_type_name[i] = "MONETARY";
                    this.col_type[i] = 8;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 13: {
                    this.col_type_name[i] = "DATE";
                    this.col_type[i] = 91;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 14: {
                    this.col_type_name[i] = "TIME";
                    this.col_type[i] = 92;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 15: {
                    this.col_type_name[i] = "TIMESTAMP";
                    this.col_type[i] = 93;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 0: {
                    this.col_type_name[i] = "";
                    this.col_type[i] = 1111;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 19: {
                    this.col_type_name[i] = "CLASS";
                    this.col_type[i] = 1111;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 16: {
                    this.col_type_name[i] = "SET";
                }
                case 17: {
                    if (this.col_type_name[i] == null) {
                        this.col_type_name[i] = "MULTISET";
                    }
                }
                case 18: {
                    if (this.col_type_name[i] == null) {
                        this.col_type_name[i] = "SEQUENCE";
                    }
                    this.col_type[i] = 1111;
                    switch (uColumnInfoArray[i].getCollectionBaseType()) {
                        case 1: {
                            this.ele_type[i] = 1;
                            this.ele_type_name[i] = "CHAR";
                            continue block44;
                        }
                        case 2: {
                            this.ele_type[i] = 12;
                            this.ele_type_name[i] = "VARCHAR";
                            continue block44;
                        }
                        case 5: {
                            if (uColumnInfoArray[i].getColumnPrecision() == 8) {
                                this.ele_type[i] = -7;
                                this.ele_type_name[i] = "BIT";
                                continue block44;
                            }
                            this.ele_type[i] = -2;
                            this.ele_type_name[i] = "BIT";
                            continue block44;
                        }
                        case 6: {
                            this.ele_type[i] = -3;
                            this.ele_type_name[i] = "BIT VARYING";
                            continue block44;
                        }
                        case 9: {
                            this.ele_type[i] = 5;
                            this.ele_type_name[i] = "SMALLINT";
                            continue block44;
                        }
                        case 8: {
                            this.ele_type[i] = 4;
                            this.ele_type_name[i] = "INTEGER";
                            continue block44;
                        }
                        case 11: {
                            this.ele_type[i] = 7;
                            this.ele_type_name[i] = "FLOAT";
                            continue block44;
                        }
                        case 12: {
                            this.ele_type[i] = 8;
                            this.ele_type_name[i] = "DOUBLE";
                            continue block44;
                        }
                        case 7: {
                            this.ele_type[i] = 2;
                            this.ele_type_name[i] = "NUMERIC";
                            continue block44;
                        }
                        case 10: {
                            this.ele_type[i] = 8;
                            this.ele_type_name[i] = "MONETARY";
                            continue block44;
                        }
                        case 13: {
                            this.ele_type[i] = 91;
                            this.ele_type_name[i] = "DATE";
                            continue block44;
                        }
                        case 14: {
                            this.ele_type[i] = 92;
                            this.ele_type_name[i] = "TIME";
                            continue block44;
                        }
                        case 15: {
                            this.ele_type[i] = 93;
                            this.ele_type_name[i] = "TIMESTAMP";
                            continue block44;
                        }
                        case 0: {
                            this.ele_type[i] = 0;
                            this.ele_type_name[i] = "";
                            continue block44;
                        }
                        case 19: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "CLASS";
                            continue block44;
                        }
                        case 16: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "SET";
                            continue block44;
                        }
                        case 17: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "MULTISET";
                            continue block44;
                        }
                        case 18: {
                            this.ele_type[i] = 1111;
                            this.ele_type_name[i] = "SEQUENCE";
                            continue block44;
                        }
                        case 3: {
                            this.ele_type[i] = 1;
                            this.ele_type_name[i] = "NCHAR";
                            continue block44;
                        }
                        case 4: {
                            this.ele_type[i] = 12;
                            this.ele_type_name[i] = "NCHAR VARYING";
                            continue block44;
                        }
                    }
                    continue block44;
                }
                case 3: {
                    this.col_type_name[i] = "NCHAR";
                    this.col_type[i] = 1;
                    this.ele_type[i] = -1;
                    continue block44;
                }
                case 4: {
                    this.col_type_name[i] = "NCHAR VARYING";
                    this.col_type[i] = 12;
                    this.ele_type[i] = -1;
                    continue block44;
                }
            }
        }
    }

    UniSQLResultSetMetaData(UniSQLResultSetWithoutQuery uniSQLResultSetWithoutQuery) {
        this.col_name = uniSQLResultSetWithoutQuery.column_name;
        this.col_type = new int[this.col_name.length];
        this.ele_type = new int[this.col_name.length];
        this.col_type_name = new String[this.col_name.length];
        this.col_prec = new int[this.col_name.length];
        this.col_scale = new int[this.col_name.length];
        this.col_table = new String[this.col_name.length];
        this.col_null = new int[this.col_name.length];
        this.col_class_name = new String[this.col_name.length];
        for (int i = 0; i < this.col_name.length; ++i) {
            if (uniSQLResultSetWithoutQuery.type[i] == 5) {
                this.col_type[i] = -7;
                this.col_type_name[i] = "BIT";
                this.col_prec[i] = 1;
                this.col_class_name[i] = "byte[]";
            }
            if (uniSQLResultSetWithoutQuery.type[i] == 8) {
                this.col_type[i] = 4;
                this.col_type_name[i] = "INTEGER";
                this.col_prec[i] = 10;
                this.col_class_name[i] = "java.lang.Integer";
            }
            if (uniSQLResultSetWithoutQuery.type[i] == 9) {
                this.col_type[i] = 5;
                this.col_type_name[i] = "SMALLINT";
                this.col_prec[i] = 5;
                this.col_class_name[i] = "java.lang.Short";
            }
            if (uniSQLResultSetWithoutQuery.type[i] == 2) {
                this.col_type[i] = 12;
                this.col_type_name[i] = "VARCHAR";
                this.col_prec[i] = 0;
                this.col_class_name[i] = "java.lang.String";
            }
            if (uniSQLResultSetWithoutQuery.type[i] == 0) {
                this.col_type[i] = 0;
                this.col_type_name[i] = "";
                this.col_prec[i] = 0;
                this.col_class_name[i] = "";
            }
            this.col_scale[i] = 0;
            this.ele_type[i] = -1;
            this.col_table[i] = "";
            this.col_null[i] = uniSQLResultSetWithoutQuery.nullable[i] ? 1 : 0;
        }
    }

    public int getColumnCount() throws SQLException {
        return this.col_name.length;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_type[n - 1] == 1 || this.col_type[n - 1] == 12 || this.col_type[n - 1] == -1;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_type[n - 1] == 8 || this.col_type[n - 1] == 7 || this.col_type[n - 1] == 2;
    }

    public int isNullable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_null[n - 1];
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_type[n - 1] == 5 || this.col_type[n - 1] == 4 || this.col_type[n - 1] == 2 || this.col_type[n - 1] == 7 || this.col_type[n - 1] == 8;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.getPrecision(n);
    }

    public String getColumnLabel(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_name[n - 1];
    }

    public String getSchemaName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_prec[n - 1];
    }

    public int getScale(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_scale[n - 1];
    }

    public String getTableName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_table[n - 1];
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_type[n - 1];
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_type_name[n - 1];
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return true;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public String getColumnClassName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.col_class_name[n - 1];
    }

    public int getElementType(int n) throws SQLException {
        this.checkColumnIndex(n);
        String string = this.getColumnTypeName(n);
        if (!(string.equals("SET") || string.equals("MULTISET") || string.equals("SEQUENCE"))) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.not_collection);
        }
        return this.ele_type[n - 1];
    }

    public String getElementTypeName(int n) throws SQLException {
        this.checkColumnIndex(n);
        String string = this.getColumnTypeName(n);
        if (!(string.equals("SET") || string.equals("MULTISET") || string.equals("SEQUENCE"))) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.not_collection);
        }
        return this.ele_type_name[n - 1];
    }

    private void checkColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.col_name.length) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_index);
        }
    }
}

