/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import javax.transaction.xa.Xid;
import unisql.jdbc.driver.UniSQLConnection;
import unisql.jdbc.driver.UniSQLXid;
import unisql.jdbc.jci.UAParameter;
import unisql.jdbc.jci.UBatchResult;
import unisql.jdbc.jci.UError;
import unisql.jdbc.jci.UInputBuffer;
import unisql.jdbc.jci.UJCIManager;
import unisql.jdbc.jci.UJCIUtil;
import unisql.jdbc.jci.UJciException;
import unisql.jdbc.jci.UOutputBuffer;
import unisql.jdbc.jci.UPutByOIDParameter;
import unisql.jdbc.jci.UStatement;
import unisql.sql.UniSQLOID;

public class UConnection {
    public static final byte DBMS_UNISQL = 1;
    public static final byte DBMS_UNISQL_MMDB = 2;
    public static final byte PREPARE_INCLUDE_OID = 1;
    public static final byte PREPARE_UPDATABLE = 2;
    public static final byte PREPARE_CALL = 64;
    public static final byte DROP_BY_OID = 1;
    public static final byte IS_INSTANCE = 2;
    public static final byte GET_READ_LOCK_BY_OID = 3;
    public static final byte GET_WRITE_LOCK_BY_OID = 4;
    public static final byte GET_CLASS_NAME_BY_OID = 5;
    public static final byte IS_GLO_INSTANCE = 6;
    public static final int OID_BYTE_SIZE = 8;
    public static final byte GLO_CMD_READ_DATA = 1;
    public static final byte GLO_CMD_WRITE_DATA = 2;
    public static final byte GLO_CMD_INSERT_DATA = 3;
    public static final byte GLO_CMD_DELETE_DATA = 4;
    public static final byte GLO_CMD_TRUNCATE_DATA = 5;
    public static final byte GLO_CMD_APPEND_DATA = 6;
    public static final byte GLO_CMD_DATA_SIZE = 7;
    public static final byte GLO_CMD_COMPRESS_DATA = 8;
    public static final byte GLO_CMD_DESTROY_DATA = 9;
    public static final byte GLO_CMD_LIKE_SEARCH = 10;
    public static final byte GLO_CMD_REG_SEARCH = 11;
    public static final byte GLO_CMD_BINARY_SEARCH = 12;
    public static final byte GLO_NEW_TYPE_LO = 1;
    public static final byte GLO_NEW_TYPE_FBO = 2;
    private static final byte jci_major_version = 3;
    private static final byte jci_minor_version = 5;
    private static final String clientName = "JDBC";
    private static final byte GET_COLLECTION_VALUE = 1;
    private static final byte GET_SIZE_OF_COLLECTION = 2;
    private static final byte DROP_ELEMENT_IN_SET = 3;
    private static final byte ADD_ELEMENT_TO_SET = 4;
    private static final byte DROP_ELEMENT_IN_SEQUENCE = 5;
    private static final byte INSERT_ELEMENT_INTO_SEQUENCE = 6;
    private static final byte PUT_ELEMENT_ON_SEQUENCE = 7;
    private static final int DB_PARAM_ISOLATION_LEVEL = 1;
    private static final int DB_PARAM_LOCK_TIMEOUT = 2;
    private static final byte END_TRAN_COMMIT = 1;
    private static final byte END_TRAN_ROLLBACK = 2;
    private static final byte CON_STATUS_OUT_TRAN = 0;
    private static final byte CON_STATUS_IN_TRAN = 1;
    private static final int LOCK_TIMEOUT_NOT_USED = -2;
    private static final int LOCK_TIMEOUT_INFINITE = -1;
    String conCharsetName;
    UOutputBuffer outBuffer;
    UniSQLConnection unisqlcon;
    private OutputStream out;
    private InputStream in;
    private boolean needReconnection;
    private DataInputStream input;
    private DataOutputStream output;
    private String CASIp;
    private int CASPort;
    private int processId;
    private Socket client;
    private UError errorHandler;
    private Vector transactionList;
    private boolean isClosed = false;
    private byte[] dbInfo;
    private int lastIsolationLevel;
    private int lastLockTimeout = -2;
    private String dbname;
    private String user;
    private String passwd;
    private byte[] broker_info = null;
    private byte con_status = 0;
    private boolean isServerSideJdbc = false;
    private static byte[] driverInfo = new byte[10];

    UConnection(String string, int n, String string2, String string3, String string4) throws CUBRIDException {
        this.CASIp = string;
        this.CASPort = n;
        this.dbname = string2;
        this.user = string3;
        this.passwd = string4;
        this.needReconnection = true;
        this.conCharsetName = UJCIManager.sysCharsetName;
        String string5 = this.getDatabaseProductVersion();
        UError uError = this.errorHandler;
        this.endTransaction(true);
        if (string5 == null) {
            throw new CUBRIDException(uError);
        }
    }

    UConnection(String string, int n) throws UJciException {
        this.errorHandler = new UError();
        this.CASIp = string;
        this.CASPort = n;
        this.initConnection(string, n);
        this.needReconnection = false;
        this.conCharsetName = UJCIManager.sysCharsetName;
    }

    private void initConnection(Socket socket) throws UJciException {
        try {
            this.client = socket;
            this.client.setTcpNoDelay(true);
            this.out = this.client.getOutputStream();
            this.output = new DataOutputStream(this.client.getOutputStream());
            this.output.writeInt(8);
            this.out.flush();
            this.output.flush();
            this.in = this.client.getInputStream();
            this.input = new DataInputStream(this.client.getInputStream());
        }
        catch (IOException iOException) {
            throw new UJciException(13);
        }
    }

    public void setCharset(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return;
        }
        byte[] byArray = new byte[]{0};
        String string2 = new String(byArray, string);
        this.conCharsetName = string;
    }

    public String getCharset() {
        return this.conCharsetName;
    }

    public synchronized void addElementToSet(UniSQLOID uniSQLOID, String string, Object object) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.manageElementOfSet(uniSQLOID, string, object, (byte)4);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return;
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
            return;
        }
    }

    public synchronized UBatchResult batchExecute(String[] stringArray) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        if (stringArray == null) {
            this.errorHandler.setErrorCode(16);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.out, (byte)20);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) {
                    this.outBuffer.addStringWithNull(stringArray[i]);
                    continue;
                }
                this.outBuffer.addNull();
            }
            UInputBuffer uInputBuffer = this.send_recv_msg();
            UBatchResult uBatchResult = new UBatchResult(uInputBuffer.readInt());
            for (int i = 0; i < uBatchResult.getResultNumber(); ++i) {
                uBatchResult.setStatementType(i, uInputBuffer.readByte());
                int n = uInputBuffer.readInt();
                if (n < 0) {
                    uBatchResult.setResultError(i, n, uInputBuffer.readString(uInputBuffer.readInt(), UJCIManager.sysCharsetName));
                    continue;
                }
                uBatchResult.setResult(i, n);
                uInputBuffer.readInt();
                uInputBuffer.readShort();
                uInputBuffer.readShort();
            }
            this.transactionList.add(null);
            return uBatchResult;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return null;
    }

    public synchronized void close() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        this.clearTransactionList();
        this.transactionList = null;
        if (this.client != null) {
            this.disconnect();
        }
        if (!this.isServerSideJdbc) {
            try {
                if (this.client != null) {
                    this.clientSocketClose();
                }
            }
            catch (IOException iOException) {
                this.errorHandler.setErrorMessage(3, iOException.getMessage() + "in close");
            }
        }
        this.isClosed = true;
    }

    public synchronized void dropElementInSequence(UniSQLOID uniSQLOID, String string, int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.out, (byte)18);
            this.outBuffer.addByte((byte)5);
            this.outBuffer.addOID(uniSQLOID);
            this.outBuffer.addInt(n);
            if (string == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(string);
            }
            UInputBuffer uInputBuffer = this.send_recv_msg();
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
    }

    public synchronized void dropElementInSet(UniSQLOID uniSQLOID, String string, Object object) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.manageElementOfSet(uniSQLOID, string, object, (byte)3);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return;
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void endTransaction(boolean bl) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.clearTransactionList();
            if (this.client != null) {
                this.checkReconnect();
                if (this.errorHandler.getErrorCode() != 0) {
                    return;
                }
                this.outBuffer.newRequest(this.out, (byte)1);
                this.outBuffer.addByte(bl ? (byte)1 : 2);
                UInputBuffer uInputBuffer = this.send_recv_msg();
                if (this.brokerInfoKeepConnection()) {
                    // empty if block
                }
            }
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        catch (Exception exception) {
            this.errorHandler.setErrorMessage(23, exception.getMessage());
        }
        if (this.errorHandler.getErrorCode() != 0 || !this.brokerInfoKeepConnection()) {
            if (!bl) {
                this.errorHandler.clear();
            }
            try {
                this.clientSocketClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.needReconnection = true;
        }
        this.con_status = 0;
    }

    public synchronized UStatement getByOID(UniSQLOID uniSQLOID, String[] stringArray) {
        UStatement uStatement = null;
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.out, (byte)10);
            this.outBuffer.addOID(uniSQLOID);
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                if (stringArray[i] != null) {
                    this.outBuffer.addStringWithNull(stringArray[i]);
                    continue;
                }
                this.outBuffer.addNull();
            }
            UInputBuffer uInputBuffer = this.send_recv_msg();
            uStatement = new UStatement(this, uniSQLOID, stringArray, uInputBuffer);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
            return null;
        }
        if (uStatement.getRecentError().getErrorCode() != 0) {
            this.errorHandler.copyValue(uStatement.getRecentError());
            return null;
        }
        this.transactionList.add(uStatement);
        return uStatement;
    }

    public synchronized String getDatabaseProductVersion() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.out, (byte)15);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            return uInputBuffer.readString(uInputBuffer.remainedCapacity(), UJCIManager.sysCharsetName);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return null;
    }

    public synchronized int getIsolationLevel() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return 0;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return 0;
            }
            this.outBuffer.newRequest(this.out, (byte)4);
            this.outBuffer.addInt(1);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            return uInputBuffer.readInt();
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return 0;
    }

    public UError getRecentError() {
        return this.errorHandler;
    }

    public synchronized UStatement getSchemaInfo(int n, String string, String string2, byte by) {
        UStatement uStatement = null;
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        if (n < 1 || n > 15) {
            this.errorHandler.setErrorCode(11);
            return null;
        }
        if (by < 0 || by > 3) {
            this.errorHandler.setErrorCode(18);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.out, (byte)9);
            this.outBuffer.addInt(n);
            if (string == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(string);
            }
            if (string2 == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(string2);
            }
            this.outBuffer.addByte(by);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            uStatement = new UStatement(this, string, string2, n, uInputBuffer);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
        catch (IOException iOException) {
            if (this.errorHandler.getErrorCode() != 13) {
                this.errorHandler.setErrorCode(3);
            }
            return null;
        }
        if (uStatement.getRecentError().getErrorCode() != 0) {
            this.errorHandler.copyValue(uStatement.getRecentError());
            return null;
        }
        return uStatement;
    }

    public synchronized int getSizeOfCollection(UniSQLOID uniSQLOID, String string) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return 0;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return 0;
            }
            this.outBuffer.newRequest(this.out, (byte)18);
            this.outBuffer.addByte((byte)2);
            this.outBuffer.addOID(uniSQLOID);
            if (string == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(string);
            }
            UInputBuffer uInputBuffer = this.send_recv_msg();
            return uInputBuffer.readInt();
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return 0;
    }

    public synchronized UniSQLOID gloNew(String string, byte by, String string2) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.out, (byte)12);
            this.outBuffer.addStringWithNull(string);
            this.outBuffer.addByte((byte)2);
            this.outBuffer.addByte(by);
            if (string2 == null) {
                this.outBuffer.addNull();
            } else {
                this.outBuffer.addStringWithNull(string2);
            }
            UInputBuffer uInputBuffer = this.send_recv_msg();
            return uInputBuffer.readOID(this.unisqlcon);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return null;
    }

    public synchronized void insertElementIntoSequence(UniSQLOID uniSQLOID, String string, int n, Object object) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.manageElementOfSequence(uniSQLOID, string, n, object, (byte)6);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return;
        }
        catch (IOException iOException) {
            if (this.errorHandler.getErrorCode() != 13) {
                this.errorHandler.setErrorCode(3);
            }
            return;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized UStatement prepare(String string, byte by) {
        UStatement uStatement = null;
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.out, (byte)2);
            this.outBuffer.addStringWithNull(string);
            this.outBuffer.addByte(by);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            uStatement = new UStatement(this, uInputBuffer);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
        catch (IOException iOException) {
            if (this.errorHandler.getErrorCode() != 13) {
                this.errorHandler.setErrorCode(3);
            }
            return null;
        }
        if (uStatement.getRecentError().getErrorCode() != 0) {
            this.errorHandler.copyValue(uStatement.getRecentError());
            return null;
        }
        this.transactionList.add(uStatement);
        return uStatement;
    }

    public synchronized void putByOID(UniSQLOID uniSQLOID, String[] stringArray, Object[] objectArray) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (stringArray == null && objectArray == null) {
            this.errorHandler.setErrorCode(16);
            return;
        }
        try {
            UPutByOIDParameter uPutByOIDParameter = null;
            if (objectArray != null) {
                uPutByOIDParameter = new UPutByOIDParameter(stringArray, objectArray);
            }
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.out, (byte)11);
            this.outBuffer.addOID(uniSQLOID);
            if (uPutByOIDParameter != null) {
                uPutByOIDParameter.writeParameter(this.outBuffer);
            }
            UInputBuffer uInputBuffer = this.send_recv_msg();
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
    }

    public synchronized void putElementInSequence(UniSQLOID uniSQLOID, String string, int n, Object object) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.manageElementOfSequence(uniSQLOID, string, n, object, (byte)7);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return;
        }
        catch (IOException iOException) {
            if (this.errorHandler.getErrorCode() != 13) {
                this.errorHandler.setErrorCode(3);
            }
            return;
        }
    }

    public synchronized void setIsolationLevel(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (n < 1 || n > 6) {
            this.errorHandler.setErrorCode(14);
            return;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.out, (byte)5);
            this.outBuffer.addInt(1);
            this.outBuffer.addInt(n);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            this.lastIsolationLevel = n;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
    }

    public synchronized void setLockTimeout(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.out, (byte)5);
            this.outBuffer.addInt(2);
            this.outBuffer.addInt(n);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            this.lastLockTimeout = n < 0 ? -1 : n;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
    }

    public synchronized byte getDbmsType() {
        if (this.broker_info == null) {
            return 1;
        }
        return this.broker_info[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void xa_endTransaction(Xid xid, boolean bl) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.clearTransactionList();
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.out, (byte)30);
            this.outBuffer.addXid(xid);
            this.outBuffer.addByte(bl ? (byte)1 : 2);
            UInputBuffer uInputBuffer = this.send_recv_msg();
        }
        catch (Exception exception) {
            this.errorHandler.setErrorCode(23);
        }
        finally {
            try {
                this.clientSocketClose();
                this.needReconnection = true;
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void xa_prepare(Xid xid) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.out, (byte)28);
            this.outBuffer.addXid(xid);
            UInputBuffer uInputBuffer = this.send_recv_msg();
        }
        catch (Exception exception) {
            this.errorHandler.setErrorCode(23);
        }
    }

    public synchronized Xid[] xa_recover() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.out, (byte)29);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            int n = uInputBuffer.getResCode();
            Xid[] xidArray = new UniSQLXid[n];
            for (int i = 0; i < n; ++i) {
                xidArray[i] = uInputBuffer.readXid();
            }
            return xidArray;
        }
        catch (Exception exception) {
            this.errorHandler.setErrorCode(23);
            return null;
        }
    }

    public void setUniSQLConnection(UniSQLConnection uniSQLConnection) {
        this.unisqlcon = uniSQLConnection;
        this.lastIsolationLevel = 0;
        this.lastLockTimeout = -2;
    }

    public UniSQLConnection getUniSQLConnection() {
        return this.unisqlcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean check_cas() {
        if (this.isClosed) {
            return true;
        }
        if (this.client == null || this.needReconnection) {
            return true;
        }
        try {
            InputStream inputStream = this.in;
            synchronized (inputStream) {
                this.output.writeInt(1);
                this.output.write(32);
                int n = this.input.readInt();
                if (n < 4) {
                    return false;
                }
                n = this.input.readInt();
                if (n < 0) {
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public synchronized void reset_connection() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.client = null;
        this.needReconnection = true;
    }

    public synchronized Object oidCmd(UniSQLOID uniSQLOID, byte by) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return null;
            }
            this.outBuffer.newRequest(this.out, (byte)17);
            this.outBuffer.addByte(by);
            this.outBuffer.addOID(uniSQLOID);
            UInputBuffer uInputBuffer = this.send_recv_msg();
            int n = uInputBuffer.getResCode();
            if (by == 2 || by == 6) {
                if (n == 1) {
                    return uniSQLOID;
                }
            } else if (by == 5) {
                return uInputBuffer.readString(uInputBuffer.remainedCapacity(), this.conCharsetName);
            }
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return null;
    }

    public synchronized int gloCmd(UniSQLOID uniSQLOID, byte by, int n, int n2, byte[] byArray, int n3) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return 0;
        }
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return 0;
            }
            this.outBuffer.newRequest(this.out, (byte)25);
            this.outBuffer.addByte(by);
            this.outBuffer.addOID(uniSQLOID);
            if (by != 7) {
                if (by == 1 || by == 4) {
                    this.outBuffer.addInt(n);
                    this.outBuffer.addInt(n2);
                } else if (by == 2 || by == 3 || by == 12) {
                    this.outBuffer.addInt(n);
                    this.outBuffer.addBytes(byArray, n3, n2);
                } else if (by == 5) {
                    this.outBuffer.addInt(n);
                }
            }
            UInputBuffer uInputBuffer = this.send_recv_msg();
            int n4 = uInputBuffer.getResCode();
            if (by == 1) {
                uInputBuffer.readBytes(byArray, n3, n4);
            } else if (by == 12) {
                n4 = uInputBuffer.readInt();
            }
            return n4;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
        return 0;
    }

    private void clientSocketClose() throws IOException {
        try {
            this.needReconnection = true;
            if (this.client != null) {
                this.client.setSoLinger(true, 0);
                this.client.close();
            }
            this.client = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    UInputBuffer send_recv_msg() throws UJciException, IOException {
        this.outBuffer.sendData();
        return new UInputBuffer(this.in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void cancel() throws UJciException, IOException {
        UConnection uConnection = null;
        try {
            uConnection = new UConnection(this.CASIp, this.CASPort);
            String string = "CANCEL";
            uConnection.output.write(string.getBytes());
            uConnection.output.writeInt(this.processId);
            uConnection.output.flush();
            int n = uConnection.input.readInt();
            if (n < 0) {
                throw new UJciException(2, n, null);
            }
            Object var5_4 = null;
            if (uConnection == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (uConnection == null) throw throwable;
            uConnection.clientSocketClose();
            uConnection.close();
            throw throwable;
        }
        uConnection.clientSocketClose();
        uConnection.close();
    }

    private void reconnect() throws IOException, UJciException {
        this.initConnection(this.CASIp, this.CASPort);
        this.sendDriverInfo();
        this.whetherConnectOtherPortOrNot();
        this.connectDB();
        this.needReconnection = false;
        if (this.lastIsolationLevel != 0) {
            this.setIsolationLevel(this.lastIsolationLevel);
        }
        if (this.lastLockTimeout != -2) {
            this.setLockTimeout(this.lastLockTimeout);
        }
    }

    private boolean brokerInfoKeepConnection() {
        if (this.broker_info == null) {
            return false;
        }
        return this.broker_info[1] == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectDB() throws IOException, UJciException {
        DataOutputStream dataOutputStream = this.output;
        synchronized (dataOutputStream) {
            this.output.write(this.dbInfo);
            this.output.flush();
            DataInputStream dataInputStream = this.input;
            synchronized (dataInputStream) {
                InputStream inputStream = this.in;
                synchronized (inputStream) {
                    UInputBuffer uInputBuffer = new UInputBuffer(this.in);
                    this.processId = uInputBuffer.getResCode();
                    if (uInputBuffer.remainedCapacity() >= 4) {
                        if (this.broker_info == null) {
                            this.broker_info = new byte[4];
                        }
                        uInputBuffer.readBytes(this.broker_info);
                    }
                }
            }
        }
    }

    private void initConnection(String string, int n) throws UJciException {
        try {
            this.client = new Socket(InetAddress.getByName(string), n);
            this.client.setTcpNoDelay(true);
            this.out = this.client.getOutputStream();
            this.output = new DataOutputStream(this.client.getOutputStream());
            this.out.flush();
            this.output.flush();
            this.in = this.client.getInputStream();
            this.input = new DataInputStream(this.client.getInputStream());
        }
        catch (IOException iOException) {
            throw new UJciException(13);
        }
    }

    private void manageElementOfSequence(UniSQLOID uniSQLOID, String string, int n, Object object, byte by) throws UJciException, IOException {
        UAParameter uAParameter = new UAParameter(string, object);
        this.checkReconnect();
        if (this.errorHandler.getErrorCode() != 0) {
            return;
        }
        this.outBuffer.newRequest(this.out, (byte)18);
        this.outBuffer.addByte(by);
        this.outBuffer.addOID(uniSQLOID);
        this.outBuffer.addInt(n);
        uAParameter.writeParameter(this.outBuffer);
        UInputBuffer uInputBuffer = this.send_recv_msg();
    }

    private void manageElementOfSet(UniSQLOID uniSQLOID, String string, Object object, byte by) throws UJciException, IOException {
        UAParameter uAParameter = new UAParameter(string, object);
        this.checkReconnect();
        if (this.errorHandler.getErrorCode() != 0) {
            return;
        }
        this.outBuffer.newRequest(this.out, (byte)18);
        this.outBuffer.addByte(by);
        this.outBuffer.addOID(uniSQLOID);
        uAParameter.writeParameter(this.outBuffer);
        UInputBuffer uInputBuffer = this.send_recv_msg();
    }

    private void checkReconnect() throws IOException, UJciException {
        if (this.dbInfo == null) {
            this.dbInfo = new byte[96];
            UJCIUtil.copy_byte(this.dbInfo, 0, 32, this.dbname);
            UJCIUtil.copy_byte(this.dbInfo, 32, 32, this.user);
            UJCIUtil.copy_byte(this.dbInfo, 64, 32, this.passwd);
            this.dbInfo[this.dbInfo.length - 1] = 0;
        }
        if (this.outBuffer == null) {
            this.outBuffer = new UOutputBuffer(this);
        }
        if (this.transactionList == null) {
            this.transactionList = new Vector();
        }
        if (!this.isServerSideJdbc) {
            if (this.con_status == 0 && !this.check_cas()) {
                this.clientSocketClose();
            }
            if (this.needReconnection) {
                this.reconnect();
            }
        }
        this.con_status = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDriverInfo() throws IOException {
        DataOutputStream dataOutputStream = this.output;
        synchronized (dataOutputStream) {
            this.output.write(driverInfo);
            this.output.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void whetherConnectOtherPortOrNot() throws IOException, UJciException {
        int n = 0;
        DataInputStream dataInputStream = this.input;
        synchronized (dataInputStream) {
            n = this.input.readInt();
        }
        if (n < 0) {
            throw new UJciException(2, n, null);
        }
        if (n == 0) {
            return;
        }
        this.client.setSoLinger(true, 0);
        this.client.close();
        this.initConnection(this.CASIp, n);
    }

    private void disconnect() {
        try {
            this.checkReconnect();
            if (this.errorHandler.getErrorCode() != 0) {
                return;
            }
            this.outBuffer.newRequest(this.out, (byte)31);
            UInputBuffer uInputBuffer = this.send_recv_msg();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearTransactionList() {
        if (this.transactionList == null) {
            return;
        }
        try {
            while (!this.transactionList.isEmpty()) {
                UStatement uStatement = (UStatement)this.transactionList.remove(0);
                if (uStatement == null) continue;
                UStatement uStatement2 = uStatement;
                synchronized (uStatement2) {
                    uStatement.close();
                }
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            this.transactionList.clear();
        }
    }

    public boolean isServerSideJdbc() {
        return this.isServerSideJdbc;
    }

    static {
        UJCIUtil.copy_byte(driverInfo, 0, 8, clientName);
        UConnection.driverInfo[8] = 3;
        UConnection.driverInfo[9] = 5;
    }
}

