/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.jci;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import unisql.jdbc.jci.UJciException;
import unisql.sql.UniSQLOID;

public abstract class UGetTypeConvertedValue {
    public static BigDecimal getBigDecimal(Object object) throws UJciException {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof String) {
            try {
                return new BigDecimal((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UJciException(5);
            }
        }
        if (object instanceof Number) {
            return new BigDecimal(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return new BigDecimal((Boolean)object == true ? 1.0 : 0.0);
        }
        throw new UJciException(5);
    }

    public static boolean getBoolean(Object object) throws UJciException {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return ((String)object).compareTo("0") != 0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        if (object instanceof byte[]) {
            return ((byte[])object)[0] != 0;
        }
        throw new UJciException(5);
    }

    public static byte getByte(Object object) throws UJciException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof byte[]) {
            if (((byte[])object).length != 1) {
                throw new UJciException(5);
            }
            return ((byte[])object)[0];
        }
        if (object instanceof String) {
            try {
                return Byte.parseByte((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UJciException(5);
            }
        }
        if (object instanceof Boolean) {
            return (Boolean)object == true ? (byte)-128 : 0;
        }
        throw new UJciException(5);
    }

    public static byte[] getBytes(Object object) throws UJciException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])((byte[])object).clone();
        }
        throw new UJciException(5);
    }

    public static Date getDate(Object object) throws UJciException {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return new Date(((Date)object).getTime());
        }
        if (object instanceof Timestamp) {
            return new Date(((Timestamp)object).getTime());
        }
        if (object instanceof String) {
            try {
                return Date.valueOf((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UJciException(5);
            }
        }
        throw new UJciException(5);
    }

    public static double getDouble(Object object) throws UJciException {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            try {
                return Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UJciException(5);
            }
        }
        if (object instanceof Boolean) {
            return (Boolean)object == true ? 1.0 : 0.0;
        }
        throw new UJciException(5);
    }

    public static float getFloat(Object object) throws UJciException {
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof String) {
            try {
                return Float.parseFloat((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UJciException(5);
            }
        }
        if (object instanceof Boolean) {
            return (Boolean)object == true ? 1.0f : 0.0f;
        }
        throw new UJciException(5);
    }

    public static int getInt(Object object) throws UJciException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UJciException(5);
            }
        }
        if (object instanceof Boolean) {
            return (Boolean)object == true ? 1 : 0;
        }
        throw new UJciException(5);
    }

    public static long getLong(Object object) throws UJciException {
        if (object == null) {
            return 0L;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UJciException(5);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object == true ? 1L : 0L;
        }
        throw new UJciException(5);
    }

    public static short getShort(Object object) throws UJciException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            try {
                return Short.parseShort((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UJciException(5);
            }
        }
        if (object instanceof Boolean) {
            return (Boolean)object == true ? (short)1 : 0;
        }
        throw new UJciException(5);
    }

    public static String getString(Object object) throws UJciException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number || object instanceof Boolean || object instanceof Date || object instanceof Time) {
            return object.toString();
        }
        if (object instanceof Timestamp) {
            String string = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            return simpleDateFormat.format(object);
        }
        if (object instanceof UniSQLOID) {
            try {
                return ((UniSQLOID)object).getOidString();
            }
            catch (Exception exception) {
                return "";
            }
        }
        if (object instanceof byte[]) {
            return UGetTypeConvertedValue.getHexaDecimalString((byte[])object);
        }
        throw new UJciException(5);
    }

    public static Time getTime(Object object) throws UJciException {
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return new Time(((Time)object).getTime());
        }
        if (object instanceof String) {
            try {
                return Time.valueOf((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UJciException(5);
            }
        }
        if (object instanceof Timestamp) {
            return new Time(((Timestamp)object).getTime());
        }
        throw new UJciException(5);
    }

    public static Timestamp getTimestamp(Object object) throws UJciException {
        if (object == null) {
            return null;
        }
        if (object instanceof Timestamp) {
            return new Timestamp(((Timestamp)object).getTime());
        }
        if (object instanceof String) {
            try {
                return Timestamp.valueOf((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UJciException(5);
            }
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        if (object instanceof Time) {
            return new Timestamp(((Time)object).getTime());
        }
        throw new UJciException(5);
    }

    private static String getHexaDecimalString(byte[] byArray) {
        String string = "";
        short s = 0;
        for (int i = 0; i < byArray.length; ++i) {
            s = byArray[i] < 0 ? (short)((short)byArray[i] + 256) : (short)byArray[i];
            String string2 = "";
            for (int j = 0; j < 2; ++j) {
                int n = s % 16;
                string2 = (n < 10 ? String.valueOf(n) : (n == 10 ? "a" : (n == 11 ? "b" : (n == 12 ? "c" : (n == 13 ? "d" : (n == 14 ? "e" : "f")))))) + string2;
                s = (short)(s / 16);
            }
            string = string + string2;
        }
        return string;
    }
}

