/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.jci;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javax.transaction.xa.Xid;
import unisql.jdbc.jci.UConnection;
import unisql.jdbc.jci.UGetTypeConvertedValue;
import unisql.jdbc.jci.UJciException;
import unisql.jdbc.jci.UniSQLArray;
import unisql.sql.UniSQLOID;

class UOutputBuffer {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final int DEFAULT_CAPACITY = 100000;
    OutputStream outStream = null;
    private int length = 0;
    private int positionInABuffer;
    private int bufferCursor;
    private int allocatedBufferSize = 1;
    private byte[][] buffer = new byte[1024][];
    private UConnection u_con;

    UOutputBuffer(UConnection uConnection) {
        this.buffer[0] = new byte[100000];
        this.bufferCursor = 0;
        this.positionInABuffer = 0;
        this.u_con = uConnection;
    }

    void sendData() throws IOException {
        byte[] byArray = new byte[]{(byte)(this.length >>> 24 & 0xFF), (byte)(this.length >>> 16 & 0xFF), (byte)(this.length >>> 8 & 0xFF), (byte)(this.length >>> 0 & 0xFF)};
        this.outStream.write(byArray);
        this.outStream.flush();
        for (int i = 0; i < this.bufferCursor; ++i) {
            this.outStream.write(this.buffer[i]);
        }
        if (this.positionInABuffer > 0) {
            this.outStream.write(this.buffer[this.bufferCursor], 0, this.positionInABuffer);
        }
        this.outStream.flush();
        this.clearBuffer(this.outStream);
    }

    void newRequest(OutputStream outputStream, byte by) {
        this.clearBuffer(outputStream);
        this.writeByte(by);
    }

    void newRequest(byte by) {
        this.clearBuffer(this.outStream);
        this.writeByte(by);
    }

    int addInt(int n) {
        this.writeInt(4);
        this.writeInt(n);
        return 8;
    }

    int addByte(byte by) {
        this.writeInt(1);
        this.writeByte(by);
        return 5;
    }

    int addBytes(byte[] byArray) {
        return this.addBytes(byArray, 0, byArray.length);
    }

    int addBytes(byte[] byArray, int n, int n2) {
        this.writeInt(n2);
        this.writeBytes(byArray, n, n2);
        return n2 + 4;
    }

    int addNull() {
        this.writeInt(0);
        return 4;
    }

    int addStringWithNull(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes(this.u_con.conCharsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        this.writeInt(byArray.length + 1);
        this.writeBytes(byArray, 0, byArray.length);
        this.writeByte((byte)0);
        return byArray.length + 5;
    }

    int addDouble(double d) {
        this.writeInt(8);
        this.writeDouble(d);
        return 12;
    }

    int addShort(short s) {
        this.writeInt(2);
        this.writeShort(s);
        return 6;
    }

    int addFloat(float f) {
        this.writeInt(4);
        this.writeFloat(f);
        return 8;
    }

    int addDate(Date date) {
        this.writeInt(12);
        this.writeDate(date);
        return 16;
    }

    int addTime(Time time) {
        this.writeInt(12);
        this.writeTime(time);
        return 16;
    }

    int addTimestamp(Timestamp timestamp) {
        this.writeInt(12);
        this.writeTimestamp(timestamp);
        return 16;
    }

    int addOID(UniSQLOID uniSQLOID) {
        byte[] byArray = uniSQLOID.getOID();
        if (byArray == null || byArray.length != 8) {
            byArray = new byte[8];
        }
        this.writeInt(8);
        this.writeBytes(byArray, 0, byArray.length);
        return 12;
    }

    int addXid(Xid xid) {
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n = 12 + byArray.length + byArray2.length;
        this.writeInt(n);
        this.writeInt(xid.getFormatId());
        this.writeInt(byArray.length);
        this.writeInt(byArray2.length);
        this.writeBytes(byArray, 0, byArray.length);
        this.writeBytes(byArray2, 0, byArray2.length);
        return n;
    }

    void writeParameter(byte by, Object object) throws UJciException {
        if (object == null) {
            this.addNull();
            return;
        }
        switch (by) {
            case 0: {
                this.addNull();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                String string = UGetTypeConvertedValue.getString(object);
                this.addStringWithNull(string);
                break;
            }
            case 7: {
                String string = UGetTypeConvertedValue.getString(object);
                this.addStringWithNull(string);
                break;
            }
            case 5: 
            case 6: {
                if (object instanceof byte[] && ((byte[])object).length > 1) {
                    this.addBytes(UGetTypeConvertedValue.getBytes(object));
                    break;
                }
                this.addByte(UGetTypeConvertedValue.getByte(object));
                break;
            }
            case 10: 
            case 12: {
                this.addDouble(UGetTypeConvertedValue.getDouble(object));
                break;
            }
            case 13: {
                this.addDate(UGetTypeConvertedValue.getDate(object));
                break;
            }
            case 14: {
                this.addTime(UGetTypeConvertedValue.getTime(object));
                break;
            }
            case 15: {
                this.addTimestamp(UGetTypeConvertedValue.getTimestamp(object));
                break;
            }
            case 11: {
                this.addFloat(UGetTypeConvertedValue.getFloat(object));
                break;
            }
            case 9: {
                this.addShort(UGetTypeConvertedValue.getShort(object));
                break;
            }
            case 8: {
                this.addInt(UGetTypeConvertedValue.getInt(object));
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                if (!(object instanceof UniSQLArray)) {
                    throw new UJciException(5);
                }
                this.writeCollection((UniSQLArray)object);
                break;
            }
            case 19: {
                if (!(object instanceof UniSQLOID)) {
                    throw new UJciException(5);
                }
                this.addOID((UniSQLOID)object);
            }
        }
    }

    private void writeCollection(UniSQLArray uniSQLArray) {
        int n = 0;
        int n2 = this.bufferCursor;
        int n3 = this.positionInABuffer;
        this.writeInt(n);
        this.writeByte((byte)uniSQLArray.getBaseType());
        ++n;
        switch (uniSQLArray.getBaseType()) {
            case 5: 
            case 6: {
                int n4;
                Object object = null;
                Object[] objectArray = (Object[])uniSQLArray.getArray();
                if (objectArray != null && objectArray instanceof byte[][]) {
                    object = (byte[][])objectArray;
                } else if (objectArray != null && objectArray instanceof Boolean[]) {
                    object = new byte[objectArray.length][];
                    for (n4 = 0; n4 < ((byte[][])object).length; ++n4) {
                        if (((Boolean[])objectArray)[n4] != null) {
                            object[n4] = new byte[1];
                            object[n4][0] = ((Boolean[])objectArray)[n4] == true ? (byte)1 : 0;
                            continue;
                        }
                        object[n4] = null;
                    }
                }
                for (n4 = 0; object != null && n4 < ((byte[][])object).length; ++n4) {
                    if (object[n4] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addBytes(object[n4]);
                }
                break;
            }
            case 9: {
                Number[] numberArray = (Number[])uniSQLArray.getArray();
                for (int i = 0; numberArray != null && i < numberArray.length; ++i) {
                    if (numberArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addShort(numberArray[i].shortValue());
                }
                break;
            }
            case 8: {
                Integer[] integerArray = (Integer[])uniSQLArray.getArray();
                for (int i = 0; integerArray != null && i < integerArray.length; ++i) {
                    if (integerArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addInt(integerArray[i]);
                }
                break;
            }
            case 11: {
                Float[] floatArray = (Float[])uniSQLArray.getArray();
                for (int i = 0; floatArray != null && i < floatArray.length; ++i) {
                    if (floatArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addFloat(floatArray[i].floatValue());
                }
                break;
            }
            case 10: 
            case 12: {
                Double[] doubleArray = (Double[])uniSQLArray.getArray();
                for (int i = 0; doubleArray != null && i < doubleArray.length; ++i) {
                    if (doubleArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addDouble(doubleArray[i]);
                }
                break;
            }
            case 7: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])uniSQLArray.getArray();
                String[] stringArray = new String[bigDecimalArray != null ? bigDecimalArray.length : 0];
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    if (bigDecimalArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    stringArray[i] = bigDecimalArray[i].toString();
                    n += this.addStringWithNull(stringArray[i]);
                }
                break;
            }
            case 13: {
                Date[] dateArray = (Date[])uniSQLArray.getArray();
                for (int i = 0; dateArray != null && i < dateArray.length; ++i) {
                    if (dateArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addDate(dateArray[i]);
                }
                break;
            }
            case 14: {
                Time[] timeArray = (Time[])uniSQLArray.getArray();
                for (int i = 0; timeArray != null && i < timeArray.length; ++i) {
                    if (timeArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addTime(timeArray[i]);
                }
                break;
            }
            case 15: {
                Timestamp[] timestampArray = (Timestamp[])uniSQLArray.getArray();
                for (int i = 0; timestampArray != null && i < timestampArray.length; ++i) {
                    if (timestampArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addTimestamp(timestampArray[i]);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                String[] stringArray = (String[])uniSQLArray.getArray();
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    if (stringArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addStringWithNull(stringArray[i]);
                }
                break;
            }
            case 19: {
                if (uniSQLArray.getLength() <= 0) break;
                UniSQLOID[] uniSQLOIDArray = (UniSQLOID[])uniSQLArray.getArray();
                for (int i = 0; i < uniSQLOIDArray.length; ++i) {
                    if (uniSQLOIDArray[i] == null) {
                        n += this.addNull();
                        continue;
                    }
                    n += this.addOID(uniSQLOIDArray[i]);
                }
                break;
            }
            default: {
                Object[] objectArray = (Object[])uniSQLArray.getArray();
                for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                    n += this.addNull();
                }
            }
        }
        this.overwriteInt(n, n2, n3);
    }

    private void overwriteInt(int n, int n2, int n3) {
        int n4 = this.length;
        int n5 = this.bufferCursor;
        int n6 = this.positionInABuffer;
        this.bufferCursor = n2;
        this.positionInABuffer = n3;
        this.writeInt(n);
        this.length = n4;
        this.bufferCursor = n5;
        this.positionInABuffer = n6;
    }

    private void writeInt(int n) {
        this.writeByte((byte)(n >>> 24 & 0xFF));
        this.writeByte((byte)(n >>> 16 & 0xFF));
        this.writeByte((byte)(n >>> 8 & 0xFF));
        this.writeByte((byte)(n >>> 0 & 0xFF));
    }

    private void writeByte(byte by) {
        ++this.length;
        if (this.positionInABuffer >= 100000) {
            ++this.bufferCursor;
            if (this.bufferCursor >= this.allocatedBufferSize) {
                this.buffer[this.bufferCursor] = new byte[100000];
                this.allocatedBufferSize = this.bufferCursor + 1;
            }
            this.positionInABuffer = 0;
        }
        this.buffer[this.bufferCursor][this.positionInABuffer++] = by;
    }

    private void writeBoolean(boolean bl) {
        if (bl) {
            this.writeByte((byte)1);
        } else {
            this.writeByte((byte)0);
        }
    }

    private void writeBytes(byte[] byArray, int n, int n2) {
        if (this.positionInABuffer + n2 <= 100000) {
            System.arraycopy(byArray, n, this.buffer[this.bufferCursor], this.positionInABuffer, n2);
            this.length += n2;
            this.positionInABuffer += n2;
            return;
        }
        for (int i = 0; i < n2; ++i) {
            this.writeByte(byArray[n++]);
        }
    }

    private void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    private void writeLong(long l) {
        this.writeByte((byte)(l >>> 56 & 0xFFL));
        this.writeByte((byte)(l >>> 48 & 0xFFL));
        this.writeByte((byte)(l >>> 40 & 0xFFL));
        this.writeByte((byte)(l >>> 32 & 0xFFL));
        this.writeByte((byte)(l >>> 24 & 0xFFL));
        this.writeByte((byte)(l >>> 16 & 0xFFL));
        this.writeByte((byte)(l >>> 8 & 0xFFL));
        this.writeByte((byte)(l >>> 0 & 0xFFL));
    }

    private void writeShort(short s) {
        this.writeByte((byte)(s >>> 8 & 0xFF));
        this.writeByte((byte)(s >>> 0 & 0xFF));
    }

    private void writeDate(Date date) throws IllegalArgumentException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string = simpleDateFormat.format(date);
        this.writeShort(Short.parseShort(string.substring(0, 4)));
        this.writeShort(Short.parseShort(string.substring(5, 7)));
        this.writeShort(Short.parseShort(string.substring(8, 10)));
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
    }

    private void writeTime(Time time) throws IllegalArgumentException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        String string = simpleDateFormat.format(time);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort(Short.parseShort(string.substring(0, 2)));
        this.writeShort(Short.parseShort(string.substring(3, 5)));
        this.writeShort(Short.parseShort(string.substring(6, 8)));
    }

    private void writeTimestamp(Timestamp timestamp) throws IllegalArgumentException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string = simpleDateFormat.format(timestamp);
        this.writeShort(Short.parseShort(string.substring(0, 4)));
        this.writeShort(Short.parseShort(string.substring(5, 7)));
        this.writeShort(Short.parseShort(string.substring(8, 10)));
        this.writeShort(Short.parseShort(string.substring(11, 13)));
        this.writeShort(Short.parseShort(string.substring(14, 16)));
        this.writeShort(Short.parseShort(string.substring(17, 19)));
    }

    private void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    private void clearBuffer(OutputStream outputStream) {
        this.length = 0;
        this.bufferCursor = 0;
        this.positionInABuffer = 0;
        this.outStream = outputStream;
    }
}

