/*
 * Decompiled with CFR 0.152.
 */
package unisql.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDOutResultSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import unisql.jdbc.jci.UBatchResult;
import unisql.jdbc.jci.UBindParameter;
import unisql.jdbc.jci.UColumnInfo;
import unisql.jdbc.jci.UConnection;
import unisql.jdbc.jci.UError;
import unisql.jdbc.jci.UGetTypeConvertedValue;
import unisql.jdbc.jci.UInputBuffer;
import unisql.jdbc.jci.UJCIManager;
import unisql.jdbc.jci.UJciException;
import unisql.jdbc.jci.UOutputBuffer;
import unisql.jdbc.jci.UResultInfo;
import unisql.jdbc.jci.UResultTuple;
import unisql.jdbc.jci.UUType;
import unisql.jdbc.jci.UUpdateParameter;
import unisql.jdbc.jci.UniSQLArray;
import unisql.sql.UniSQLOID;

public class UStatement {
    public static final int CURSOR_SET = 0;
    public static final int CURSOR_CUR = 1;
    public static final int CURSOR_END = 2;
    private static final byte NORMAL_EXECUTE = 0;
    private static final byte ASYNC_EXECUTE = 1;
    private static final byte NORMAL = 0;
    private static final byte GET_BY_OID = 1;
    private static final byte GET_SCHEMA_INFO = 2;
    private static final byte TRUE = -128;
    private static final byte FALSE = 0;
    private static final int DEFAULT_FETCH_SIZE = 100;
    private static final byte EXEC_FLAG_ASYNC = 1;
    private static final byte EXEC_FLAG_QUERY_ALL = 2;
    private static final byte EXEC_FLAG_QUERY_INFO = 4;
    private static final byte QUERY_INFO_PLAN = 1;
    private byte statementType;
    private UConnection relatedConnection;
    private boolean isClosed;
    private boolean realFetched;
    private boolean isUpdatable;
    private boolean isSensitive;
    private int serverHandler;
    private int parameterNumber;
    private int columnNumber;
    private UBindParameter bindParameter;
    private ArrayList batchParameter;
    private UColumnInfo[] columnInfo;
    private UColumnInfo[] firstColumnInfo;
    private UResultInfo[] resultInfo;
    private byte commandTypeIs;
    private byte executeFlag;
    private String className;
    private int fetchDirection;
    private int fetchSize;
    private int maxFetchSize;
    private int fetchedTupleNumber;
    private int totalTupleNumber;
    private int currentFirstCursor;
    private int cursorPosition;
    private int executeResult;
    private UResultTuple[] tuples;
    private UError errorHandler;
    private UOutputBuffer outBuffer;
    private int schemaType;
    private boolean isReturnable = false;

    UStatement(UConnection uConnection, UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.outBuffer = uConnection.outBuffer;
        this.statementType = 0;
        this.relatedConnection = uConnection;
        this.errorHandler = new UError();
        this.serverHandler = uInputBuffer.getResCode();
        this.commandTypeIs = uInputBuffer.readByte();
        this.parameterNumber = uInputBuffer.readInt();
        this.isUpdatable = uInputBuffer.readByte() == 1;
        this.columnNumber = uInputBuffer.readInt();
        this.firstColumnInfo = this.readColumnInfo(uInputBuffer);
        this.columnInfo = this.firstColumnInfo;
        this.bindParameter = this.parameterNumber > 0 ? new UBindParameter(this.parameterNumber) : null;
        this.batchParameter = null;
        this.fetchSize = 100;
        this.fetchedTupleNumber = 0;
        this.totalTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isClosed = false;
        if (this.commandTypeIs == 126) {
            this.columnNumber = this.parameterNumber + 1;
        }
    }

    UStatement(UConnection uConnection, UniSQLOID uniSQLOID, String[] stringArray, UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.outBuffer = uConnection.outBuffer;
        this.statementType = 1;
        this.relatedConnection = uConnection;
        this.errorHandler = new UError();
        this.serverHandler = -1;
        this.className = uInputBuffer.readString(uInputBuffer.readInt(), this.relatedConnection.conCharsetName);
        this.columnNumber = uInputBuffer.readInt();
        this.firstColumnInfo = this.readColumnInfo(uInputBuffer);
        this.columnInfo = this.firstColumnInfo;
        this.fetchSize = 1;
        this.tuples = new UResultTuple[this.fetchSize];
        this.readATupleByOid(uniSQLOID, uInputBuffer);
        this.bindParameter = null;
        this.batchParameter = null;
        this.fetchedTupleNumber = 1;
        this.totalTupleNumber = 1;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isUpdatable = false;
        this.isClosed = false;
    }

    UStatement(UConnection uConnection, String string, String string2, int n, UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.outBuffer = uConnection.outBuffer;
        this.statementType = (byte)2;
        this.relatedConnection = uConnection;
        this.className = string;
        this.schemaType = n;
        this.errorHandler = new UError();
        this.serverHandler = uInputBuffer.getResCode();
        this.totalTupleNumber = uInputBuffer.readInt();
        this.columnNumber = uInputBuffer.readInt();
        this.firstColumnInfo = this.readColumnInfo(uInputBuffer);
        this.columnInfo = this.firstColumnInfo;
        this.fetchSize = 100;
        this.fetchedTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.bindParameter = null;
        this.batchParameter = null;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isUpdatable = false;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UStatement(UConnection uConnection, int n) throws Exception {
        UInputBuffer uInputBuffer;
        this.relatedConnection = uConnection;
        this.outBuffer = uConnection.outBuffer;
        this.statementType = 0;
        this.errorHandler = new UError();
        this.bindParameter = null;
        this.fetchSize = 100;
        this.fetchedTupleNumber = 0;
        this.totalTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.maxFetchSize = 0;
        this.realFetched = false;
        this.isClosed = false;
        UConnection uConnection2 = uConnection;
        synchronized (uConnection2) {
            this.outBuffer.newRequest((byte)34);
            this.outBuffer.addInt(n);
            uInputBuffer = uConnection.send_recv_msg();
        }
        this.serverHandler = uInputBuffer.readInt();
        this.commandTypeIs = uInputBuffer.readByte();
        this.totalTupleNumber = uInputBuffer.readInt();
        this.isUpdatable = uInputBuffer.readByte() == 1;
        this.columnNumber = uInputBuffer.readInt();
        this.firstColumnInfo = this.readColumnInfo(uInputBuffer);
        this.columnInfo = this.firstColumnInfo;
        this.executeResult = this.totalTupleNumber;
    }

    public int getParameterCount() {
        return this.parameterNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (n < 0 || n >= this.parameterNumber) {
            this.errorHandler.setErrorCode(6);
            return;
        }
        UBindParameter uBindParameter = this.bindParameter;
        synchronized (uBindParameter) {
            try {
                this.bindParameter.setOutParam(n);
            }
            catch (UJciException uJciException) {
                uJciException.toUError(this.errorHandler);
            }
        }
    }

    public void bind(int n, boolean bl) {
        Byte by = new Byte(bl ? (byte)-128 : 0);
        this.bindValue(n, (byte)5, by);
    }

    public void bind(int n, byte by) {
        Short s = new Short(by);
        this.bindValue(n, (byte)9, s);
    }

    public void bind(int n, short s) {
        Short s2 = new Short(s);
        this.bindValue(n, (byte)9, s2);
    }

    public void bind(int n, int n2) {
        Integer n3 = new Integer(n2);
        this.bindValue(n, (byte)8, n3);
    }

    public void bind(int n, long l) {
        BigDecimal bigDecimal = new BigDecimal(Long.toString(l));
        this.bindValue(n, (byte)7, bigDecimal);
    }

    public void bind(int n, float f) {
        Float f2 = new Float(f);
        this.bindValue(n, (byte)11, f2);
    }

    public void bind(int n, double d) {
        Double d2 = new Double(d);
        this.bindValue(n, (byte)12, d2);
    }

    public void bind(int n, BigDecimal bigDecimal) {
        this.bindValue(n, (byte)7, bigDecimal);
    }

    public void bind(int n, String string) {
        this.bindValue(n, (byte)2, string);
    }

    public void bind(int n, byte[] byArray) {
        byte[] byArray2 = byArray == null ? null : (byte[])byArray.clone();
        this.bindValue(n, (byte)6, byArray2);
    }

    public void bind(int n, Date date) {
        this.bindValue(n, (byte)13, date);
    }

    public void bind(int n, Time time) {
        this.bindValue(n, (byte)14, time);
    }

    public void bind(int n, Timestamp timestamp) {
        this.bindValue(n, (byte)15, timestamp);
    }

    public void bind(int n, Object object) {
        byte by = UUType.getObjectDBtype(object);
        if (by == 18) {
            this.bindCollection(n, (Object[])object);
            return;
        }
        if (by == 0 && object != null) {
            this.errorHandler = new UError();
            this.errorHandler.setErrorCode(16);
            return;
        }
        this.bindValue(n, by, object);
    }

    public void bindCollection(int n, Object[] objectArray) {
        UniSQLArray uniSQLArray;
        if (objectArray == null) {
            uniSQLArray = null;
        } else {
            try {
                uniSQLArray = new UniSQLArray(objectArray);
            }
            catch (UJciException uJciException) {
                this.errorHandler = new UError();
                uJciException.toUError(this.errorHandler);
                return;
            }
        }
        this.bindValue(n, (byte)18, uniSQLArray);
    }

    public void bindOID(int n, UniSQLOID uniSQLOID) {
        this.bindValue(n, (byte)19, uniSQLOID);
    }

    public void addBatch() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.bindParameter == null) {
            return;
        }
        if (!this.bindParameter.checkAllBinded()) {
            this.errorHandler.setErrorCode(7);
            return;
        }
        if (this.batchParameter == null) {
            this.batchParameter = new ArrayList();
        }
        this.batchParameter.add(this.bindParameter);
        this.bindParameter = new UBindParameter(this.parameterNumber);
    }

    public void bindNull(int n) {
        this.bindValue(n, (byte)0, null);
    }

    public UError cancel() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            return uError;
        }
        if (this.statementType == 1) {
            return uError;
        }
        try {
            this.relatedConnection.cancel();
        }
        catch (UJciException uJciException) {
            uJciException.toUError(uError);
        }
        catch (IOException iOException) {
            uError.setErrorCode(3);
        }
        return uError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBatch() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.batchParameter == null) {
            return;
        }
        ArrayList arrayList = this.batchParameter;
        synchronized (arrayList) {
            this.batchParameter.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearBind() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.bindParameter == null) {
            return;
        }
        UBindParameter uBindParameter = this.bindParameter;
        synchronized (uBindParameter) {
            this.bindParameter.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        block9: {
            try {
                try {
                    this.errorHandler = new UError();
                    if (this.isClosed) {
                        this.errorHandler.setErrorCode(17);
                        Object var5_1 = null;
                        this.fetchedTupleNumber = 0;
                        this.totalTupleNumber = 0;
                        this.cursorPosition = 0;
                        this.currentFirstCursor = 0;
                        this.isClosed = true;
                        return;
                    }
                    this.closeFirstColumnInfo();
                    this.closeInternal();
                    if (this.isReturnable) break block9;
                    UConnection uConnection = this.relatedConnection;
                    synchronized (uConnection) {
                        this.outBuffer.newRequest((byte)6);
                        this.outBuffer.addInt(this.serverHandler);
                        UInputBuffer uInputBuffer = this.relatedConnection.send_recv_msg();
                    }
                }
                catch (UJciException uJciException) {
                    uJciException.toUError(this.errorHandler);
                    Object var5_3 = null;
                    this.fetchedTupleNumber = 0;
                    this.totalTupleNumber = 0;
                    this.cursorPosition = 0;
                    this.currentFirstCursor = 0;
                    this.isClosed = true;
                    return;
                }
                catch (IOException iOException) {
                    this.errorHandler.setErrorCode(3);
                    Object var5_4 = null;
                    this.fetchedTupleNumber = 0;
                    this.totalTupleNumber = 0;
                    this.cursorPosition = 0;
                    this.currentFirstCursor = 0;
                    this.isClosed = true;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.fetchedTupleNumber = 0;
                this.totalTupleNumber = 0;
                this.cursorPosition = 0;
                this.currentFirstCursor = 0;
                this.isClosed = true;
                throw throwable;
            }
        }
        Object var5_2 = null;
        this.fetchedTupleNumber = 0;
        this.totalTupleNumber = 0;
        this.cursorPosition = 0;
        this.currentFirstCursor = 0;
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean cursorIsInstance(int n) {
        Object object;
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return false;
        }
        if (this.currentFirstCursor < 0 || n < 0 || n >= 0 && (n < this.currentFirstCursor || n > this.currentFirstCursor + this.fetchedTupleNumber - 1)) {
            this.errorHandler.setErrorCode(16);
            return false;
        }
        if (!this.tuples[this.cursorPosition - this.currentFirstCursor].oidIsIncluded()) {
            this.errorHandler.setErrorCode(21);
            return false;
        }
        UConnection uConnection = this.relatedConnection;
        synchronized (uConnection) {
            object = this.relatedConnection.oidCmd(this.tuples[this.cursorPosition - this.currentFirstCursor].getOid(), (byte)2);
        }
        this.errorHandler.copyValue(this.relatedConnection.getRecentError());
        return object != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteCursor(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.currentFirstCursor < 0 || n < 0 || n >= 0 && (n < this.currentFirstCursor || n > this.currentFirstCursor + this.fetchedTupleNumber - 1)) {
            this.errorHandler.setErrorCode(16);
            return;
        }
        if (!this.tuples[this.cursorPosition - this.currentFirstCursor].oidIsIncluded()) {
            this.errorHandler.setErrorCode(21);
            return;
        }
        UConnection uConnection = this.relatedConnection;
        synchronized (uConnection) {
            this.relatedConnection.oidCmd(this.tuples[this.cursorPosition - this.currentFirstCursor].getOid(), (byte)1);
        }
        this.errorHandler.copyValue(this.relatedConnection.getRecentError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(boolean bl, int n, int n2, boolean bl2, boolean bl3, boolean bl4) {
        UInputBuffer uInputBuffer;
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.statementType == 2) {
            return;
        }
        if (this.bindParameter != null && !this.bindParameter.checkAllBinded()) {
            this.errorHandler.setErrorCode(7);
            return;
        }
        this.executeFlag = 0;
        if (bl2) {
            this.executeFlag = (byte)(this.executeFlag | 2);
        }
        if (bl) {
            this.executeFlag = (byte)(this.executeFlag | 1);
        }
        if (bl4) {
            this.executeFlag = (byte)(this.executeFlag | 4);
        }
        this.currentFirstCursor = -1;
        this.fetchedTupleNumber = 0;
        this.maxFetchSize = n;
        try {
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)3);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addByte(this.executeFlag);
                this.outBuffer.addInt(n2 < 0 ? 0 : n2);
                this.outBuffer.addInt(0);
                if (this.commandTypeIs == 126 && this.bindParameter != null) {
                    this.outBuffer.addBytes(this.bindParameter.paramMode);
                } else {
                    this.outBuffer.addNull();
                }
                if (this.bindParameter != null) {
                    UBindParameter uBindParameter = this.bindParameter;
                    synchronized (uBindParameter) {
                        this.bindParameter.writeParameter(this.outBuffer);
                    }
                }
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            this.readResultInfo(uInputBuffer);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return;
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
            return;
        }
        this.columnInfo = this.firstColumnInfo;
        this.cursorPosition = -1;
        if (this.commandTypeIs == 126) {
            this.cursorPosition = 0;
        }
        this.executeResult = uInputBuffer.getResCode();
        this.errorHandler.setErrorCode(0);
        this.executeResult = this.maxFetchSize > 0 && this.executeResult > this.maxFetchSize ? this.maxFetchSize : this.executeResult;
        this.totalTupleNumber = this.executeResult;
        this.batchParameter = null;
        this.isSensitive = bl3;
    }

    public synchronized UniSQLOID executeInsert(boolean bl) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        if (this.commandTypeIs != 21) {
            this.errorHandler.setErrorCode(22);
            return null;
        }
        this.execute(bl, 0, 0, false, false, false);
        if (this.errorHandler.getErrorCode() != 0) {
            return null;
        }
        if (this.resultInfo != null && this.resultInfo[0] != null) {
            return this.resultInfo[0].getUniSQLOID();
        }
        this.errorHandler.setErrorCode(21);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UBatchResult executeBatch() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            UInputBuffer uInputBuffer;
            int n;
            Object object = this.relatedConnection;
            synchronized (object) {
                this.outBuffer.newRequest((byte)21);
                this.outBuffer.addInt(this.serverHandler);
                if (this.batchParameter != null) {
                    ArrayList arrayList = this.batchParameter;
                    synchronized (arrayList) {
                        for (n = 0; n < this.batchParameter.size(); ++n) {
                            UBindParameter uBindParameter = (UBindParameter)this.batchParameter.get(n);
                            uBindParameter.writeParameter(this.outBuffer);
                        }
                    }
                }
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            this.batchParameter = null;
            object = new UBatchResult(uInputBuffer.readInt());
            for (n = 0; n < ((UBatchResult)object).getResultNumber(); ++n) {
                ((UBatchResult)object).setStatementType(n, this.statementType);
                int n2 = uInputBuffer.readInt();
                if (n2 < 0) {
                    ((UBatchResult)object).setResultError(n, n2, uInputBuffer.readString(uInputBuffer.readInt(), UJCIManager.sysCharsetName));
                    continue;
                }
                ((UBatchResult)object).setResult(n, n2);
                uInputBuffer.readInt();
                uInputBuffer.readShort();
                uInputBuffer.readShort();
            }
            return object;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
        catch (IOException iOException) {
            if (this.errorHandler.getErrorCode() != 13) {
                this.errorHandler.setErrorCode(3);
            }
            return null;
        }
    }

    public synchronized void fetch() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        this.realFetched = false;
        if (this.statementType == 1) {
            return;
        }
        if (this.cursorPosition < 0 || this.executeFlag != 1 && this.totalTupleNumber <= 0) {
            this.errorHandler.setErrorCode(4);
            return;
        }
        if (this.currentFirstCursor >= 0 && this.currentFirstCursor <= this.cursorPosition && this.cursorPosition <= this.currentFirstCursor + this.fetchedTupleNumber - 1) {
            return;
        }
        this.reFetch();
    }

    public synchronized BigDecimal getBigDecimal(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getBigDecimal(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized boolean getBoolean(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return false;
        }
        try {
            return UGetTypeConvertedValue.getBoolean(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return false;
        }
    }

    public synchronized byte getByte(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0;
        }
        try {
            return UGetTypeConvertedValue.getByte(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0;
        }
    }

    public synchronized byte[] getBytes(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getBytes(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized Object getCollection(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        if (!(object instanceof UniSQLArray)) {
            this.errorHandler.setErrorCode(5);
            return null;
        }
        return ((UniSQLArray)object).getArrayClone();
    }

    public UColumnInfo[] getColumnInfo() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return null;
        }
        this.errorHandler = uError;
        return this.columnInfo;
    }

    public synchronized UniSQLOID getColumnOID(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        if (!(object instanceof UniSQLOID)) {
            this.errorHandler.setErrorCode(1);
            return null;
        }
        return (UniSQLOID)object;
    }

    public synchronized UniSQLOID getCursorOID() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        if (!this.checkReFetch()) {
            return null;
        }
        return this.tuples[this.cursorPosition - this.currentFirstCursor].getOid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UniSQLOID getGloOID(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        if (object instanceof UniSQLOID) {
            if (this.columnInfo != null && this.columnInfo.length > n) {
                if (this.columnInfo[n].isGloInstance(this.relatedConnection, (UniSQLOID)object)) {
                    return (UniSQLOID)object;
                }
            } else {
                UConnection uConnection = this.relatedConnection;
                synchronized (uConnection) {
                    object = this.relatedConnection.oidCmd((UniSQLOID)object, (byte)6);
                }
                if (object != null) {
                    return (UniSQLOID)object;
                }
            }
        }
        this.errorHandler.setErrorCode(5);
        return null;
    }

    public synchronized Date getDate(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getDate(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized double getDouble(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0.0;
        }
        try {
            return UGetTypeConvertedValue.getDouble(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0.0;
        }
    }

    public int getExecuteResult() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return 0;
        }
        this.errorHandler = uError;
        return this.executeResult;
    }

    public int getFetchDirection() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return 0;
        }
        this.errorHandler = uError;
        return this.fetchDirection;
    }

    public int getFetchSize() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return 0;
        }
        this.errorHandler = uError;
        return this.fetchSize;
    }

    public synchronized float getFloat(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0.0f;
        }
        try {
            return UGetTypeConvertedValue.getFloat(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0.0f;
        }
    }

    public synchronized int getInt(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0;
        }
        try {
            return UGetTypeConvertedValue.getInt(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0;
        }
    }

    public synchronized long getLong(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0L;
        }
        try {
            return UGetTypeConvertedValue.getLong(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0L;
        }
    }

    public synchronized Object getObject(int n) {
        Object object;
        this.errorHandler = new UError();
        Object object2 = this.beforeGetXXX(n);
        if (object2 == null) {
            return null;
        }
        try {
            if (this.commandTypeIs != 126 && this.columnInfo[n].getColumnType() == 5 && this.columnInfo[n].getColumnPrecision() == 8) {
                object = new Boolean(UGetTypeConvertedValue.getBoolean(object2));
            } else if (object2 instanceof UniSQLArray) {
                object = ((UniSQLArray)object2).getArrayClone();
            } else if (object2 instanceof byte[]) {
                object = ((byte[])object2).clone();
            } else if (object2 instanceof Date) {
                object = ((Date)object2).clone();
            } else if (object2 instanceof Time) {
                object = ((Time)object2).clone();
            } else if (object2 instanceof Timestamp) {
                object = ((Timestamp)object2).clone();
            } else if (object2 instanceof CUBRIDOutResultSet) {
                try {
                    ((CUBRIDOutResultSet)object2).createInstance();
                    object = object2;
                }
                catch (Exception exception) {
                    object = null;
                }
            } else {
                object = object2;
            }
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
        return object;
    }

    public UError getRecentError() {
        return this.errorHandler;
    }

    public UResultInfo[] getResultInfo() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return null;
        }
        this.errorHandler = uError;
        return this.resultInfo;
    }

    public synchronized short getShort(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return 0;
        }
        try {
            return UGetTypeConvertedValue.getShort(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return 0;
        }
    }

    public boolean getSqlType() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return false;
        }
        if (this.commandTypeIs == 22 || this.commandTypeIs == 25 || this.commandTypeIs == 42 || this.commandTypeIs == 15) {
            this.errorHandler = uError;
            return true;
        }
        this.errorHandler = uError;
        return false;
    }

    public synchronized String getString(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getString(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized Time getTime(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getTime(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public synchronized Timestamp getTimestamp(int n) {
        this.errorHandler = new UError();
        Object object = this.beforeGetXXX(n);
        if (object == null) {
            return null;
        }
        try {
            return UGetTypeConvertedValue.getTimestamp(object);
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
            return null;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isOIDIncluded() {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return false;
        }
        this.errorHandler = uError;
        return this.isUpdatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveCursor(int n, int n2) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (n2 != 0 && n2 != 1 && n2 != 2 || this.executeFlag != 1 && this.totalTupleNumber == 0) {
            this.errorHandler.setErrorCode(4);
            return;
        }
        int n3 = this.cursorPosition;
        if (n2 == 0) {
            this.cursorPosition = n;
        } else if (n2 == 1) {
            this.cursorPosition += n;
        }
        if (n2 == 0 || n2 == 1) {
            if (this.executeFlag == 1) {
                if (this.cursorPosition <= this.currentFirstCursor + this.fetchedTupleNumber - 1 || this.totalTupleNumber != 0 && this.cursorPosition < this.totalTupleNumber) {
                    return;
                }
            } else {
                if (this.cursorPosition < this.totalTupleNumber) {
                    return;
                }
                this.errorHandler.setErrorCode(4);
                this.cursorPosition = n3;
                return;
            }
        }
        if (n2 == 2 && this.totalTupleNumber != 0) {
            this.cursorPosition = this.totalTupleNumber - n - 1;
            if (this.cursorPosition >= 0) {
                return;
            }
            this.errorHandler.setErrorCode(4);
            this.cursorPosition = n3;
            return;
        }
        if (n2 == 1) {
            n2 = 0;
            n += n3;
        }
        try {
            UInputBuffer uInputBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)7);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addInt(n);
                this.outBuffer.addInt(n2);
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            this.totalTupleNumber = uInputBuffer.readInt();
        }
        catch (UJciException uJciException) {
            this.cursorPosition = n3;
            uJciException.toUError(this.errorHandler);
            return;
        }
        catch (IOException iOException) {
            this.cursorPosition = n3;
            this.errorHandler.setErrorCode(3);
            return;
        }
        if (this.totalTupleNumber < 0) {
            this.totalTupleNumber = 0;
        } else if (this.totalTupleNumber <= this.cursorPosition) {
            this.errorHandler.setErrorCode(4);
            this.cursorPosition = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean nextResult() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return false;
        }
        try {
            UInputBuffer uInputBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)19);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addInt(0);
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            this.closeInternal();
            this.executeResult = uInputBuffer.readInt();
            this.commandTypeIs = uInputBuffer.readByte();
            this.isUpdatable = uInputBuffer.readByte() == 1;
            this.columnNumber = uInputBuffer.readInt();
            this.columnInfo = this.readColumnInfo(uInputBuffer);
        }
        catch (UJciException uJciException) {
            this.closeInternal();
            uJciException.toUError(this.errorHandler);
            return false;
        }
        catch (IOException iOException) {
            this.closeInternal();
            this.errorHandler.setErrorCode(3);
            return false;
        }
        this.fetchedTupleNumber = 0;
        this.cursorPosition = -1;
        this.currentFirstCursor = -1;
        this.executeResult = this.maxFetchSize > 0 && this.executeResult > this.maxFetchSize ? this.maxFetchSize : this.executeResult;
        this.totalTupleNumber = this.executeResult;
        this.realFetched = false;
        return true;
    }

    public boolean realFetched() {
        return this.realFetched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reFetch() {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (this.statementType == 1) {
            return;
        }
        try {
            UInputBuffer uInputBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)8);
                this.outBuffer.addInt(this.serverHandler);
                if (this.fetchDirection == 1001) {
                    int n = this.cursorPosition - this.fetchSize + 2;
                    if (n < 1) {
                        n = 1;
                    }
                    this.outBuffer.addInt(n);
                } else {
                    this.outBuffer.addInt(this.cursorPosition + 1);
                }
                this.outBuffer.addInt(this.fetchSize);
                this.outBuffer.addByte(this.isSensitive ? (byte)1 : 0);
                this.outBuffer.addInt(0);
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            this.read_fetch_data(uInputBuffer);
            this.realFetched = true;
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
    }

    public synchronized void setFetchDirection(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (n != 1000 && n != 1001 && n != 1002) {
            this.errorHandler.setErrorCode(16);
            return;
        }
        this.fetchDirection = n;
    }

    public synchronized void setFetchSize(int n) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        if (n < 0) {
            this.errorHandler.setErrorCode(16);
            return;
        }
        this.fetchSize = n == 0 ? 100 : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateRows(int n, int[] nArray, Object[] objectArray) {
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return;
        }
        try {
            UUpdateParameter uUpdateParameter = new UUpdateParameter(this.columnInfo, nArray, objectArray);
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)22);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addInt(n + 1);
                uUpdateParameter.writeParameter(this.outBuffer);
                UInputBuffer uInputBuffer = this.relatedConnection.send_recv_msg();
            }
        }
        catch (UJciException uJciException) {
            uJciException.toUError(this.errorHandler);
        }
        catch (IOException iOException) {
            this.errorHandler.setErrorCode(3);
        }
    }

    public synchronized byte getCommandType() {
        return this.commandTypeIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getQueryplan() {
        String string = null;
        this.errorHandler = new UError();
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        try {
            UInputBuffer uInputBuffer;
            UConnection uConnection = this.relatedConnection;
            synchronized (uConnection) {
                this.outBuffer.newRequest((byte)24);
                this.outBuffer.addInt(this.serverHandler);
                this.outBuffer.addByte((byte)1);
                uInputBuffer = this.relatedConnection.send_recv_msg();
            }
            string = uInputBuffer.readString(uInputBuffer.remainedCapacity(), this.relatedConnection.conCharsetName);
        }
        catch (UJciException uJciException) {
            this.closeInternal();
            uJciException.toUError(this.errorHandler);
            return null;
        }
        catch (IOException iOException) {
            this.closeInternal();
            this.errorHandler.setErrorCode(3);
            return null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindValue(int n, byte by, Object object) {
        UError uError = new UError();
        if (this.isClosed) {
            uError.setErrorCode(17);
            this.errorHandler = uError;
            return;
        }
        if (n < 0 || n >= this.parameterNumber) {
            uError.setErrorCode(6);
            this.errorHandler = uError;
            return;
        }
        try {
            UBindParameter uBindParameter = this.bindParameter;
            synchronized (uBindParameter) {
                this.bindParameter.setParameter(n, by, object);
            }
        }
        catch (UJciException uJciException) {
            uJciException.toUError(uError);
        }
        this.errorHandler = uError;
    }

    private Object beforeGetXXX(int n) {
        Object object;
        if (this.isClosed) {
            this.errorHandler.setErrorCode(17);
            return null;
        }
        if (n < 0 || n >= this.columnNumber) {
            this.errorHandler.setErrorCode(9);
            return null;
        }
        if (!this.checkReFetch()) {
            return null;
        }
        if (this.fetchedTupleNumber <= 0) {
            this.errorHandler.setErrorCode(4);
            return null;
        }
        if (this.tuples == null || this.tuples[this.cursorPosition - this.currentFirstCursor] == null || (object = this.tuples[this.cursorPosition - this.currentFirstCursor].getAttribute(n)) == null) {
            this.errorHandler.setErrorCode(8);
            return null;
        }
        return object;
    }

    private boolean checkReFetch() {
        if (this.currentFirstCursor < 0 || this.cursorPosition >= 0 && (this.cursorPosition < this.currentFirstCursor || this.cursorPosition > this.currentFirstCursor + this.fetchedTupleNumber - 1)) {
            this.fetch();
            if (this.errorHandler.getErrorCode() != 0) {
                return false;
            }
        }
        return true;
    }

    private byte readTypeFromData(int n, UInputBuffer uInputBuffer) throws UJciException {
        if (this.commandTypeIs == 25 || this.commandTypeIs == 15 || this.commandTypeIs == 126 || this.columnInfo[n].getColumnType() == 0) {
            return uInputBuffer.readByte();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void closeFirstColumnInfo() {
        if (this.firstColumnInfo == null) return;
        UColumnInfo[] uColumnInfoArray = this.firstColumnInfo;
        synchronized (this.firstColumnInfo) {
            for (int i = 0; i < this.firstColumnInfo.length; ++i) {
                this.firstColumnInfo[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.firstColumnInfo = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void closeInternal() {
        int n;
        Object object;
        if (this.columnInfo != null) {
            object = this.columnInfo;
            // MONITORENTER : this.columnInfo
            for (n = 0; n < this.columnInfo.length; ++n) {
                this.columnInfo[n] = null;
            }
            // MONITOREXIT : object
            this.columnInfo = null;
        }
        if (this.bindParameter != null) {
            object = this.bindParameter;
            // MONITORENTER : object
            this.bindParameter.close();
            // MONITOREXIT : object
            this.bindParameter = null;
        }
        if (this.tuples == null) return;
        object = this.tuples;
        // MONITORENTER : this.tuples
        n = 0;
        while (true) {
            if (n >= this.tuples.length) {
                // MONITOREXIT : object
                this.tuples = null;
                return;
            }
            if (this.tuples[n] != null) {
                this.tuples[n].close();
                this.tuples[n] = null;
            }
            ++n;
        }
    }

    private void confirmSchemaTypeInfo(int n) {
        if (this.statementType != 2) {
            return;
        }
        switch (this.schemaType) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                Short s = (Short)this.tuples[n].getAttribute(1);
                byte[] byArray = UColumnInfo.confirmType(s.byteValue());
                this.tuples[n].setAttribute(1, new Short(byArray[0]));
            }
        }
    }

    private Object readAAttribute(int n, UInputBuffer uInputBuffer) throws IOException, UJciException {
        int n2 = uInputBuffer.readInt();
        if (n2 <= 0) {
            return null;
        }
        byte by = this.readTypeFromData(n, uInputBuffer);
        if (by == 0) {
            by = this.columnInfo[n].getColumnType();
        } else {
            --n2;
        }
        return this.readData(uInputBuffer, by, n2);
    }

    private Object readData(UInputBuffer uInputBuffer, int n, int n2) throws IOException, UJciException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return uInputBuffer.readString(n2, this.relatedConnection.conCharsetName);
            }
            case 7: {
                return new BigDecimal(uInputBuffer.readString(n2, UJCIManager.sysCharsetName));
            }
            case 8: {
                return new Integer(uInputBuffer.readInt());
            }
            case 9: {
                return new Short(uInputBuffer.readShort());
            }
            case 13: {
                return uInputBuffer.readDate();
            }
            case 14: {
                return uInputBuffer.readTime();
            }
            case 15: {
                return uInputBuffer.readTimestamp();
            }
            case 19: {
                return uInputBuffer.readOID(this.relatedConnection.unisqlcon);
            }
            case 16: 
            case 17: 
            case 18: {
                UniSQLArray uniSQLArray = new UniSQLArray(uInputBuffer.readByte(), uInputBuffer.readInt());
                int n3 = uniSQLArray.getBaseType();
                for (int i = 0; i < uniSQLArray.getLength(); ++i) {
                    int n4 = uInputBuffer.readInt();
                    if (n4 <= 0) {
                        uniSQLArray.setElement(i, null);
                        continue;
                    }
                    uniSQLArray.setElement(i, this.readData(uInputBuffer, n3, n4));
                }
                return uniSQLArray;
            }
            case 10: 
            case 12: {
                return new Double(uInputBuffer.readDouble());
            }
            case 11: {
                return new Float(uInputBuffer.readFloat());
            }
            case 5: 
            case 6: {
                return uInputBuffer.readBytes(n2);
            }
            case 20: {
                return new CUBRIDOutResultSet(this.relatedConnection, uInputBuffer.readInt());
            }
        }
        return null;
    }

    private void read_fetch_data(UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.fetchedTupleNumber = uInputBuffer.readInt();
        if (this.fetchedTupleNumber < 0) {
            this.fetchedTupleNumber = 0;
        }
        this.tuples = new UResultTuple[this.fetchedTupleNumber];
        for (int i = 0; i < this.fetchedTupleNumber; ++i) {
            this.readATuple(i, uInputBuffer);
        }
    }

    private void readATupleByOid(UniSQLOID uniSQLOID, UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.tuples[0] = new UResultTuple(1, this.columnNumber);
        this.tuples[0].setOid(uniSQLOID);
        for (int i = 0; i < this.columnNumber; ++i) {
            this.tuples[0].setAttribute(i, this.readAAttribute(i, uInputBuffer));
        }
        this.currentFirstCursor = 0;
    }

    private void readATuple(int n, UInputBuffer uInputBuffer) throws IOException, UJciException {
        this.tuples[n] = new UResultTuple(uInputBuffer.readInt(), this.columnNumber);
        this.tuples[n].setOid(uInputBuffer.readOID(this.relatedConnection.unisqlcon));
        for (int i = 0; i < this.columnNumber; ++i) {
            this.tuples[n].setAttribute(i, this.readAAttribute(i, uInputBuffer));
        }
        this.confirmSchemaTypeInfo(n);
        if (n == 0) {
            this.currentFirstCursor = this.tuples[n].tupleNumber() - 1;
        }
    }

    private UColumnInfo[] readColumnInfo(UInputBuffer uInputBuffer) throws IOException, UJciException {
        UColumnInfo[] uColumnInfoArray = new UColumnInfo[this.columnNumber];
        for (int i = 0; i < this.columnNumber; ++i) {
            byte by = uInputBuffer.readByte();
            short s = uInputBuffer.readShort();
            int n = uInputBuffer.readInt();
            String string = uInputBuffer.readString(uInputBuffer.readInt(), this.relatedConnection.conCharsetName);
            uColumnInfoArray[i] = new UColumnInfo(by, s, n, string);
            if (this.statementType != 0) continue;
            String string2 = uInputBuffer.readString(uInputBuffer.readInt(), this.relatedConnection.conCharsetName);
            String string3 = uInputBuffer.readString(uInputBuffer.readInt(), this.relatedConnection.conCharsetName);
            byte by2 = uInputBuffer.readByte();
            uColumnInfoArray[i].setRemainedData(string2, string3, by2 == 0);
        }
        return uColumnInfoArray;
    }

    private void readResultInfo(UInputBuffer uInputBuffer) throws UJciException {
        this.resultInfo = new UResultInfo[uInputBuffer.readInt()];
        for (int i = 0; i < this.resultInfo.length; ++i) {
            this.resultInfo[i] = new UResultInfo(uInputBuffer.readByte(), uInputBuffer.readInt());
            this.resultInfo[i].setResultOid(uInputBuffer.readOID(this.relatedConnection.unisqlcon));
        }
    }

    public int getServerHandle() {
        return this.serverHandler;
    }

    public void setReturnable() {
        this.isReturnable = true;
    }

    public boolean isReturnable() {
        return this.isReturnable;
    }
}

