/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleStatement;

public class OracleInputStream
extends OracleBufferedStream {
    boolean isNull;
    OracleStatement statement;
    int columnIndex;
    OracleInputStream previous_stream;

    public OracleInputStream(OracleStatement oracleStatement, int n, OracleInputStream oracleInputStream) {
        super(oracleStatement.connection.db_access.getDefaultStreamChunkSize());
        this.closed = true;
        this.previous_stream = oracleInputStream;
        this.statement = oracleStatement;
        this.columnIndex = n;
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (this.previous_stream != null) {
                this.previous_stream.close();
            }
            if (!this.isNull()) {
                while (this.needBytes()) {
                    this.pos = this.count;
                }
            }
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isNull() throws IOException {
        boolean bl = false;
        try {
            bl = this.statement.defines != null && this.statement.defines.getNoOfArgs() > 0 ? this.statement.defines.isNull(this.columnIndex - 1, 0) : this.statement.binds_out.isNull(this.columnIndex - 1, 0);
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
        return bl;
    }

    public boolean needBytes() throws IOException {
        block5: {
            if (this.closed) {
                return false;
            }
            if (this.pos < this.count) break block5;
            try {
                int n = this.statement.connection.db_access.read(this.statement.dbstmt, this.buf, this.chunkSize, this.columnIndex);
                this.pos = 0;
                this.count = n;
                if (this.count == -1) {
                    if (this.statement.streams == this) {
                        this.statement.connection.releaseLine();
                    }
                    this.closed = true;
                    this.statement.fetchNextColumns();
                    return false;
                }
            }
            catch (SQLException sQLException) {
                DBError.SQLToIOException(sQLException);
            }
        }
        return true;
    }

    public void resetLong() {
        if (this.previous_stream != null) {
            this.previous_stream.resetLong();
        }
        this.count = 0;
        this.pos = 0;
        this.closed = false;
    }
}

