/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oci8;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBDataSetImpl;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oci8.OCIDBItem;
import oracle.jdbc.oci8.OCIDBType;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.SQLUtil;

public class OCIDBDataSet
extends DBDataSetImpl {
    private short _versionNum = 0;

    public OCIDBDataSet(OracleConnection oracleConnection, OracleStatement oracleStatement, int n, int n2, short s) {
        super(oracleConnection, oracleStatement, n, n2);
        this._versionNum = s;
    }

    public int checkPlsqlIndexTableBindTypes(DBDataSet dBDataSet, int n, int n2, int n3, int n4) throws SQLException {
        if (this.m_first_row) {
            return 0;
        }
        if (this.isTypeChanged(this, n, n2, n3, n4)) {
            return -1;
        }
        if (dBDataSet != null && this.isTypeChanged((OCIDBDataSet)dBDataSet, n, n2, n3, n4)) {
            return -1;
        }
        return 0;
    }

    public Datum[] getPlsqlIndexTableItem(int n, int n2) throws SQLException {
        DBData[] dBDataArray = this.getDBData();
        DBType[] dBTypeArray = this.getDBTypes();
        int n3 = this.getPlsqlIndexTableType(n);
        OCIDBItem oCIDBItem = (OCIDBItem)dBDataArray[n].getItem(n2);
        Datum[] datumArray = new Datum[oCIDBItem.cur_length_plsqlindextable];
        int n4 = 0;
        while (n4 < oCIDBItem.cur_length_plsqlindextable) {
            switch (n3) {
                case 2: 
                case 6: {
                    datumArray[n4] = new NUMBER((byte[])oCIDBItem.indextable_value[n4]);
                    break;
                }
                default: {
                    datumArray[n4] = SQLUtil.makeDatum(this.m_connection, (byte[])oCIDBItem.indextable_value[n4], n3, null, 0);
                    break;
                }
            }
            ++n4;
        }
        return datumArray;
    }

    public int getPlsqlIndexTableType(int n) throws SQLException {
        return ((OCIDBType)this.getDBTypes()[n]).element_type_plsqlindextable;
    }

    boolean isTypeChanged(OCIDBDataSet oCIDBDataSet, int n, int n2, int n3, int n4) throws SQLException {
        OCIDBType oCIDBType;
        return oCIDBDataSet.types != null && oCIDBDataSet.types.length > n && (oCIDBType = (OCIDBType)oCIDBDataSet.getDBTypes()[n]) != null && (oCIDBType.element_type_plsqlindextable != n4 || oCIDBType.max_length_plsqlindextable < n2 || oCIDBType.max_length < n3);
    }

    public boolean setPlsqlIndexTableItem(int n, int n2, Datum[] datumArray, int n3, int n4, int n5, int n6) throws SQLException {
        OCIDBType oCIDBType = (OCIDBType)this._createOrGetBindDBType(n, 998);
        if (this.m_first_row) {
            oCIDBType.setPlsqlIndexTableTypeFields(n3, n6, n5, this._versionNum);
            this._setBindDBType(n, oCIDBType);
        } else {
            if (n3 > 0 && n3 > oCIDBType.max_length_plsqlindextable) {
                oCIDBType.max_length_plsqlindextable = n3;
            }
            if (n6 > 0 && n6 > oCIDBType.max_length) {
                oCIDBType.max_length = n6;
            }
        }
        OCIDBItem oCIDBItem = (OCIDBItem)this._createOrGetDBItem(n, oCIDBType, n2);
        oCIDBItem.setPlsqlIndexTableItemFields(datumArray, n4, oCIDBType);
        this._setBindDBItem(n, oCIDBItem);
        return true;
    }

    public void setPlsqlIndexTableType(int n, int n2, int n3, int n4) throws SQLException {
        OCIDBType oCIDBType = (OCIDBType)this._createOrGetBindDBType(n, 998);
        oCIDBType.setPlsqlIndexTableTypeFields(n2, n3, n4, this._versionNum);
        this._setBindDBType(n, oCIDBType);
    }
}

