/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.StructDescriptor;

public class OracleTypeOPAQUE
extends OracleTypeADT
implements Serializable {
    static final long KOLOFLLB = 1L;
    static final long KOLOFLCL = 2L;
    static final long KOLOFLUB = 4L;
    static final long KOLOFLFX = 8L;
    static final long serialVersionUID = -7279638692691669378L;
    long m_flag;
    long m_maxLen;

    public OracleTypeOPAQUE(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeOPAQUE(OracleTypeADT oracleTypeADT, int n, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n, (Connection)oracleConnection);
    }

    OpaqueDescriptor createOpaqueDescriptor() throws SQLException {
        if (!this.m_hasName) {
            return new OpaqueDescriptor(this, (Connection)this.m_conn);
        }
        return OpaqueDescriptor.createDescriptor(this.m_fullName, this.m_conn);
    }

    public long getMaxLength() throws SQLException {
        return this.m_maxLen;
    }

    public int getTypeCode() {
        return 2007;
    }

    public boolean isFixedSized() throws SQLException {
        return (this.m_flag & 8L) != 0L;
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    public boolean isModeledInC() throws SQLException {
        return (this.m_flag & 2L) != 0L;
    }

    public boolean isObjectType() {
        return false;
    }

    public boolean isTrustedLibrary() throws SQLException {
        return (this.m_flag & 1L) != 0L;
    }

    public boolean isUnboundedSized() throws SQLException {
        return (this.m_flag & 4L) != 0L;
    }

    public byte[] linearize(Datum datum) throws SQLException {
        return this.pickle81(datum);
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        streamInfo.skipBytes(5);
        this.m_flag = streamInfo.readLong();
        this.m_maxLen = streamInfo.readLong();
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        OPAQUE oPAQUE = (OPAQUE)datum;
        byte[] byArray = oPAQUE.getBytesValue();
        int n = 0;
        n += pickleContext.writeOpaqueImageHeader_pctx(byArray.length);
        return n += pickleContext.write_data_pctx(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.m_conn = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof OPAQUE) {
                return (OPAQUE)object;
            }
            OpaqueDescriptor opaqueDescriptor = this.createOpaqueDescriptor();
            return new OPAQUE(opaqueDescriptor, this.m_conn, object);
        }
        return null;
    }

    public Datum unlinearize(byte[] byArray, long l, Datum datum, int n, Map map) throws SQLException {
        if (byArray == null) {
            return null;
        }
        if ((byArray[0] & 0x80) > 0) {
            PickleContext pickleContext = new PickleContext(byArray, l);
            return this.unpickle81(pickleContext, (OPAQUE)datum, n, map);
        }
        return null;
    }

    OPAQUE unpickle81(PickleContext pickleContext, OPAQUE oPAQUE, int n, Map map) throws SQLException {
        return this.unpickle81datum(pickleContext, oPAQUE);
    }

    private OPAQUE unpickle81datum(PickleContext pickleContext, OPAQUE oPAQUE) throws SQLException {
        pickleContext.skip_bytes(2);
        long l = pickleContext.readLength_pctx(true) - 2;
        if (oPAQUE == null) {
            return new OPAQUE(this.createOpaqueDescriptor(), this.m_conn, pickleContext.readBytes_pctx((int)l));
        }
        oPAQUE.setValue(pickleContext.readBytes_pctx((int)l));
        return oPAQUE;
    }

    protected Object unpickle81rec(PickleContext pickleContext, int n, Map map) throws SQLException {
        byte by = pickleContext.readByte_pctx();
        if (PickleContext.isElementNull_pctx(by)) {
            return null;
        }
        pickleContext.skipRestOfLength_pctx(by);
        switch (n) {
            case 1: 
            case 2: {
                return this.unpickle81datum(pickleContext, null);
            }
            case 3: {
                return new OPAQUE(this.createOpaqueDescriptor(), pickleContext.readDataValue_pctx(), this.m_conn);
            }
            case 9: {
                pickleContext.skipDataValue_pctx();
                return null;
            }
        }
        DBError.throwSqlException(1);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }
}

