/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.sql.SQLException;
import oracle.gss.util.NLSCharacter;
import oracle.jdbc.dbaccess.DBConversion;

public class TTCConversion
extends DBConversion {
    private int isServerCSMultiByte;
    private short m_oraVersion;
    private int m_c2sNlsRatio;
    private int m_s2cNlsRatio;
    private int m_sMaxCharSize;

    public TTCConversion(short s, short s2, short s3, short s4) throws SQLException {
        super(s, s2, s4);
        this.m_oraVersion = s3;
        this.m_c2sNlsRatio = NLSCharacter.getRatio(s, s2);
        this.m_s2cNlsRatio = NLSCharacter.getRatio(s2, s);
        this.m_sMaxCharSize = NLSCharacter.getRatio(s, 1);
        this.isServerCSMultiByte = NLSCharacter.getRatio(s, 1);
    }

    public byte[] StringToNetworkRep(String string) throws SQLException {
        return this.StringToCharBytes(string);
    }

    public static short findAccessCharSet(short n, short s) {
        int n2 = 0;
        switch (n) {
            case 1: 
            case 31: 
            case 873: {
                n2 = n;
                break;
            }
            default: {
                n2 = s >= 8030 ? 871 : 870;
            }
        }
        return (short)n2;
    }

    public int getMaxCharSize() {
        return this.m_sMaxCharSize;
    }

    public int getNLSRATIO() {
        return this.m_c2sNlsRatio;
    }

    public short getOraVersion() {
        return this.m_oraVersion;
    }

    public int getServer2ClientNlsRatio() {
        return this.m_s2cNlsRatio;
    }

    public boolean isServerMultiByte() {
        return this.isServerCSMultiByte != 1;
    }
}

