/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.common.xml;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import net.hero.engine.common.xml.XMLElement;
import net.hero.engine.common.xml.XMLElementList;
import net.hero.engine.common.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLDocument {
    private Document document = null;

    public boolean load(String path) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.parse(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean loadXML(String xml) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isNull() {
        return this.document == null;
    }

    public XMLElementList selectNodes(String xpathString) {
        NodeList nodeList = null;
        if (!this.isNull()) {
            nodeList = (NodeList)XMLUtils.evaluateXPath(xpathString, this.document, XPathConstants.NODESET);
        }
        return new XMLElementList(nodeList);
    }

    public XMLElement selectSingleNode(String xpathString) {
        Node node = null;
        if (!this.isNull()) {
            node = (Node)XMLUtils.evaluateXPath(xpathString, this.document, XPathConstants.NODE);
        }
        return new XMLElement(node);
    }
}

