/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.content.instance;

import java.util.Vector;
import net.hero.engine.content.instance.InstanceImpl;
import net.hero.engine.content.instance.InstanceTableCell;
import net.hero.engine.content.instance.InstanceTableCol;
import net.hero.engine.content.instance.InstanceTableRow;
import net.hero.engine.content.instance.InstanceVisitor;
import net.hero.engine.style.StyleManager;

public class InstanceTable
extends InstanceImpl {
    protected Vector<InstanceTableCol> listCols = new Vector();
    protected Vector<InstanceTableRow> listRows = new Vector();

    protected InstanceTable() {
    }

    public static InstanceTable createInstance(StyleManager styleManager) {
        InstanceTable instance = new InstanceTable();
        return instance;
    }

    @Override
    public void acceptVisitor(InstanceVisitor visitor) {
        visitor.visitEnter(this);
        InstanceTableCell[] tableCells = this.getCellList();
        int i = 0;
        while (i < tableCells.length) {
            tableCells[i].acceptVisitor(visitor);
            ++i;
        }
        visitor.visitLeave(this);
    }

    public void addColumn(InstanceTableCol instanceTableCol) {
        if (instanceTableCol == null) {
            throw new IllegalArgumentException("Cannot set a null InstanceTableCol");
        }
        this.listCols.add(instanceTableCol);
    }

    public void addRow(InstanceTableRow instanceTableRow) {
        if (instanceTableRow == null) {
            throw new IllegalArgumentException("Cannot set a null InstanceTableRow");
        }
        this.listRows.add(instanceTableRow);
    }

    public int getColCount() {
        return this.listCols.size();
    }

    public int getRowCount() {
        return this.listRows.size();
    }

    public InstanceTableCol getColumn(int columnIndex) {
        return this.listCols.get(columnIndex);
    }

    public InstanceTableRow getRow(int rowIndex) {
        return this.listRows.get(rowIndex);
    }

    public InstanceTableCol[] getColumns() {
        InstanceTableCol[] columns = new InstanceTableCol[this.listCols.size()];
        return this.listCols.toArray(columns);
    }

    public InstanceTableRow[] getRows() {
        InstanceTableRow[] rows = new InstanceTableRow[this.listRows.size()];
        return this.listRows.toArray(rows);
    }

    public InstanceTableCell getCell(int rowIndex, int columnIndex) {
        InstanceTableRow instanceTableRow = this.getRow(rowIndex);
        if (instanceTableRow != null) {
            return instanceTableRow.getCell(columnIndex);
        }
        return null;
    }

    public InstanceTableCell[] getCellList() {
        int totalCellCount = 0;
        int i = 0;
        while (i < this.listRows.size()) {
            totalCellCount += this.getRow(i).getCellCount();
            ++i;
        }
        InstanceTableCell[] tableCells = new InstanceTableCell[totalCellCount];
        totalCellCount = 0;
        int i2 = 0;
        while (i2 < this.listRows.size()) {
            InstanceTableRow tableRow = this.getRow(i2);
            int j = 0;
            while (j < tableRow.getCellCount()) {
                tableCells[totalCellCount] = tableRow.getCell(j);
                ++totalCellCount;
                ++j;
            }
            ++i2;
        }
        return tableCells;
    }
}

