/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.data.connection;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import net.hero.engine.common.property.Property;
import net.hero.engine.data.connection.Connection;
import net.hero.engine.data.connection.JDBCSupportConnection;
import net.hero.engine.data.dataset.DataSet;
import net.hero.engine.data.dataset.DataSetJDBC;

public class ConnectionJDBC
extends Connection
implements JDBCSupportConnection,
Property {
    public static final String JDBC_PROPERTY_CLASSNAME = "jdbc-classname";
    public static final String JDBC_PROPERTY_CONNECTION = "jdbc-connection";
    public static final String JDBC_PROPERTY_CONNECTION_USERNAME = "jdbc-connection-username";
    public static final String JDBC_PROPERTY_CONNECTION_PASSWORD = "jdbc-connection-password";
    protected String jdbcClassName;
    protected String jdbcConnection;
    protected String jdbcConnectionUsername;
    protected String jdbcConnectionPassword;
    protected java.sql.Connection connection = null;
    protected Statement statement = null;

    @Override
    public void setProperty(String name, String value) {
        if ((name = name.toLowerCase()).equals(JDBC_PROPERTY_CLASSNAME)) {
            this.jdbcClassName = value;
        } else if (name.equals(JDBC_PROPERTY_CONNECTION)) {
            this.jdbcConnection = value;
        } else if (name.equals(JDBC_PROPERTY_CONNECTION_USERNAME)) {
            this.jdbcConnectionUsername = value;
        } else if (name.equals(JDBC_PROPERTY_CONNECTION_PASSWORD)) {
            this.jdbcConnectionPassword = value;
        }
    }

    @Override
    public String getProperty(String name) {
        String value = "";
        if ((name = name.toLowerCase()).equals(JDBC_PROPERTY_CLASSNAME)) {
            value = this.jdbcClassName;
        } else if (name.equals(JDBC_PROPERTY_CONNECTION)) {
            value = this.jdbcConnection;
        } else if (name.equals(JDBC_PROPERTY_CONNECTION_USERNAME)) {
            value = this.jdbcConnectionUsername;
        } else if (name.equals(JDBC_PROPERTY_CONNECTION_PASSWORD)) {
            value = this.jdbcConnectionPassword;
        }
        return value;
    }

    @Override
    public Map<String, String> getAllProperty() {
        HashMap<String, String> mapProperty = new HashMap<String, String>();
        mapProperty.put(JDBC_PROPERTY_CLASSNAME, this.jdbcClassName);
        mapProperty.put(JDBC_PROPERTY_CONNECTION, this.jdbcConnection);
        mapProperty.put(JDBC_PROPERTY_CONNECTION_USERNAME, this.jdbcConnectionUsername);
        mapProperty.put(JDBC_PROPERTY_CONNECTION_PASSWORD, this.jdbcConnectionPassword);
        return mapProperty;
    }

    @Override
    public DataSet createDataSet(String datasetType, String datasetName) {
        DataSetJDBC dataset = new DataSetJDBC(this, datasetName);
        this.addDataSet(dataset);
        return dataset;
    }

    @Override
    public java.sql.Connection getJDBCConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        this.openConnection();
        return this.connection;
    }

    @Override
    public Statement getJDBCStatement() {
        if (this.statement != null) {
            return this.statement;
        }
        this.openConnection();
        return this.statement;
    }

    public void openConnection() {
        try {
            Class.forName(this.jdbcClassName);
            this.connection = DriverManager.getConnection(this.jdbcConnection, this.jdbcConnectionUsername, this.jdbcConnectionPassword);
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            this.closeConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.closeConnection();
        }
    }

    public void closeConnection() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.statement = null;
        this.connection = null;
    }
}

