/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.data.connection;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.hero.engine.common.property.Property;
import net.hero.engine.data.connection.Connection;
import net.hero.engine.data.connection.JDBCSupportConnection;
import net.hero.engine.data.dataset.DataSet;
import net.hero.engine.data.dataset.DataSetJDBC;

public class ConnectionJNDI
extends Connection
implements JDBCSupportConnection,
Property {
    public static final String JNDI_PROPERTY_CONTEXTNAME = "jndi-contextname";
    protected String jndiContextName;
    protected java.sql.Connection connection = null;
    protected Statement statement = null;

    @Override
    public void setProperty(String name, String value) {
        if ((name = name.toLowerCase()).equals(JNDI_PROPERTY_CONTEXTNAME)) {
            this.jndiContextName = value;
        }
    }

    @Override
    public String getProperty(String name) {
        String value = "";
        if ((name = name.toLowerCase()).equals(JNDI_PROPERTY_CONTEXTNAME)) {
            value = this.jndiContextName;
        }
        return value;
    }

    @Override
    public Map<String, String> getAllProperty() {
        HashMap<String, String> mapProperty = new HashMap<String, String>();
        mapProperty.put(JNDI_PROPERTY_CONTEXTNAME, this.jndiContextName);
        return mapProperty;
    }

    @Override
    public DataSet createDataSet(String datasetType, String datasetName) {
        DataSetJDBC dataset = new DataSetJDBC(this, datasetName);
        this.addDataSet(dataset);
        return dataset;
    }

    @Override
    public java.sql.Connection getJDBCConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        this.openConnection();
        return this.connection;
    }

    @Override
    public Statement getJDBCStatement() {
        if (this.statement != null) {
            return this.statement;
        }
        this.openConnection();
        return this.statement;
    }

    public void openConnection() {
        InitialContext context = null;
        DataSource datasource = null;
        try {
            context = new InitialContext();
            datasource = (DataSource)context.lookup(this.jndiContextName);
            if (datasource != null) {
                this.connection = datasource.getConnection();
                this.statement = this.connection.createStatement();
            }
        }
        catch (NamingException e) {
            this.closeConnection();
            e.printStackTrace();
        }
        catch (SQLException e) {
            this.closeConnection();
            e.printStackTrace();
        }
    }

    public void closeConnection() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.statement = null;
        this.connection = null;
    }
}

