/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.data.connection;

import java.util.HashMap;
import java.util.Map;
import net.hero.engine.common.property.Property;
import net.hero.engine.common.xml.XMLDocument;
import net.hero.engine.data.connection.Connection;
import net.hero.engine.data.connection.XMLSupportConnection;
import net.hero.engine.data.dataset.DataSet;
import net.hero.engine.data.dataset.DataSetXML;

public class ConnectionXML
extends Connection
implements XMLSupportConnection,
Property {
    public static final String XML_PROPERTY_PATH = "xml-path";
    protected String xmlPath;
    private XMLDocument document = null;

    @Override
    public void setProperty(String name, String value) {
        if ((name = name.toLowerCase()).equals(XML_PROPERTY_PATH)) {
            this.xmlPath = value;
        }
    }

    @Override
    public String getProperty(String name) {
        String value = "";
        if ((name = name.toLowerCase()).equals(XML_PROPERTY_PATH)) {
            value = this.xmlPath;
        }
        return value;
    }

    @Override
    public Map<String, String> getAllProperty() {
        HashMap<String, String> mapProperty = new HashMap<String, String>();
        mapProperty.put(XML_PROPERTY_PATH, this.xmlPath);
        return mapProperty;
    }

    @Override
    public DataSet createDataSet(String datasetType, String datasetName) {
        DataSetXML dataset = new DataSetXML(this, datasetName);
        this.addDataSet(dataset);
        return dataset;
    }

    @Override
    public XMLDocument connectionXML() {
        if (this.document != null) {
            return this.document;
        }
        if (!this.openConnection()) {
            this.document = null;
        }
        return this.document;
    }

    public String getPath() {
        return this.xmlPath;
    }

    public void setPath(String path) {
        this.xmlPath = path;
    }

    public boolean openConnection() {
        this.document = new XMLDocument();
        return this.document.load(this.xmlPath);
    }

    public void closeConnection() {
        this.document = null;
    }
}

