/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.data.field;

import net.hero.engine.common.context.Context;
import net.hero.engine.data.field.Field;
import net.hero.engine.data.resultset.Result;

public class FieldSystem
extends Field {
    public static final String SYSTEM_FIELD_NAME_PAGENUMBER = "pagenumber";
    public static final String SYSTEM_FIELD_NAME_PAGECOUNT = "pagecount";
    public static final String SYSTEM_FIELD_NAME_PAGENOFM = "pagenofm";
    public static final String SYSTEM_FIELD_NAME_RECORDNUMBER = "recordnumber";
    public static final String SYSTEM_FIELD_NAME_RECORDCOUNT = "recordcount";
    public static final String SYSTEM_FIELD_NAME_PRINTDATE = "printdate";
    public static final FieldSystem PageNumber = new FieldSystem("pagenumber");
    public static final FieldSystem PageCount = new FieldSystem("pagecount");
    public static final FieldSystem PagePageNofM = new FieldSystem("pagenofm");
    public static final FieldSystem RecordNumber = new FieldSystem("recordnumber");
    public static final FieldSystem RecordCount = new FieldSystem("recordcount");
    public static final FieldSystem PrintDate = new FieldSystem("printdate");

    private FieldSystem(String name) {
        this.name = name;
    }

    @Override
    public String getType() {
        return "system";
    }

    @Override
    public String getSpecialChar() {
        return "%";
    }

    @Override
    public String getValue(Context ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Context can't be a null.");
        }
        String value = "";
        String lowerCaseName = this.getName().toLowerCase();
        if (lowerCaseName.equals(SYSTEM_FIELD_NAME_PAGENUMBER)) {
            value = "1";
        } else if (lowerCaseName.equals(SYSTEM_FIELD_NAME_PAGECOUNT)) {
            value = "100";
        } else if (lowerCaseName.equals(SYSTEM_FIELD_NAME_PAGENOFM)) {
            value = "1/100";
        } else if (lowerCaseName.equals(SYSTEM_FIELD_NAME_RECORDNUMBER)) {
            Result rs = ctx.getCurrentResult();
            value = String.valueOf(rs.getIndex() + 1);
        } else if (lowerCaseName.equals(SYSTEM_FIELD_NAME_RECORDCOUNT)) {
            value = "111";
        } else if (lowerCaseName.equals(SYSTEM_FIELD_NAME_PRINTDATE)) {
            value = "2011.01.01";
        }
        return value;
    }
}

