/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.document;

import java.util.Map;
import net.hero.engine.common.property.Property;
import net.hero.engine.common.xml.XMLDocument;
import net.hero.engine.common.xml.XMLElement;
import net.hero.engine.common.xml.XMLElementList;
import net.hero.engine.data.bind.BindField;
import net.hero.engine.data.bind.BindText;
import net.hero.engine.data.connection.Connection;
import net.hero.engine.data.dataset.DataSet;
import net.hero.engine.data.field.FactoryField;
import net.hero.engine.data.field.Field;
import net.hero.engine.data.field.FieldDataBase;
import net.hero.engine.data.field.FieldFormula;
import net.hero.engine.data.field.FieldParameter;
import net.hero.engine.document.Document;
import net.hero.engine.document.DocumentBuilder;
import net.hero.engine.document.control.Control;
import net.hero.engine.document.control.ControlLabel;
import net.hero.engine.document.control.ControlShape;
import net.hero.engine.document.control.ControlSubReport;
import net.hero.engine.document.control.ControlTable;
import net.hero.engine.document.control.ControlTableCell;
import net.hero.engine.document.control.ControlTableCol;
import net.hero.engine.document.control.ControlTableRow;
import net.hero.engine.document.control.FactoryControl;
import net.hero.engine.document.report.Report;
import net.hero.engine.document.section.Section;
import net.hero.engine.document.section.SectionNormal;
import net.hero.engine.document.section.SectionSubReport;
import net.hero.engine.style.Style;
import net.hero.engine.style.StyleManager;
import net.hero.engine.style.conditional.Condition;
import net.hero.engine.style.conditional.ConditionalStyle;

public class DocumentBuilderXML
implements DocumentBuilder {
    @Override
    public Document createDocument(String path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("pas is empty");
        }
        Document document = new Document();
        XMLDocument xml = new XMLDocument();
        xml.load(path);
        this.fillGlobal(document, xml);
        XMLElement elementBody = xml.selectSingleNode("document/body");
        this.fillBody(document, document.getReport(), elementBody);
        return document;
    }

    protected void fillGlobal(Document document, XMLDocument xml) {
        if (document == null || xml == null) {
            return;
        }
        this.fillGlobalField(document, xml);
        this.fillGlobalDataSet(document, xml);
        this.fillGlobalDefaultStyle(document, xml);
        this.fillGlobalStyle(document, xml);
    }

    protected void fillBody(Document document, Report report, XMLElement elementBody) {
        if (document == null || report == null || elementBody == null) {
            return;
        }
        if (elementBody != null && !elementBody.isNull()) {
            report.setDataSetName(elementBody.getAttribute("dataset-name"));
        }
        this.fillBodyLocalField(document, report, elementBody);
        this.fillBodyConditionalStyle(document, report, elementBody);
        this.fillPage(document, report, elementBody);
    }

    protected void fillGlobalField(Document document, XMLDocument xml) {
        XMLElementList list = xml.selectNodes("document/global/fields/field-set[@field-type='parameter']/field");
        if (list == null || list.isNull()) {
            return;
        }
        int i = 0;
        while (i < list.getLength()) {
            XMLElement element = list.getChild(i);
            assert (element != null);
            String fieldName = element.getAttribute("name");
            FieldParameter field = (FieldParameter)FactoryField.getInstance().createField("parameter", fieldName);
            field.setParameterValue(element.getText());
            document.getGlobal().getFieldManager().addField(field);
            ++i;
        }
    }

    protected void fillGlobalDataSet(Document document, XMLDocument xml) {
        XMLElementList list = xml.selectNodes("document/global/connections/connection");
        if (list == null || list.isNull()) {
            return;
        }
        int i = 0;
        while (i < list.getLength()) {
            int j;
            XMLElement element = list.getChild(i);
            assert (element != null);
            String connectionType = element.getAttribute("connection-type");
            String connectionName = element.getAttribute("connection-name");
            Connection connection = document.getGlobal().getConnectionManager().createConnection(connectionType, connectionName);
            if (connection instanceof Property) {
                XMLElementList listConfigParam = element.selectNodes("config-param-list/config-param");
                j = 0;
                while (j < listConfigParam.getLength()) {
                    XMLElement elementConfigParam = listConfigParam.getChild(j);
                    ((Property)((Object)connection)).setProperty(elementConfigParam.getAttribute("name"), elementConfigParam.getText());
                    ++j;
                }
            }
            XMLElementList datasetElementList = element.selectNodes("dataset");
            j = 0;
            while (j < datasetElementList.getLength()) {
                XMLElement elementDataSet = datasetElementList.getChild(j);
                String type = elementDataSet.getAttribute("dataset-type");
                String name = elementDataSet.getAttribute("name");
                String data = elementDataSet.getText();
                DataSet dataset = connection.createDataSet(type, name);
                if (dataset instanceof Property) {
                    XMLElementList listConfigParam = elementDataSet.selectNodes("config-param-list/config-param");
                    int k = 0;
                    while (k < listConfigParam.getLength()) {
                        XMLElement elementConfigParam = listConfigParam.getChild(k);
                        ((Property)((Object)dataset)).setProperty(elementConfigParam.getAttribute("name"), elementConfigParam.getText());
                        ++k;
                    }
                }
                XMLElementList listFieldDataBase = elementDataSet.selectNodes("fields/field-set[@field-type='database']/field");
                int n = 0;
                while (n < listFieldDataBase.getLength()) {
                    XMLElement elementField = listFieldDataBase.getChild(n);
                    dataset.getDataSetMeta().createColumn(elementField.getAttribute("name")).setXPath(elementField.getAttribute("xpath"));
                    ++n;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void fillGlobalDefaultStyle(Document document, XMLDocument xml) {
        XMLElementList list = xml.selectNodes("document/global/styles/default-style");
        if (list == null || list.isNull()) {
            return;
        }
        int i = 0;
        while (i < list.getLength()) {
            XMLElement element = list.getChild(i);
            String family = element.getAttribute("family");
            Style style = document.getGlobal().getStyleManager().getDefaultStyle(family);
            if (style != null) {
                String[] attributeNames;
                String[] stringArray = attributeNames = style.getAttributeNames();
                int n = attributeNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String attributeName = stringArray[n2];
                    style.setAttribute(attributeName, element.getAttribute(attributeName));
                    ++n2;
                }
            }
            ++i;
        }
    }

    protected void fillGlobalStyle(Document document, XMLDocument xml) {
        XMLElementList list = xml.selectNodes("document/global/styles/style");
        if (list == null || list.isNull()) {
            return;
        }
        int i = 0;
        while (i < list.getLength()) {
            String[] attributeNames;
            XMLElement element = list.getChild(i);
            assert (element != null);
            String family = element.getAttribute("family");
            String name = element.getAttribute("name");
            Style style = document.getGlobal().getStyleManager().createStyle(family, name);
            String[] stringArray = attributeNames = style.getAttributeNames();
            int n = attributeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeName = stringArray[n2];
                style.setAttribute(attributeName, element.getAttribute(attributeName));
                ++n2;
            }
            ++i;
        }
    }

    protected void fillBodyLocalField(Document document, Report report, XMLElement elementBody) {
        Field field;
        String fieldName;
        XMLElement element;
        int i;
        XMLElementList list = elementBody.selectNodes("local/fields/field-set[@field-type='database']/field");
        if (list != null && !list.isNull()) {
            i = 0;
            while (i < list.getLength()) {
                element = list.getChild(i);
                assert (element != null);
                fieldName = element.getAttribute("name");
                field = (FieldDataBase)FactoryField.getInstance().createField("database", fieldName);
                field.setIndex(i);
                ((FieldDataBase)field).setXPath(element.getAttribute("xpath"));
                report.getFieldManager().addField(field);
                ++i;
            }
        }
        if ((list = elementBody.selectNodes("local/fields/field-set[@field-type='formula']/field")) != null && !list.isNull()) {
            i = 0;
            while (i < list.getLength()) {
                element = list.getChild(i);
                assert (element != null);
                fieldName = element.getAttribute("name");
                field = (FieldFormula)FactoryField.getInstance().createField("formula", fieldName);
                field.setIndex(i);
                ((FieldFormula)field).setFormulaScript(element.getText());
                report.getFieldManager().addField(field);
                ++i;
            }
        }
    }

    protected void fillBodyConditionalStyle(Document document, Report report, XMLElement elementBody) {
        XMLElementList list = elementBody.selectNodes("local/conditional-style/style");
        if (list == null || list.isNull()) {
            return;
        }
        int i = 0;
        while (i < list.getLength()) {
            XMLElement element = list.getChild(i);
            assert (element != null);
            String name = element.getAttribute("name");
            ConditionalStyle conditionalStyle = new ConditionalStyle(name);
            XMLElementList listCondition = element.selectNodes("condition");
            int j = 0;
            while (j < listCondition.getLength()) {
                XMLElement elementCondition = listCondition.getChild(j);
                String expression = "";
                XMLElement elementExpression = elementCondition.selectSingleNode("expression");
                if (elementExpression != null && !elementExpression.isNull()) {
                    expression = elementExpression.getText();
                }
                Condition condition = conditionalStyle.addCondition(expression);
                XMLElementList listStyle = elementCondition.selectNodes("style");
                int k = 0;
                while (k < listStyle.getLength()) {
                    XMLElement elementStyle = listStyle.getChild(k);
                    String familyName = elementStyle.getAttribute("family");
                    Map<String, String> mapAttribute = elementStyle.getAllAttribute();
                    for (Map.Entry<String, String> entry : mapAttribute.entrySet()) {
                        String attributeName = entry.getKey();
                        String attributeValue = entry.getValue();
                        if (attributeName.equalsIgnoreCase("family") || attributeName.equalsIgnoreCase("name")) continue;
                        condition.addStyle(familyName, attributeName, attributeValue);
                    }
                    ++k;
                }
                ++j;
            }
            report.getConditionalStyleManager().addConditionalStyle(conditionalStyle);
            ++i;
        }
    }

    protected void fillPage(Document document, Report report, XMLElement elementBody) {
        XMLElementList list;
        XMLElement elementPage = elementBody.selectSingleNode("page");
        if (elementPage != null && !elementPage.isNull()) {
            report.getPage().setPageType(elementPage.getAttribute("page-type")).setPageWidth(elementPage.getAttributeInt("page-width")).setPageHeight(elementPage.getAttributeInt("page-height")).setPageMarginLeft(elementPage.getAttributeInt("page-margin-left")).setPageMarginRight(elementPage.getAttributeInt("page-margin-right")).setPageMarginTop(elementPage.getAttributeInt("page-margin-top")).setPageMarginBottom(elementPage.getAttributeInt("page-margin-bottom"));
        }
        if ((list = elementBody.selectNodes("page/section-set")) == null || list.isNull()) {
            return;
        }
        int i = 0;
        while (i < list.getLength()) {
            String sectionType = list.getChild(i).getAttribute("section-type");
            this.fillSectionSet(document, report, list.getChild(i), sectionType);
            ++i;
        }
    }

    protected void fillSectionSet(Document document, Report report, XMLElement element, String sectionType) {
        assert (element != null);
        XMLElementList list = element.selectNodes("section");
        if (list == null || list.isNull()) {
            return;
        }
        int i = 0;
        while (i < list.getLength()) {
            this.fillSection(document, report, list.getChild(i), sectionType);
            ++i;
        }
    }

    protected void fillSection(Document document, Report report, XMLElement element, String sectionType) {
        StyleManager styleManager = document.getGlobal().getStyleManager();
        Section section = null;
        String sectionName = element.getAttribute("name");
        int sectionHeight = element.getAttributeInt("height");
        XMLElement elementBody = element.selectSingleNode("body");
        section = elementBody != null && !elementBody.isNull() ? (Section)FactoryControl.getInstance().createControl("section.subreport", "", styleManager) : (Section)FactoryControl.getInstance().createControl("section.normal", "", styleManager);
        section.setName(sectionName);
        section.setHeight(sectionHeight);
        if (sectionType.equals("reportheader")) {
            report.getPage().addSectionRH(section);
        } else if (sectionType.equals("reportfooter")) {
            report.getPage().addSectionRF(section);
        } else if (sectionType.equals("pageheader")) {
            report.getPage().addSectionPH(section);
        } else if (sectionType.equals("pagefooter")) {
            report.getPage().addSectionPF(section);
        } else if (sectionType.equals("detail")) {
            report.getPage().addSectionDE(section);
        }
        String[] stringArray = Section.STYLE_FAMILYS;
        int n = Section.STYLE_FAMILYS.length;
        int n2 = 0;
        while (n2 < n) {
            String family = stringArray[n2];
            String name = element.getAttribute(String.valueOf(family) + "-style");
            Style style = document.getGlobal().getStyleManager().getStyle(name);
            if (style != null) {
                section.changeStyle(style);
            }
            ++n2;
        }
        String styleName = element.getAttribute("conditional-style");
        if (!styleName.isEmpty()) {
            ConditionalStyle style = report.getConditionalStyleManager().getConditionalStyle(styleName);
            section.setConditionalStyle(style);
        }
        if (section instanceof SectionNormal) {
            XMLElementList list = element.selectNodes("control");
            if (list == null || list.isNull()) {
                return;
            }
            int i = 0;
            while (i < list.getLength()) {
                this.fillControl(document, report, list.getChild(i), (SectionNormal)section);
                ++i;
            }
        } else if (section instanceof SectionSubReport) {
            SectionSubReport sectionSubReport = (SectionSubReport)section;
            Report subReport = new Report(document);
            sectionSubReport.setReport(subReport);
            this.fillBody(document, sectionSubReport.getReport(), elementBody);
        }
    }

    protected void fillControl(Document document, Report report, XMLElement element, SectionNormal section) {
        String controlType = element.getAttribute("control-type");
        String controlName = element.getAttribute("name");
        Control control = FactoryControl.getInstance().createControl(controlType, controlName, document.getGlobal().getStyleManager());
        if (control != null) {
            if (controlType.equals("table")) {
                this.fillControlTable(document, report, element, (ControlTable)control);
            } else if (controlType.equals("textbox")) {
                this.fillControlLabel(document, report, element, (ControlLabel)control);
            } else if (controlType.equals("subreport")) {
                this.fillControlSubReport(document, report, element, (ControlSubReport)control);
            } else if (controlType.equals("shape")) {
                this.fillControlShape(document, report, element, (ControlShape)control);
            }
            section.addControl(control);
        }
    }

    protected void fillControlTable(Document document, Report report, XMLElement element, ControlTable control) {
        control.getRect().left = element.getAttributeInt("x1");
        control.getRect().top = element.getAttributeInt("y1");
        XMLElementList list = element.selectNodes("column");
        int i = 0;
        while (i < list.getLength()) {
            XMLElement columnElement = list.getChild(i);
            control.addColumn(new ControlTableCol(columnElement.getAttributeInt("width")));
            ++i;
        }
        list = element.selectNodes("row");
        i = 0;
        while (i < list.getLength()) {
            XMLElement rowElement = list.getChild(i);
            ControlTableRow row = new ControlTableRow(rowElement.getAttributeInt("height"));
            control.addRow(row);
            XMLElementList listCells = rowElement.selectNodes("cell");
            int j = 0;
            while (j < listCells.getLength()) {
                XMLElement cellElement = listCells.getChild(j);
                ControlTableCell cell = ControlTableCell.createControl(document.getGlobal().getStyleManager());
                cell.setRowSpan(cellElement.getAttributeInt("rowspan"));
                cell.setColSpan(cellElement.getAttributeInt("colspan"));
                String contentType = cellElement.getAttribute("content-type");
                if (contentType.equalsIgnoreCase("field")) {
                    String fieldName = cellElement.getText();
                    Field field = report.getFieldManager().getField(fieldName);
                    cell.setBind(new BindField(field));
                } else {
                    cell.setBind(new BindText(cellElement.getText()));
                }
                row.addCell(cell);
                String[] stringArray = ControlLabel.STYLE_FAMILYS;
                int n = ControlLabel.STYLE_FAMILYS.length;
                int n2 = 0;
                while (n2 < n) {
                    String family = stringArray[n2];
                    String name = cellElement.getAttribute(String.valueOf(family) + "-style");
                    Style style = document.getGlobal().getStyleManager().getStyle(name);
                    if (style != null) {
                        cell.changeStyle(style);
                    }
                    ++n2;
                }
                String conditionalStyle = cellElement.getAttribute("conditional-style");
                if (conditionalStyle != null && !conditionalStyle.isEmpty()) {
                    ConditionalStyle conditionalStyle2 = report.getConditionalStyleManager().getConditionalStyle(conditionalStyle);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void fillControlLabel(Document document, Report report, XMLElement element, ControlLabel control) {
        control.getRect().left = element.getAttributeInt("x1");
        control.getRect().top = element.getAttributeInt("y1");
        control.getRect().right = control.getRect().left + element.getAttributeInt("width");
        control.getRect().bottom = control.getRect().top + element.getAttributeInt("height");
        String contentType = element.getAttribute("content-type");
        if (contentType.equalsIgnoreCase("field")) {
            Field field = report.getFieldManager().getField(element.getText());
            control.setBind(new BindField(field));
        } else {
            control.setBind(new BindText(element.getText()));
        }
        String[] stringArray = ControlLabel.STYLE_FAMILYS;
        int n = ControlLabel.STYLE_FAMILYS.length;
        int n2 = 0;
        while (n2 < n) {
            String family = stringArray[n2];
            String name = element.getAttribute(String.valueOf(family) + "-style");
            Style style = document.getGlobal().getStyleManager().getStyle(name);
            if (style != null) {
                control.changeStyle(style);
            }
            ++n2;
        }
    }

    protected void fillControlSubReport(Document document, Report report, XMLElement element, ControlSubReport control) {
        control.getRect().left = element.getAttributeInt("x1");
        control.getRect().top = element.getAttributeInt("y1");
        control.getRect().right = control.getRect().left + element.getAttributeInt("width");
        control.getRect().bottom = control.getRect().top + element.getAttributeInt("height");
        XMLElement elementBody = element.selectSingleNode("body");
        Report subReport = new Report(document);
        control.setReport(subReport);
        this.fillBody(document, control.getReport(), elementBody);
    }

    protected void fillControlShape(Document document, Report report, XMLElement element, ControlShape control) {
        control.getRect().left = element.getAttributeInt("x1");
        control.getRect().top = element.getAttributeInt("y1");
        control.getRect().right = control.getRect().left + element.getAttributeInt("width");
        control.getRect().bottom = control.getRect().top + element.getAttributeInt("height");
        String conditionalStyle = element.getAttribute("conditional-style");
        if (conditionalStyle != null && !conditionalStyle.isEmpty()) {
            ConditionalStyle conditionalStyle2 = report.getConditionalStyleManager().getConditionalStyle(conditionalStyle);
        }
    }
}

