/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.document.control;

import net.hero.engine.base.Visible;
import net.hero.engine.common.context.Context;
import net.hero.engine.content.Content;
import net.hero.engine.content.ContentBuilder;
import net.hero.engine.content.instance.InstanceGroup;
import net.hero.engine.document.control.ControlCommon;
import net.hero.engine.document.control.InstanceInfo;
import net.hero.engine.document.page.PageInstance;
import net.hero.engine.document.report.Report;
import net.hero.engine.style.StyleManager;

public class ControlSubReport
extends ControlCommon
implements Visible {
    public static final String[] STYLE_FAMILYS = new String[]{"visible"};
    protected Visible visible = null;
    protected Report report = null;

    protected ControlSubReport() {
    }

    public static ControlSubReport createControl(StyleManager styleManager) {
        ControlSubReport control = new ControlSubReport();
        control.visible = styleManager.getDefaultStyleVisible();
        return control;
    }

    @Override
    public String getFamilyName() {
        return "subreport";
    }

    @Override
    public InstanceInfo[] createInstance(Context ctx, StyleManager styleManager) {
        this.report.getPage().setPageHeight(this.getRect().height());
        this.report.getPage().setPageWidth(this.getRect().width());
        Content content = new Content();
        ContentBuilder contentBuilder = new ContentBuilder();
        content.getGlobal().setStyleManager(styleManager);
        contentBuilder.buildContent(this.report, content);
        InstanceInfo[] listInstanceInfo = new InstanceInfo[]{new InstanceInfo()};
        InstanceGroup instance = InstanceGroup.createInstance(styleManager);
        listInstanceInfo[0].setInstance(instance);
        listInstanceInfo[0].setControl(this);
        instance.getRect().set(this.getRect());
        PageInstance[] pageInstances = content.getBody().getPages();
        if (pageInstances != null) {
            int cfr_ignored_0 = pageInstances.length;
        }
        return listInstanceInfo;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    @Override
    public boolean getVisible() {
        return this.visible.getVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible.setVisible(visible);
    }
}

