/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.style;

import java.awt.Color;
import net.hero.engine.base.Border;
import net.hero.engine.style.EnumLineStyle;
import net.hero.engine.style.Style;

public class BorderStyle
extends Style
implements Border {
    public static final String BORDER_RIGHT_COLOR = "border-right-color";
    public static final String BORDER_RIGHT_STYLE = "border-right-style";
    public static final String BORDER_RIGHT_WIDTH = "border-right-width";
    public static final String BORDER_LEFT_COLOR = "border-left-color";
    public static final String BORDER_LEFT_STYLE = "border-left-style";
    public static final String BORDER_LEFT_WIDTH = "border-left-width";
    public static final String BORDER_TOP_COLOR = "border-top-color";
    public static final String BORDER_TOP_STYLE = "border-top-style";
    public static final String BORDER_TOP_WIDTH = "border-top-width";
    public static final String BORDER_BOTTOM_COLOR = "border-bottom-color";
    public static final String BORDER_BOTTOM_STYLE = "border-bottom-style";
    public static final String BORDER_BOTTOM_WIDTH = "border-bottom-width";
    public static final String[] ATTRIBUTE_NAMES = new String[]{"border-right-color", "border-right-style", "border-right-width", "border-left-color", "border-left-style", "border-left-width", "border-top-color", "border-top-style", "border-top-width", "border-bottom-color", "border-bottom-style", "border-bottom-width"};

    public BorderStyle() {
        this.attributes.addAttribute(BORDER_RIGHT_COLOR, new Color(0, 0, 0));
        this.attributes.addAttribute(BORDER_RIGHT_STYLE, EnumLineStyle.SOLD);
        this.attributes.addAttribute(BORDER_RIGHT_WIDTH, 1);
        this.attributes.addAttribute(BORDER_LEFT_COLOR, new Color(0, 0, 0));
        this.attributes.addAttribute(BORDER_LEFT_STYLE, EnumLineStyle.SOLD);
        this.attributes.addAttribute(BORDER_LEFT_WIDTH, 1);
        this.attributes.addAttribute(BORDER_TOP_COLOR, new Color(0, 0, 0));
        this.attributes.addAttribute(BORDER_TOP_STYLE, EnumLineStyle.SOLD);
        this.attributes.addAttribute(BORDER_TOP_WIDTH, 1);
        this.attributes.addAttribute(BORDER_BOTTOM_COLOR, new Color(0, 0, 0));
        this.attributes.addAttribute(BORDER_BOTTOM_STYLE, EnumLineStyle.SOLD);
        this.attributes.addAttribute(BORDER_BOTTOM_WIDTH, 1);
    }

    @Override
    public String getFamilyName() {
        return "border";
    }

    @Override
    public String[] getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    @Override
    public Color getBorderRightColor() {
        return (Color)this.getAttribute(BORDER_RIGHT_COLOR).getValue();
    }

    @Override
    public int getBorderRightStyle() {
        return this.getAttribute(BORDER_RIGHT_STYLE).toInt();
    }

    @Override
    public int getBorderRightWidth() {
        return (Integer)this.getAttribute(BORDER_RIGHT_WIDTH).getValue();
    }

    @Override
    public Color getBorderLeftColor() {
        return (Color)this.getAttribute(BORDER_LEFT_COLOR).getValue();
    }

    @Override
    public int getBorderLeftStyle() {
        return this.getAttribute(BORDER_LEFT_STYLE).toInt();
    }

    @Override
    public int getBorderLeftWidth() {
        return (Integer)this.getAttribute(BORDER_LEFT_WIDTH).getValue();
    }

    @Override
    public Color getBorderTopColor() {
        return (Color)this.getAttribute(BORDER_TOP_COLOR).getValue();
    }

    @Override
    public int getBorderTopStyle() {
        return this.getAttribute(BORDER_TOP_STYLE).toInt();
    }

    @Override
    public int getBorderTopWidth() {
        return (Integer)this.getAttribute(BORDER_TOP_WIDTH).getValue();
    }

    @Override
    public Color getBorderBottomColor() {
        return (Color)this.getAttribute(BORDER_BOTTOM_COLOR).getValue();
    }

    @Override
    public int getBorderBottomStyle() {
        return this.getAttribute(BORDER_BOTTOM_STYLE).toInt();
    }

    @Override
    public int getBorderBottomWidth() {
        return (Integer)this.getAttribute(BORDER_BOTTOM_WIDTH).getValue();
    }

    @Override
    public void setBorderRightColor(Color color) {
        this.getAttribute(BORDER_RIGHT_COLOR).setValue(color);
    }

    @Override
    public void setBorderRightStyle(int style) {
        this.getAttribute(BORDER_RIGHT_STYLE).setEnum(style);
    }

    @Override
    public void setBorderRightWidth(int width) {
        this.getAttribute(BORDER_RIGHT_WIDTH).setValue(width);
    }

    @Override
    public void setBorderLeftColor(Color color) {
        this.getAttribute(BORDER_LEFT_COLOR).setValue(color);
    }

    @Override
    public void setBorderLeftStyle(int style) {
        this.getAttribute(BORDER_LEFT_STYLE).setEnum(style);
    }

    @Override
    public void setBorderLeftWidth(int width) {
        this.getAttribute(BORDER_LEFT_WIDTH).setValue(width);
    }

    @Override
    public void setBorderTopColor(Color color) {
        this.getAttribute(BORDER_TOP_COLOR).setValue(color);
    }

    @Override
    public void setBorderTopStyle(int style) {
        this.getAttribute(BORDER_TOP_STYLE).setEnum(style);
    }

    @Override
    public void setBorderTopWidth(int width) {
        this.getAttribute(BORDER_TOP_WIDTH).setValue(width);
    }

    @Override
    public void setBorderBottomColor(Color color) {
        this.getAttribute(BORDER_BOTTOM_COLOR).setValue(color);
    }

    @Override
    public void setBorderBottomStyle(int style) {
        this.getAttribute(BORDER_BOTTOM_STYLE).setEnum(style);
    }

    @Override
    public void setBorderBottomWidth(int width) {
        this.getAttribute(BORDER_BOTTOM_WIDTH).setValue(width);
    }
}

