/*
 * Decompiled with CFR 0.152.
 */
package net.hero.engine.style.conditional;

import java.util.HashMap;
import java.util.Map;
import net.hero.engine.common.context.Context;
import net.hero.engine.common.formula.FormulaEngine;
import net.hero.engine.style.Attribute;
import net.hero.engine.style.AttributeCollection;
import net.hero.engine.style.Style;
import net.hero.engine.style.StyleManager;
import net.hero.engine.style.StyleableElement;

public class Condition {
    protected String expression = "";
    protected Map<String, AttributeCollection> mapStyle = new HashMap<String, AttributeCollection>();

    public Condition(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void addStyle(String styleFamily, String attributeName, Object attributeValue) {
        AttributeCollection listAttribute = this.mapStyle.get(styleFamily);
        if (listAttribute == null) {
            listAttribute = new AttributeCollection();
            this.mapStyle.put(styleFamily, listAttribute);
        }
        listAttribute.add(new Attribute(attributeName, attributeValue));
    }

    public void applyConditionStyle(StyleableElement element, Context ctx) {
        if (element == null || !this.isConditionOK(ctx)) {
            return;
        }
        for (Map.Entry<String, AttributeCollection> entry : this.mapStyle.entrySet()) {
            String family = entry.getKey();
            AttributeCollection attributeCollection = entry.getValue();
            Style style = element.getStyle(family);
            for (Attribute attribute : attributeCollection) {
                style.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
    }

    public void applyConditionStyle(StyleableElement element, Context ctx, StyleManager manager) {
        if (element == null || manager == null || !this.isConditionOK(ctx)) {
            return;
        }
        for (Map.Entry<String, AttributeCollection> entry : this.mapStyle.entrySet()) {
            String family = entry.getKey();
            AttributeCollection attributeCollection = entry.getValue();
            Style style = element.getStyle(family);
            element.changeStyle(manager.createStyle(style, attributeCollection));
        }
    }

    public boolean isConditionOK(Context ctx) {
        if (ctx == null || this.expression.isEmpty()) {
            return false;
        }
        String result = FormulaEngine.getInstance().executeFormula(ctx, this.expression);
        return result.equalsIgnoreCase("1") || result.equalsIgnoreCase("true");
    }
}

