function createView()
{
	//xml데이터	
	var pXmlData;
	
	//현재페이지
	var nowPage = 1;	
	this.getNowPage = function(){
		return nowPage;
	}	
	//마지막페이지
	var lastPage = 1;	
	this.getLastPage = function(){
		return lastPage;
	}	

	//경로설정
	this.path = "";	
	this.setPath = function(path){		 
		this.path = path;		
	}
	
	//파라미터값 설정
	var parameter = "";
	this.addParameter = function(name,value){
		this.tmpParameter = "";
		this.tmpParameter = name + ":" + value+",";
		parameter = parameter + this.tmpParameter;		
	}
	//다음페이지이동
	this.onNextPage = function(){	
		onPageProcess("onNextPage");		
	}
	//끝페이지로이동
	this.onEndPage = function(){
		onPageProcess("onEndPage");
	}	
	//이전페이지이동
	this.onPrevPage = function(){
		onPageProcess("onPrevPage");
	}
	//처음페이지로이동
	this.onFirstPage = function(){
		onPageProcess("onFirstPage");
	}
	
	//확대
	var pageRatio = Math.floor(enumMMToPixel[nNowMMToPixel] * 100) + '%';
	this.getPageRatio = function(){
		return pageRatio;
	}
	this.onZoomIn = function(){				
		onPageProcess("onZoomIn");
	}
	//축소
	this.onZoomOut = function(){				
		onPageProcess("onZoomOut");
	}
	//비율100%유지
	this.onZoomKeep = function(){
		onPageProcess("onZoomKeep");
	}	
	
	this.onPrint = function(){
		this.element = document.getElementById('idCanvas');		 
		this.imageData = saveReportImageData('idCanvas',pXmlData,nowPage);
		this.widht = parseInt(this.element.width) + 10;
		this.height = parseInt(this.element.height) + 10;
		
		//html문서로 보이는 그림
		this.winHandle = window.open("","print","toolbar=no,scrollbars=yes,resizable=yes,width="+ (parseInt(this.widht) + 15)+ ",height="+this.height);
		if(this.winHandle != null)
		{
			this.htmlString = "<html><head><title>print</title></head>";
			this.htmlString += "<body>";
			for(var i = 0;i < this.imageData.length;i++){
				this.htmlString += "<a href=javascript:window.close()><image src=" + this.imageData[i] + " border=0 alt=close></a>";
			}
			this.htmlString += "</body></html>";
			this.winHandle.document.open();
			this.winHandle.document.write(this.htmlString);
			this.winHandle.document.close();
			this.winHandle.print().focus();
		}
	}
	var delayTime = false;
	this.getDelayTime = function(){
		return delayTime;
	}
	
	//실행
	this.run = function(){	
		//설정 초기화
		delayTime = false;
		nowPage = 1;		
		lastPage = 1;
		nNowMMToPixel = 6;
		pageRatio = Math.floor(enumMMToPixel[nNowMMToPixel] * 100) + '%';
	
		if(parameter.length > 0){
			parameter = parameter.slice(0, (parseInt(parameter.length) - 1));
		}
		document.getElementById("loadingDiv").style.display = "";
	
		
		$.ajax({
		    type: "POST",
		    url: this.path,    // 외부 도메인
		    data: {	            	
            	path : this.path,
            	parameter : parameter
            },
            success:function(data){	            	
            	
            	pXmlData = new loadXML(data);	
            
            	var error = drawReport('idCanvas',pXmlData,nowPage);            
            	lastPage = pXmlData.getPageCount();         
            	document.getElementById("loadingDiv").style.display = "none";    
            	
            	delayTime = true;	
            	parameter = "";            	
            	if(error == null){
            		alert("Error : Report Draw fail!");
            	}
            },
            error:function(request){
            	document.getElementById("loadingDiv").style.display = "none";
            	var errorMessage = new Array;
            	errorMessage["errorName"] = request.status;
            	errorMessage["errorString"] = request.responseText;
            	
            	var modal = window.showModalDialog("Error.html",errorMessage,"dialogWidth:340px;dialogHeight:190px;center:yes"); 
            	
            	//alert("code : " + request.status + "\r\nMessage : " + request.responseText);
           	}
            });
		 /*
		  //post 방식
		$.post(
				this.path,
	            {	            	
	            	path : this.path,
	            	parameter : parameter
	            },
	            function(data){	            	
	            	
	            	pXmlData = new loadXML(data);	            	
	            	drawReport('idCanvas',pXmlData,nowPage);	            
	            	lastPage = pXmlData.getPageCount();
	         
	            	document.getElementById("loadingDiv").style.display = "none";	            	
	            	delayTime = true;	
	            	parameter = "";
	            });
	    	*/
		delayTime = false;
	}	
	
	//선택별처리
	function onPageProcess(processID){		
		if(processID == "onNextPage"){		
			if(nowPage < lastPage){			
				nowPage++;			
			}
		}else if(processID == "onEndPage"){
			nowPage = lastPage;
		}else if(processID == "onPrevPage"){
			if(nowPage > 1){
				nowPage--;				
			}		
		}else if(processID == "onFirstPage"){
			nowPage = 1;
		}else if(processID == "onZoomIn"){			
			if(nNowMMToPixel > 0){
				nNowMMToPixel--;								
			}						
		}else if(processID == "onZoomOut"){
			this.nCount = enumMMToPixel.length - 1;
			if(nNowMMToPixel < nCount){
				nNowMMToPixel++;							
			}
		}else if(processID == "onZoomKeep"){
			nNowMMToPixel = 6;
		}
		pageRatio = Math.floor(enumMMToPixel[nNowMMToPixel] * 100) + '%';
		drawReport('idCanvas',pXmlData,nowPage);
	}
}