/*
 * @author Choi Dae-Sung @ D&SOFT
 * @version 2.0, 08/06/17
 *
 * setuser	:  ̵  йȣ 
 * add		: ޽ ߰
 * send		: ޽  (IOException catch required)
 * getr		: ۰ 
 * printr	: ۰ 
 */
import java.util.ArrayList;
import java.net.Socket;
import java.io.*;
import java.security.*;
import java.util.*;

class SMSClass2
{
	static final String IPADDR = "210.109.102.114";
	static final int PORT = 7803;
	static final String VERSION_STR = "TBSP/1.0";

	private String userid;
	private String passwd;
	private String crypt;
	private ArrayList<String []> msgque;
	private ArrayList<HashMap> result;
	private Socket sock;
	private BufferedOutputStream fos;
	private BufferedInputStream bis;

	SMSClass2() 
	{
		crypt = "MD5";
		msgque = new ArrayList<String []>();
		result = new ArrayList<HashMap>();

	}

	public void connect() throws IOException
	{
		sock = new Socket(IPADDR, PORT);
		fos = new BufferedOutputStream(sock.getOutputStream());
		bis = new BufferedInputStream(sock.getInputStream());
	}

	public void disconnect() throws IOException
	{
		sock.close();
	}

	public void setuser(String userid, String passwd) 
	{
		this.userid = userid;
		this.passwd = passwd;
	}

	/**
	 *   ޽ ߰
	 *
	 * @param callno ޴¹ȣ
	 * @param callback ȸŹȣ
	 * @param message ޽80Ʈ
	 */
	public void add(String callno, String callback, String message) 
	{
		add(callno, callback, message, null, null, null);
	}

	/**
	 *  ( ̸) ޽ ߰
	 *
	 * @param callno ޴¹ȣ
	 * @param callback ȸŹȣ
	 * @param message ޽80Ʈ
	 * @param callname  ̸
	 */

	public void add(String callno, String callback, String message, String callname) 
	{
		add(callno, callback, message, callname, null, null);
	}

	/**
	 *   ޽ ߰
	 *
	 * @param callno ޴¹ȣ
	 * @param callback ȸŹȣ
	 * @param message ޽80Ʈ
	 * @param callname  ̸
	 * @param date Ͻ YYYYMMDDHHMISS
	 */
	public void add(String callno, String callback, String message, String callname, String date) 
	{
		add(callno, callback, message, callname, date, null);
	}

	/**
	 * Ŭ̾Ʈ  ޽ID  ޽ ߰
	 *
	 * @param callno ޴¹ȣ
	 * @param callback ȸŹȣ
	 * @param message ޽80Ʈ
	 * @param callname  ̸
	 * @param date Ͻ YYYYMMDDHHMISS
	 */
	public void add(String callno, String callback, String message, String callname, String date, String localkey) 
	{
		String[] tmsg = { callno, callback, message, callname, date, localkey };
		msgque.add(tmsg);
	}

	/**
	 * ޽  ; msgque add  ޽ Ѵ.
	 */
	public void send() throws IOException
	{
		if (userid == null || passwd == null)
		{
			System.out.println("setuser required");
			return;
		}


		for (int i = 0; i < msgque.size(); i++)
		{
			String[] tmsg = msgque.get(i);
			String callno = tmsg[0];
			String callback = tmsg[1];
			String message = tmsg[2];
			String callname = tmsg[3];
			String date = tmsg[4];
			String localkey = tmsg[5];

			byte[] packet = assembleFields(callno, callback, message, callname, date, localkey);
			fos.write(packet, 0, packet.length);
			fos.flush();

			String tbspstr = CSCP.read(bis);
			HashMap map = TBSP.parse(tbspstr);

			result.add(map);
		}
	}

	public HashMap credits() throws IOException
	{
		if (userid == null || passwd == null)
		{
			System.out.println("setuser required");
			return null;
		}

		HashMap map = new HashMap();

		map.put("VERSION", VERSION_STR);
		map.put("COMMAND", "CHECK-CREDITS");
		if (this.crypt == "MD5")
		{
			map.put("CRYPT-METHOD", "MD5");
			passwd = md5(this.passwd);
		} else {
			passwd = this.passwd;
		}
		map.put("AUTH-ID", this.userid);
		map.put("AUTH-PASS", passwd);
		map.put("LANGUAGE", "JAVA");

		String packet = CSCP.build(TBSP.build(map));
		fos.write(packet.getBytes(), 0, packet.getBytes().length);
		fos.flush();

		String tbspstr = CSCP.read(bis);
		return TBSP.parse(tbspstr);
	}

	public HashMap rcheck(String msgid) throws IOException
	{
		if (userid == null || passwd == null)
		{
			System.out.println("setuser required");
			return null;
		}

		HashMap map = new HashMap();

		map.put("VERSION", VERSION_STR);
		map.put("COMMAND", "CHECK-RESULT");
		if (this.crypt == "MD5")
		{
			map.put("CRYPT-METHOD", "MD5");
			passwd = md5(this.passwd);
		} else {
			passwd = this.passwd;
		}
		map.put("AUTH-ID", this.userid);
		map.put("AUTH-PASS", passwd);
		map.put("LANGUAGE", "JAVA");
		map.put("MESSAGE-ID", msgid);

		String packet = CSCP.build(TBSP.build(map));
		fos.write(packet.getBytes(), 0, packet.getBytes().length);
		fos.flush();

		String tbspstr = CSCP.read(bis);
		return TBSP.parse(tbspstr);
	}

	public void printr()
	{
		int succ=0;
		int fail=0;

		for (int i = 0; i < result.size(); i++)
		{
			HashMap map = result.get(i);

			String message_id = (String)map.get("MESSAGE-ID");
			String called_number = (String)map.get("CALLED-NUMBER");
			String result_code = (String)map.get("RESULT-CODE");
			String result_message = (String)map.get("RESULT-MESSAGE");

			System.out.println("Message ID: " + message_id);
			System.out.println("Called Number: " + called_number);
			System.out.println("Result Code: " + result_code);
			System.out.println("Result Message: " + result_message);
		}
	}

	public ArrayList getr() 
	{
		return result;
	}

	private byte[] spacing(byte[] byteArr, int length)
	{
		byte[] retArr = new byte[length];
		int byteArr_size = byteArr.length;

		if (byteArr.length > length)
			byteArr_size = length;

		System.arraycopy(byteArr, 0, retArr, 0, byteArr_size);

		for (int i = byteArr_size; i < (length - byteArr_size); i++)
		{
			retArr[i] = ' ';
		}

		return retArr;
	}

	private String md5(String str)
	{
		StringBuffer hexString = new StringBuffer();
		byte[] byteStr = str.getBytes();
		try{
			MessageDigest algorithm = MessageDigest.getInstance("MD5");
			algorithm.reset();
			algorithm.update(byteStr);
			byte messageDigest[] = algorithm.digest();
			    
			for (int i = 0; i < messageDigest.length; i++) {
				hexString.append(String.format("%02x", 0xFF & messageDigest[i]));
			}
		} catch(NoSuchAlgorithmException e) {
			System.out.println(e.getMessage());
		}
		return hexString.toString();
	}
	private byte[] assembleFields(String callno, String callback, String message, String callname, String date, String localkey)
	{
		HashMap map = new HashMap();
		String passwd;

		map.put("VERSION", VERSION_STR);
		map.put("COMMAND", "SEND");
		if (localkey != null)
			map.put("MESSAGE-ID", localkey);
		map.put("CALLED-NUMBER", callno);
		map.put("CALLING-NUMBER", callback);
		map.put("MESSAGE", message);
		if (callname != null)
			map.put("CALLED-NAME", callname);
		if (date != null)
			map.put("RESERVE-DATE", date);
		if (this.crypt == "MD5")
		{
			map.put("CRYPT-METHOD", "MD5");
			passwd = md5(this.passwd);
		} else {
			passwd = this.passwd;
		}
		map.put("AUTH-ID", this.userid);
		map.put("AUTH-PASS", passwd);
		map.put("LANGUAGE", "JAVA");

		String packet = CSCP.build(TBSP.build(map));

		return packet.getBytes();
	}
}
