#!/usr/bin/python
"""
 CSCM2 Python Module

 Copyright (C) 2008, D&SOFT
 <help@coolsms.co.kr>
"""
import sys,string,md5,socket,time,random
import tbsp

try:
	True
except NameError:
	False = 0
	True = not False

class coolsms:
	def __init__(self):
		self.version = "TBSP/1.0"
		self.host = "210.109.102.114"
		self.port = 7803
		self.userid = ""
		self.passwd = ""
		self.crypt = "MD5"
		self.msgque = []
		self.result = []
		self.sock = False

	def __validate_callno__(self, callno):
		if len(callno) < 10 or len(callno) > 11:
			print "phone number is invalid"
			return False
		return True

	def __validate_message__(self, msg):
		if len(msg) == False:
			print "message is null"
			return False
		if len(msg) > 80:
			print "message is too big"
			return False
		return True

	def is_connected(self):
		if self.sock == False:
			return False
		return True

	def connect(self):
		if self.sock == False:
			self.sock  = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
			self.sock.connect((self.host, self.port))

	def disconnect(self):
		if self.sock != False:
			self.sock.close()

	def setuser(self, userid, passwd):
		self.userid = userid
		self.passwd = passwd

	def setcrypt(crypt="MD5"):
		self.crypt = crypt

	def add(self, callno, callback, msg, name="", date="", msgid=""):

		if self.__validate_callno__(callno) == False:
			return False
		if self.__validate_message__(msg) == False:
			return False

		self.msgque.append({ 
				"callno" : callno
				, "callback" : callback
				, "msg" : msg
				, "name" : name
				, "date" : date
				, "msgid" : msgid
			})
		return True

	def count(self):
		return len(self.msgque)

	def md5(self, str):
		hash = md5.new()
		hash.update(str)
		return string.join(map(lambda v: "%02x" % ord(v), hash.digest()), "")

	def keygen(self):
		microsecond = "%f" % (time.time())
		randnum = "%u" % (random.randint(100000,999999))
		return time.strftime("%Y%m%d%H%M%S", time.localtime(time.time())) + microsecond[-6:] + randnum

	def send(self):

		if self.is_connected() == False:
			print "not connected"
			return

		for i in range(len(self.msgque)):
			x = self.msgque[i]
			msg = {}

			msg["VERSION"] = self.version
			msg["COMMAND"] = "SEND"
			msg["MESSAGE"] = x["msg"]
			if len(x["msgid"]) != 0:
				msg["MESSAGE-ID"] = x["msgid"]
			msg["CALLED-NUMBER"] = x["callno"]
			msg["CALLING-NUMBER"] = x["callback"]
			if len(x["name"]) != 0:
				msg["CALLED-NAME"] = x["name"]
			if len(x["date"]) != 0:
				msg["RESERVE-DATE"] = x["date"]
			if self.crypt == "MD5":
				msg["CRYPT-METHOD"] = "MD5"
				passwd = self.md5(self.passwd)
			else:
				passwd = self.passwd
			msg["AUTH-ID"] = self.userid
			msg["AUTH-PASS"] = passwd
			msg["LANGUAGE"] = "PYTHON-" + string.split(sys.version, " ")[0]

			cscpstr = tbsp.cscp_build(tbsp.tbsp_build(msg))

			self.sock.send(cscpstr)

			result = tbsp.cscp_read(self.sock)
			ack = tbsp.tbsp_parse(result)

			self.result.append(ack)

	def credits(self):
		if self.is_connected() == False:
			print "not connected"
			return


		msg = {}

		msg["VERSION"] = self.version
		msg["COMMAND"] = "CHECK-CREDITS"
		if self.crypt == "MD5":
			msg["CRYPT-METHOD"] = "MD5"
			passwd = self.md5(self.passwd)
		else:
			passwd = self.passwd
		msg["AUTH-ID"] = self.userid
		msg["AUTH-PASS"] = passwd
		msg["LANGUAGE"] = "PYTHON-" + string.split(sys.version, " ")[0]

		cscpstr = tbsp.cscp_build(tbsp.tbsp_build(msg))

		self.sock.send(cscpstr)

		result = tbsp.cscp_read(self.sock)
		ack = tbsp.tbsp_parse(result)

		return ack

	def rcheck(self, msgid):
		if self.is_connected() == False:
			print "not connected"
			return


		msg = {}

		msg["VERSION"] = self.version
		msg["COMMAND"] = "CHECK-RESULT"
		if self.crypt == "MD5":
			msg["CRYPT-METHOD"] = "MD5"
			passwd = self.md5(self.passwd)
		else:
			passwd = self.passwd
		msg["AUTH-ID"] = self.userid
		msg["AUTH-PASS"] = passwd
		msg["MESSAGE-ID"] = msgid
		msg["LANGUAGE"] = "PYTHON-" + string.split(sys.version, " ")[0]

		cscpstr = tbsp.cscp_build(tbsp.tbsp_build(msg))

		self.sock.send(cscpstr)

		result = tbsp.cscp_read(self.sock)
		ack = tbsp.tbsp_parse(result)

		return ack

	def getr(self):
		return self.result

	def printr(self):
		for i in range(len(self.result)):
			x = self.result[i]

			print "Called Number: " + x["CALLED-NUMBER"]
			print "Message ID: " + x["MESSAGE-ID"]
			print "Result Code: " + x["RESULT-CODE"]
			print "Result Message: " + x["RESULT-MESSAGE"]
