<?php
/**
 * Text Based SMS Protocol
 * Copyright (C) 2008, D&SOFT
 * <help@coolsms.co.kr>
 */

function tbsp_parse($tbspstr)
{
	$tbsparr = split("\n", $tbspstr);
	$property = array();

	foreach ($tbsparr as $line)
	{
		$element = split(":", $line);
		if (!isset($element[1]))
			continue;
		$name = $element[0];
		$value = $element[1];

		if ($name == "MESSAGE")
		{
			if (isset($property[$name]))
				$property[$name] .= "\n" . $value;
			else
				$property[$name] = $value;
		} else {
			$property[$name] = $value;
		}
	}
	return $property;
}

function tbsp_build($tbsp)
{
	$tbspstr = "";

	foreach ($tbsp as $name => $value)
	{
		if ($name == "MESSAGE")
		{
			$msgarr = split("\n", $value);
			foreach ($msgarr as $line)
			{
				$tbspstr .= $name . ":" . $line . "\n";
			}
		} else
			$tbspstr .= $name . ":" . $value . "\n";
	}

	return $tbspstr;
}


/**
 * CoolSMS Capsule Protocol
 */
function cscp_read($fp)
{
	$CSCP_VERSION_SIZE = 7;
	$CSCP_BODYLEN_SIZE = 6;

	$version = fread($fp, $CSCP_VERSION_SIZE);
	$bodylen = fread($fp, $CSCP_BODYLEN_SIZE);
	$bodylen = intval($bodylen);
	$body = "";
	if ($bodylen > 0)
		$body = fread($fp, $bodylen);

	return $body;
}

function cscp_build($cscpstr)
{
	$capsule = "CSCP1.0";
	$capsule .= sprintf("%6d", strlen($cscpstr));
	$capsule .= $cscpstr;

	return $capsule;
}

?>
