<%
'
' CS HTML Wrapper
' Copyright (C) 2008, D&SOFT
' diver@coolsms.co.kr
'
class DateBox
	private parent
	private self_format
	private self_default
	private self_yearfrom
	private self_yearto
	private self_decorate

	private sub Class_Initialize()
		set parent = new Bar
	
		self_format = "yyyymmdd"
		self_yearfrom = year(dateadd("yyyy", -2, date()))
		self_yearto = year(dateadd("yyyy", 2, date()))
		self_default = year(date()) & paddigits(month(date()), 2) & paddigits(day(date()), 2)
		self_decorate = false
	end sub

	public property let format(p_format)
		self_format = p_format
	end property
	public property let defval(defval_)
		self_default = defval_
	end property
	public property let decorate(decorate_)
		self_decorate = decorate_
	end property

	public function toStr()
		dim year_data
		dim month_data
		dim day_data
		dim year_default
		dim month_default
		dim day_default
		dim year_format
		dim month_format
		dim day_format
		dim i
		dim year_data_idx
		dim month_data_idx
		dim day_data_idx
		dim yyyy
		dim mm
		dim dd

		set year_data = Server.CreateObject("Scripting.Dictionary")
		set month_data = Server.CreateObject("Scripting.Dictionary")
		set day_data = Server.CreateObject("Scripting.Dictionary")

		year_default = mid(self_default, 1, 4)
		month_default = mid(self_default, 5, 2)
		day_default = mid(self_default, 7, 2)

		year_format = mid(self_format, 1, 4)
		month_format = mid(self_format, 5, 2)
		day_format = mid(self_format, 7, 2)

		year_data_idx = 0
		month_data_idx = 0
		day_data_idx = 0
		if year_format = "--" then
			year_data.Add year_data_idx, array("", "ü")
		end if
		if month_format =  "--" then
			month_data.Add month_data_idx, array("", "ü")
		end if
		if day_format = "--" then
			day_data.Add day_data_idx, array("", "ü")
		end if


		for i = self_yearfrom to self_yearto step 1
			year_data.Add i, array(cstr(i), cstr(i))
		next
		for i = 1 to 12 step 1
			month_data.Add i, array(paddigits(i, 2), cstr(i))
		next
		for i = 1 to 31 step 1
			day_data.Add i, array(paddigits(i, 2), cstr(i))
		next

		set yyyy = new ComboBox
		yyyy.name = name & "_yyyy"
		yyyy.data = year_data
		yyyy.defval = year_default
		set mm = new ComboBox
		mm.name = name & "_mm"
		mm.data = month_data
		mm.defval = month_default
		set dd = new ComboBox
		dd.name = name & "_dd"
		dd.data = day_data
		dd.defval = day_default

		if self_decorate = true then
			parent.Add array(yyyy, "", mm, "", dd, "")
		else
			parent.Add array(yyyy, mm, dd)
		end if

		toStr = parent.toStr()
	end function
	public sub Print()
		Response.Write toStr()
	end sub
%>
<!--#include file="Bar.inc.asp"--> 
<%
end class
%>
