<%
'
' CS HTML Wrapper
' Copyright (C) 2008, D&SOFT
' diver@coolsms.co.kr
'
class ComboBoxOption
	private parent
	private self_value
	private self_text
	private self_default

	private sub Class_Initialize()
		set parent = new Object
	end sub
	private sub Class_Terminate()
		set parent = Nothing
	end sub

	public property let value(value_)
		self_value = value_
	end property

	public property let text(text_)
		self_text = text_
	end property

	public property let defval (defval_)
		self_default = defval_
	end property

	public function toStr()
		dim str_

		if self_value = self_default then
			str_ = "<option selected value=""" & self_value & """>" & self_text & "</option>"
		else
			str_ = "<option value=""" & self_value & """>" & self_text & "</option>"
		end if

		toStr = str_
	end function

	function Print()
		Response.Write toStr()
	end function
%>
<!--#include file="Object.inc.asp"-->
<%
end class

class ComboBox
	private parent
	private self_data
	private self_default

	private sub Class_Initialize()
		set parent = new Container
		tag = "select"
		set self_data = CreateObject("Scripting.Dictionary")
	end sub

	public property let data(data_)
		set self_data = data_
	end property
	public property let defval(defval_)
		self_default = defval_
	end property

	public function toStr()
		dim key
		dim arr
		dim opt
		for each key in self_data
			arr = self_data.item(key)
			set opt = new ComboBoxOption
			opt.value = arr(0)
			opt.text = arr(1)
			opt.defval = self_default
			parent.Add opt
		next
		toStr = parent.toStr()
	end function

	public sub Print()
		Response.Write toStr()
	end sub
%>
<!--#include file="Container.inc.asp"-->
<%
end class
%>
