<%

class TimeBox
	private parent
	private self_format
	private self_defval
	private self_unit_display

	private sub Class_Initialize()
		set parent = new Bar
		self_format = "hhmi"
		self_defval = paddigits(hour(now()), 2) & paddigits(minute(now()), 2) & paddigits(second(now()), 2)
		self_unit_display = false
	end sub
	private sub Class_Terminate()
	end sub

	public property let format(p_format)
		self_format = p_format
	end property
	public property let defval(p_defval)
		self_defval = p_defval
	end property
	public property let unitDisplay(p_unitDisplay)
		self_unit_display = p_unitDisplay
	end property

	private function paddigits(n, totalDigits) 
		paddigits = Right(string(totalDigits,"0") & cstr(n), totalDigits) 
	end function 

	public function toStr()
		dim i
		dim hour_data
		dim minute_data
		dim second_data
		dim format_length
		dim today
		dim hour_default
		dim minute_default
		dim second_default
		dim mm
		dim mi
		dim ss

		set hour_data = Server.CreateObject("Scripting.Dictionary")
		set minute_data = Server.CreateObject("Scripting.Dictionary") 
		set second_data = Server.CreateObject("Scripting.Dictionary") 

		format_length = len(self_format)
		today = Now()

		for i = 0 to 24 step 1
			hour_data.Add i, array(paddigits(i, 2), cstr(i))
		next
		for i = 0 to 60 step 1
			minute_data.Add i, array(paddigits(i, 2), cstr(i))
		next
		for i = 0 to 60 step 1
			second_data.ADd i, array(paddigits(i, 2), cstr(i))
		next

		hour_default = mid(self_defval, 1, 2)
		minute_default = mid(self_defval, 3, 2)
		second_default = mid(self_defval, 5, 2)

		dim hh
		set hh = new ComboBox
		hh.name = name & "_hh"
		hh.data = hour_data
		hh.defval = hour_default

		Add array(hh)

		if self_unit_display then
			Add array("")
		end if

		if format_length >= 4 then
			set mi = new ComboBox
			mi.name = name & "_mi"
			mi.data = minute_data
			mi.defval = minute_default
			Add array(mi)
			if self_unit_display then
				Add array("")
			end if
		end if
		
		if format_length >= 6 then
			set ss = new ComboBox
			ss.name = name & "_ss"
			ss.data = second_data
			ss.defval = second_default
			Add array(ss)
			if self_unit_display then
				Add array("")
			end if
		end if
		toStr = parent.toStr()
	end function
	public sub Print()
		Response.Write toStr()
	end sub
%>
<!--#include file="Bar.inc.asp"-->
<%
end class
%>
