
/*
 * Copyright (C) 2008, D&SOFT
 * Choi Dae-Sung <diver@coolsms.co.kr>
 */

#include "stdafx.h"
#include "tcpconn.hpp"
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>


tcpconn::tcpconn()
	: sockfd(-1)
	, connected(false)
{
}

tcpconn::tcpconn(int _sockfd)
	: sockfd(_sockfd)
{
}


tcpconn::~tcpconn()
{
	close();
}

bool tcpconn::init()
{
	int one=1;
	int res;
	struct timeval tv;

	sockfd = socket(AF_INET, SOCK_STREAM, 0);
	if (sockfd < 0) {
		return false;
	}

        res = setsockopt(sockfd, IPPROTO_TCP, TCP_NODELAY, (char*)&one, sizeof(one));
	if(res < 0) {
		fprintf(stderr, "setsockopt error\n");
		return false;
	}

	tv.tv_sec = 3;
       	tv.tv_usec = 0; 
	
	res = setsockopt(sockfd, SOL_SOCKET, SO_SNDTIMEO, (const char *)&tv, sizeof(tv));
       	if(res < 0) {
	       	fprintf(stderr, "setsockopt error\n");
		return false;
       	} 

	res = setsockopt(sockfd, SOL_SOCKET, SO_RCVTIMEO, (const char *)&tv, sizeof(tv));
       	if(res < 0) {
	       	fprintf(stderr, "setsockopt error\n");
		return false;
       	}
	
	return true;
}

bool tcpconn::getaddr32(const std::string & saddr, u_long & addr)
{
	int i;
	struct hostent *host;
#ifdef INET_ATON
	struct in_addr iaddr;

	/* interprets the character string which represents a numeric internet address */
	if(inet_aton(saddr.c_str(), &iaddr) != 0)
		addr = iaddr.s_addr ;
	else
#else
	addr = inet_addr(saddr.c_str());
#endif
        if(addr == (uint32_t)-1)
	{	/*
		 * interprets domain name address if not numeric address.
		 */

		/* Old version doesn't support for interpreting the character string numeric address like "10.200.32.218" */
		host = gethostbyname(saddr.c_str());
		if(!host) return false;   /* none host */

		for(i = 0; i < 4; i++) {  /* 4Ʈ ּҸ (uint)addr ֱ */
			addr = addr << 8;
			addr += (unsigned char)host->h_addr[i];
		}

		addr = htonl(addr) ;
	} /* else */

	return true;
}

/*
void tcpconn::setnonblock()
{
	int val=0;

	val = fcntl(sockfd, F_GETFL, 0);
	fcntl(sockfd, F_SETFL, val | O_NONBLOCK);
}
*/

bool tcpconn::connect(const std::string & ipaddr, const uint16_t port)
{
	int res = 0;
	int dstaddrlen;
	struct sockaddr_in dstaddr;

	memset(&dstaddr, 0, sizeof(dstaddr));
	// dstaddr.sin_addr.s_addr = getNetAddress(ipaddr.c_str());
	if (!getaddr32(ipaddr, dstaddr.sin_addr.s_addr))
	{
		return false;
	}
	dstaddr.sin_family = AF_INET;
	dstaddr.sin_port = htons(port);
	dstaddrlen = sizeof(dstaddr);

	res = ::connect(sockfd, (struct sockaddr *)&dstaddr, dstaddrlen);
	if (res == -1)
		return false;

	connected = true;

	return true;
}

int tcpconn::send(const void *data, const size_t len)
{
	int res=0;
	int nSent=0;
	int countDown=0;

	countDown = (int)len;

	while (1) 
	{
		res = ::send(sockfd, (char *)data + nSent, countDown, 0);
                if(res == 0) 
		{
                        return 0;
                }
                if(res < 0) 
		{
                        return -1;
                }

                countDown -= res;
                nSent += res;
                if(countDown <= 0) break;
        }

	if(countDown != 0) return -1;

	return (int)len;
}


int tcpconn::recv(const int len, char *buf)
{
	int res=0;
	int nRcvd=0;
	int countDown=0;

	countDown = len;

	while(1) {
		res = ::recv(sockfd, buf, countDown, 0);
		if(res == 0) {
			fprintf(stderr, "recv time out\n");
			return res;
		}
		if(res < 0) {
			fprintf(stderr, "recv error\n");
			return res;
		}
		countDown -= res;
		nRcvd += res;
		if(countDown <= 0) break;
	}
	if(countDown != 0) return -1;

	return len;
}

bool tcpconn::listen(const std::string & ipaddr, int port)
{
	int res;
	int reuseflag = 1;
	int srcaddrlen=0;
	struct sockaddr_in srcaddr;

	memset(&srcaddr, 0, sizeof(srcaddr));
	if (!getaddr32(ipaddr, srcaddr.sin_addr.s_addr))
	{
		return false;
	}
	srcaddr.sin_port = htons(port);
	srcaddrlen = sizeof(srcaddr);

	res = bind(sockfd, (struct sockaddr *)&srcaddr, srcaddrlen);
	if(res < 0) 
		return false;

	res = setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, (const char *)&reuseflag, sizeof(reuseflag));
	if(res < 0) {
		return false;
	}

	if (::listen(sockfd, 10) == -1) 
		return false;

	return true;
}

SOCKET tcpconn::accept()
{
	SOCKET newfd;
	struct sockaddr_in cliaddr;
	int cliaddrlen = 0;

	newfd = ::accept(sockfd, (struct sockaddr *)&cliaddr, &cliaddrlen);

	return newfd;
}
