<!--
Cyworld Synchronizer
다이어리 한 페이지를 item들로 바꾸기
누가: 신재호 <netj@ropas.snu.ac.kr>
언제: 2004-12-02
-->
<xsl:stylesheet
    xmlns:html="http://www.w3.org/1999/xhtml"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:exsl="http://exslt.org/common"
    xmlns:cync="http://netj.org/2005/cync"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    exclude-result-prefixes="html exsl"
    version="1.0">

    <xsl:output method="xml" omit-xml-declaration="yes" encoding="utf-8"
        cdata-section-elements="cync:content"/>

    <xsl:template match="/">
        <items>
            <xsl:apply-templates select="//a[starts-with(@name,'I')]"/>
	</items>
    </xsl:template>

    <xsl:template match="a">
        <xsl:variable name="body" select="following-sibling::table[contains(@background,'/img5/pwin/dia_body_bg3.gif')][1]/tr/td"/>
        <xsl:choose>
            <xsl:when test="$body//style">
                <xsl:apply-templates select="." mode="since20050804"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="." mode="before20050804"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- 2005년 8월 4일 이후부터 -->
    <xsl:template match="a" mode="since20050804">
        <xsl:variable name="id" select="substring(@name, 2)"/>
        <xsl:variable name="head" select="following-sibling::table/tr/td[contains(@background,'/img5/pwin/dia_top_bg3.gif')][1]/table"/>
        <xsl:variable name="body" select="following-sibling::table[contains(@background,'/img5/pwin/dia_body_bg3.gif')][1]/tr/td"/>
        <xsl:variable name="comments" select="$body//form[contains(@action,'reply')]"/>
        <xsl:variable name="img" select="$body//img[starts-with(@id,'img_diary')]"/>

        <!-- 제목 -->
        <xsl:variable name="title" select="$body//p[1]/text()"/>

        <!-- 내용 -->
        <xsl:variable name="text"
            select="$body//p[2]/following-sibling::node()[position()&gt;1]"/>

        <item cync:id="diary_{$id}">
            <title>
                <xsl:choose>
                    <xsl:when test="$title">
                        <xsl:value-of select="normalize-space($title)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$body"/>
                    </xsl:otherwise>
                </xsl:choose>
            </title>
            <description>
                <xsl:if test="$img">
                    &lt;img src="<xsl:value-of select="$img/@src"/>"
                    width="175" align="left"&gt;
                </xsl:if>
                <xsl:apply-templates select="$text"
                    mode="rss-description"/>
            </description>
            <xsl:call-template name="do-date">
                <xsl:with-param name="date-container" select="$head"/>
            </xsl:call-template>
            <xsl:if test="$img"><cync:image src="{$img/@src}"/></xsl:if>
            <cync:content><xsl:apply-templates select="$text"
                    mode="cync-content"/></cync:content>
        </item>

        <!-- 코멘트들 -->
        <xsl:for-each select="$comments//a[starts-with(@href,'javascript:PZPopup')]">
            <item cync:id="diary_{$id}_{position()}">
                <cync:author><xsl:value-of select="."/></cync:author>
                <title><xsl:value-of select="normalize-space($title)"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="."/>의 <xsl:value-of select="position()"/>번 덧글</title>
                <description><xsl:value-of select="normalize-space(
                        substring-after(following-sibling::text(), ':'))"/></description>
                <dc:date><xsl:call-template name="to-iso-date">
                        <xsl:with-param name="date" select="translate(
                            following-sibling::font[1], '()', ' ')"/>
                </xsl:call-template></dc:date>
            </item>
        </xsl:for-each>
    </xsl:template>




    <!-- 2005년 8월 4일 이전용 -->
    <xsl:template match="a" mode="before20050804">
        <xsl:variable name="id" select="substring(@name, 2)"/>
        <xsl:variable name="head" select="following-sibling::table/tr/td[contains(@background,'/img5/pwin/dia_top_bg3.gif')][1]/table"/>
        <xsl:variable name="body" select="following-sibling::table[contains(@background,'/img5/pwin/dia_body_bg3.gif')][1]/tr/td"/>
        <xsl:variable name="comments" select="$body//form[contains(@action,'reply')]"/>
        <xsl:variable name="img" select="$body//img[starts-with(@id,'img_diary')]"/>

        <!-- 제목 -->
        <xsl:variable name="offset">
            <xsl:choose>
                <xsl:when test="$img">3</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="title"
            select="$body//br[number($offset)]/preceding-sibling::text()[1]"/>

        <!-- 내용 -->
        <xsl:variable name="textbegin">
            <xsl:call-template name="beginning-of-text">
                <xsl:with-param name="m" select="$title"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="text" select="exsl:node-set($textbegin)"/>

        <item cync:id="diary_{$id}">
            <title>
                <xsl:choose>
                    <xsl:when test="$title">
                        <xsl:value-of select="normalize-space($title)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$body"/>
                    </xsl:otherwise>
                </xsl:choose>
            </title>
            <description>
                <xsl:if test="$img">
                    &lt;img src="<xsl:value-of select="$img/@src"/>"
                    width="175" align="left"&gt;
                </xsl:if>
                <xsl:apply-templates select="$text"
                    mode="rss-description"/>
            </description>
            <xsl:call-template name="do-date">
                <xsl:with-param name="date-container" select="$head"/>
            </xsl:call-template>
            <xsl:if test="$img"><cync:image src="{$img/@src}"/></xsl:if>
            <cync:content><xsl:apply-templates select="$text"
                    mode="cync-content"/></cync:content>
        </item>

        <!-- 코멘트들 -->
        <xsl:for-each select="$comments//a[starts-with(@href,'javascript:PZPopup')]">
            <item cync:id="diary_{$id}_{position()}">
                <cync:author><xsl:value-of select="."/></cync:author>
                <title><xsl:value-of select="normalize-space($title)"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="."/>의 <xsl:value-of select="position()"/>번 덧글</title>
                <description><xsl:value-of select="normalize-space(
                        substring-after(following-sibling::text(), ':'))"/></description>
                <dc:date><xsl:call-template name="to-iso-date">
                        <xsl:with-param name="date" select="translate(
                            following-sibling::font[1], '()', ' ')"/>
                </xsl:call-template></dc:date>
            </item>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="beginning-of-text">
        <xsl:param name="m"/>
        <xsl:choose>
            <xsl:when test="$m/following-sibling::br[1] = $m/following-sibling::node()[1]">
                <xsl:call-template name="beginning-of-text">
                    <xsl:with-param name="m" select="$m/following-sibling::br[1]"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="$m/following-sibling::node()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>



    <!-- 날짜/시각 -->
    <xsl:template name="do-date">
        <xsl:param name="date-container"/>
        <xsl:variable name="date">
            <xsl:call-template name="to-iso-date">
                <xsl:with-param name="date">
                    <xsl:choose>
                        <xsl:when test="contains($date-container, ')')">
                            <xsl:value-of
                                select="substring-before($date-container, '(')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$date-container"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        <dc:date><xsl:value-of select="$date"/></dc:date>
        <cync:timestamp>
            <xsl:choose>
                <xsl:when test="contains($date-container, ')')">
                    <xsl:call-template name="to-iso-date">
                        <xsl:with-param name="date">
                            <xsl:value-of
                                select="substring-before(
                                substring-after($date-container, '('), ')')"/>
                        </xsl:with-param>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$date"/>
                </xsl:otherwise>
            </xsl:choose>
        </cync:timestamp>
    </xsl:template>

    <xsl:template name="to-iso-date">
        <xsl:param name="date"/>
        <xsl:value-of select="translate(
            normalize-space($date), ' .', 'T-')"/>
        <xsl:text>+09:00</xsl:text>
    </xsl:template>


    <!-- 내용 변환 -->
    <xsl:template match="*" mode="rss-description">
        <xsl:apply-templates mode="rss-description"/>
    </xsl:template>

    <xsl:template match="br" mode="rss-description">
        <xsl:text>&lt;br&gt;</xsl:text>
    </xsl:template>

    <xsl:template match="*" mode="cync-content">
        <xsl:apply-templates mode="cync-content"/>
    </xsl:template>

    <xsl:template match="p[. = ' ']" mode="cync-content"/>

    <xsl:template match="br" mode="cync-content">
        <xsl:text>&#10;</xsl:text>
    </xsl:template>

</xsl:stylesheet>
