/*
 * Created on 2004. 2. 18.
 */

package net.narusas.daap.server;

import java.io.*;
import java.net.*;
import java.text.*;
import java.util.zip.GZIPOutputStream;

import net.narusas.daap.server.api.Database;
import net.narusas.daap.server.api.UpdateListener;
import net.narusas.daap.server.response.*;
import net.narusas.daap.server.response.ContentCodeResponse;
import net.narusas.daap.server.response.DatabasesResponse;
import net.narusas.daap.server.response.LoginResponse;
import net.narusas.daap.server.response.ServerInfoResponse;
import net.narusas.daap.server.response.UpdateResponse;
import net.narusas.daap.server.tag.ListTag;

/**
 * @author Jisung, Ahn
 */
public class DaapSession extends Thread implements UpdateListener {

	private Socket requestorSocket;
	private SimpleDateFormat df;
	private static final String SERVER_INFO = "/server-info";
	private static final String LOGIN = "/login";
	private static final String CONTENT_CODES = "/content-codes";
	private static final String UPDATE = "/update";
	private static final String DATABASES_INFO = "/databases?";
	private static final String DATABASES_DATA = "/databases/";
	private static final String CONTAINERS_PLAYLIST = "/containers?";
	private static final String CONTAINERS_MUSIC = "/containers/";
	private static final String SONG_LIST = "/items?"; //type=music";
	private static final String GET_SONG = "/items/";
	private static final String CRLF = "\r\n";
	private Database _db;
	private int _session;
	private int _revision;
	private int _oldRevision;
	private static int _nexSession = 1;
	private JDaapServer _server;


	public DaapSession(JDaapServer server, Socket s, Database db) {
		super();
		_server = server;
		_db = db;
		requestorSocket = s;
		df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
		_session = _nexSession++;
		_revision = 1;
		_oldRevision = _revision;
	}


	/**
	 * Deal with the client.
	 */
	public void run() {
		this.setName("Daap session");
		try {
			InputStream in = new BufferedInputStream(requestorSocket.getInputStream());
			OutputStream out = new BufferedOutputStream(requestorSocket.getOutputStream());
			while (true) {
				DaapRequest req = new DaapRequest(in);
				DaapResponse res = getMatchedResponse(req);
				ListTag tag = res.getResponse();
				if (tag == null) {
					continue;
				}
				String resHTTP = getResonseHeader(tag);
				out.write(resHTTP.getBytes());
				if (tag.isStreaming()) {
					tag.toDaap(out);
				}
				else {
//					out.write(gzip(tag.toDaap()));
					out.write(tag.toDaap());
					out.flush();								
				}	
			}
		}
		catch (Exception ex) {
			ex.printStackTrace();
		}
		_server.removeSession(this);
	}


	/**
	 * @param bs
	 * @return
	 */
	private byte[] gzip(byte[] bs) {
		byte[] result = null;
		try {
			ByteArrayOutputStream bout = new ByteArrayOutputStream();
			GZIPOutputStream gzipOut;
			gzipOut = new GZIPOutputStream(bout);
			gzipOut.write(bs);
			gzipOut.flush();
			result = bout.toByteArray();			
		}
		catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
		
	}


	/**
	 * @param tag
	 * @return
	 */
	private String getResonseHeader(ListTag tag) {
		StringBuffer buf = new StringBuffer();
		buf.append("HTTP/1.1 200 OK" + CRLF);
		buf.append( "Date: Sat, 14 Feb 2004 17:42:33 GMT" + CRLF);
		buf.append( "DAAP-Server: narusasDaapServer/1.0 (Java)" + CRLF);		
		buf.append( "Accept-Ranges: bytes" + CRLF);
		buf.append( "Content-Length: "+ tag.length()+ CRLF);
		buf.append( "Content-Type: application/x-dmap-tagged" + CRLF);
		
//		buf.append("Content-Encoding: gzip"+CRLF);
		
//		if (!tag.isStreaming()) {
//			buf.append("Content-Encoding: gzip"+CRLF);
//		}
		
		buf.append( CRLF);		
		
		return buf.toString();
	}


	/**
	 * @param req
	 * @return
	 */
	private DaapResponse getMatchedResponse(DaapRequest req) {
		String res = req.getResponse();
		if ("MSRV".equals(res)) {
			return new ServerInfoResponse(req, _db);
		}
		else if ("MCCR".equals(res)) {
			return new ContentCodeResponse(req, _db);
		}
		else if ("MLOG".equals(res)) {
			return new LoginResponse(req, _db, _session);
		}
		else if ("MUPD".equals(res)) {
			return new UpdateResponse(req, _db, _revision);
		}
		else if ("AVDB".equals(res)) {
			return new DatabasesResponse(req, _db);
		}
		else if ("ADBS".equals(res)) {
			return new DatabaseResponse(req, _db);
		}
		else if ("APLY".equals(res)) {
			return new PlaylistResponse(req, _db);
		}
		else if ("APSO".equals(res)) {
			return new SongsResponse(req, _db);
		}
		else if ("MP3D".equals(res)) {
			return new MP3Response(req, _db);
		}
		return null;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see net.narusas.daap.server.api.UpdateListener#updated(net.narusas.daap.server.api.Database)
	 */
	public void updated(Database evetSource) {
		_revision++;
	}
}
