/*
 * Created on 2004. 2. 18.
 *
 */
package net.narusas.daap.server.tag;


/**
 * @author Administrator
 *
 */
public class IntegerTag extends Tag {

    protected int _data;

    public IntegerTag(String name) {
        _name = name;
        _type = Tag.TYPE_SIGNED_INT;
    }


    public void setData(int data) {
        _data = data;
    }

    public byte[] getData() {   
        byte[] b = new byte[4];
        b[3] = (byte) (_data & 0xFF);
        b[2] = (byte) ( (_data >>> 8) & 0xFF);
        b[1] = (byte) ( (_data >>> 16) & 0xFF);
        b[0] = (byte) ( (_data >>> 24) & 0xFF);
        return b;
    }    
    
    public int getDataLength() {
        return 4;
    }

}
