/*
 * Created on 2004. 2. 18.
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package net.narusas.daap.server.tag;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import junit.framework.TestCase;


/**
 * @author Administrator
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class TagTest extends TestCase {

    public void testIntTag() {
        IntegerTag intTag = Tag.integerTag("aaaa", 15);
        
        
        assertEquals("aaaa",intTag.getName());
        assertEquals(12, intTag.length());
        assertEquals(4, intTag.getDataLength());
        assertEquals(0,intTag.getData()[0]);
        assertEquals(0,intTag.getData()[1]);
        assertEquals(0,intTag.getData()[2]);
        assertEquals(15,intTag.getData()[3]);
   
        
    }
    
    public void testStringTag() throws Exception {
        StringTag tag = Tag.stringTag("AAAA","aaaa");
        assertEquals(12, tag.length());
        assertEquals(4, tag.getDataLength());
        
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write("AAAA".getBytes());
        bout.write(intTo4Bytes(4));
        bout.write("aaaa".getBytes());
        
        byte[] src = tag.toDaap();
        byte[] target = bout.toByteArray();
        
        for(int i =0; i < target.length;i++){
            assertEquals(i+"th test",target[i], src[i]);
        }
        
        tag = Tag.stringTag("AAAA","");
        assertEquals(8,tag.length());
        assertEquals(0,tag.getDataLength());
        byte[] daap = tag.toDaap();
        assertEquals(8,daap.length);
            
        
    }
    
    public void testListTag() throws IOException {
        ListTag list = Tag.listTag("adbs");
        assertEquals(8, list.length());
        assertEquals(0, list.getDataLength());
        assertNotNull(list.getData());
        assertEquals(0, list.getData().length);
        
        IntegerTag intTag = Tag.integerTag("aaaa", 15);        
        list.addTag(intTag);
        assertEquals(20, list.length());
        
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write("adbs".getBytes());
        bout.write(intTo4Bytes(12));
        bout.write("aaaa".getBytes());
        bout.write(intTo4Bytes(4));
        bout.write(intTo4Bytes(15));
        
        byte[] src = list.toDaap();
        byte[] target = bout.toByteArray();
        
        for(int i =0; i < target.length;i++){
            assertEquals(i+"th test",target[i], src[i]);
        }
    }
        
    
    public void testListInList() throws IOException {
        ListTag parentList = Tag.listTag("adbs");
        ListTag childList = Tag.listTag("avdb");
        parentList.addTag(childList);
        
        IntegerTag intTag =Tag.integerTag("aaaa", 15);
        
        
        childList.addTag(intTag);
        assertEquals(28, parentList.length());
        assertEquals(20, childList.length());
        
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write("adbs".getBytes());
        bout.write(intTo4Bytes(20));
        bout.write("avdb".getBytes());
        bout.write(intTo4Bytes(12));
        bout.write("aaaa".getBytes());
        bout.write(intTo4Bytes(4));
        bout.write(intTo4Bytes(15));
        
        byte[] src = parentList.toDaap();
        byte[] target = bout.toByteArray();
        for(int i =0; i < target.length;i++){
            assertEquals(i+"th test",target[i], src[i]);
        }
        
    }
    
    public void testSubstring() {
        String param = "asda=zzzz";
        String name = param.substring(0, param.indexOf("="));
        String value = param.substring(param.indexOf("=")+1);
        assertEquals("asda", name);
        assertEquals("zzzz", value);
    }
    
    public void testByte() {
        ByteTag tag = Tag.byteTag("abcd",0);
        assertEquals(1, tag.getDataLength());
        assertEquals(9, tag.length());
        
        assertEquals(9, tag.toDaap().length);
    }
    
    
    public static byte[] intTo4Bytes(int i) {
        byte[] b = new byte[4];
        b[3] = (byte) (i & 0xFF);
        b[2] = (byte) ( (i >>> 8) & 0xFF);
        b[1] = (byte) ( (i >>> 16) & 0xFF);
        b[0] = (byte) ( (i >>> 24) & 0xFF);
        return b;
    }

}
