<?php

//   stdlib.php, transform.php ο ̴  ...
$AllowedProtocols = "http|https|mailto|ftp|news|gopher";
$InlineImages = "png|jpg|gif|eps|tiff";
$prevSectionLevel = 0;

include_once('stdlib.php');
include_once('transform.php');

class WikiToDocBook 
{
	var $Transform;
	var $TopLevelElementName;
	var $IncludeDeclaration;
	var $FirstSectionName;
	function WikiToDocBook (
		$aDocInfo  =  array ( 
		 'TopLevelName' => 'article', 
				'IncludeDeclaration'=>true,
				'SectionMode' => 'asc',
				'FirstSection' => 'section' )
		) 
	{
		global $WikiNameRegexp, $AllowedProtocols, $InterWikiLinkRegexp;

		$this->TopLevelElementName = $aDocInfo['TopLevelName'];
	 	$this->IncludeDeclaration = $aDocInfo['IncludeDeclaration'];
	 	$this->FirstSectionName = $aDocInfo['FirstSection'];
	 	$aSectionMode = $aDocInfo['SectionMode'];
		$this->Transform = new WikiTransform;
		// register functions
		// functions are applied in order of registering
	
		$this->Transform->register(WT_TOKENIZER, 'wtt_footnotes', '^\[\d+\]');
		$this->Transform->register(WT_TOKENIZER, 'wtt_footnoterefs', '\[\d+\]');
		$this->Transform->register(WT_TOKENIZER, 'wtt_bracketlinks', '\[.+?\]');
		$this->Transform->register(WT_TOKENIZER, 'wtt_urls',
					  "!?\b($AllowedProtocols):[^\s<>\[\]\"'()]*[^\s<>\[\]\"'(),.?]");

		if (function_exists('wtm_table')) {
			$this->Transform->register(WT_MODE_MARKUP, 'wtm_table', '^\|');
		}
		
		$this->Transform->register(WT_SIMPLE_MARKUP, 'wtm_htmlchars');
		$this->Transform->register(WT_SIMPLE_MARKUP, 'wtm_emphasis');
		$this->Transform->register(WT_SIMPLE_MARKUP, 'wtm_simpleinlines');
		$this->Transform->register(WT_MODE_MARKUP, 'wtm_blockquotes'); 
		$this->Transform->register(WT_MODE_MARKUP, 'wtm_sub_sup'); 
		$this->Transform->register(WT_MODE_MARKUP, 'wtm_itemizedlist');
		$this->Transform->register(WT_MODE_MARKUP, 'wtm_orderedlist');
		//$this->Transform->register(WT_MODE_MARKUP, 'wtm_block_image');
		$this->Transform->register(WT_MODE_MARKUP, 'wtm_list_dl');
		$this->Transform->register(WT_MODE_MARKUP, 'wtm_preformatted');
		if ( $aSectionMode == 'asc' )
			$this->Transform->register(WT_MODE_MARKUP, 'wtm_section_ascending');
		else
			$this->Transform->register(WT_MODE_MARKUP, 'wtm_section_descending');
		$this->Transform->register(WT_MODE_MARKUP, 'wtm_para');
	}
	function convert($lines)
	{
		if (is_string($lines))
			 $lines = preg_split('/[ \t\r]*\n/', trim($lines));
 	
 		if ( $this->IncludeDeclaration) 
 		{
 			$top = "<?xml version=\"1.0\" encoding=\"euc-kr\"?>
<!DOCTYPE {$this->TopLevelElementName} SYSTEM \"/path/to/docbookx.dtd\">";
		}
		$html = $this->Transform->do_transform( $html, $lines) ;
		$top .=  "\n<{$this->TopLevelElementName} lang=\"ko\"";

		if ($this->Transform->user_data['HasTopLevelId'] == true )
			$top .= " id=\"{$this->Transform->user_data['TopLevelId']}\">\n";
		else 
			$top .= ">\n";

		$top .= "\n<{$this->TopLevelElementName}info>
<title>{$this->Transform->user_data['TopLevelTitle']}</title>";
		$top .= "\n</{$this->TopLevelElementName}info>\n";

		$html = preg_replace('|<section>|', '<' . $this->FirstSectionName . '>', $html, 1);
		$html = preg_replace('|</section>|', '</' . $this->FirstSectionName . '>', $html, 1);

		return $top . $html . "\n</{$this->TopLevelElementName}>\n";
	}
}

/*
Requirements for functions registered to WikiTransform:

Signature:  function wtm_xxxx($line, &$transform)

$line ... current line containing wiki markup
	(Note: it may already contain HTML from other transform functions)
&$transform ... WikiTransform object -- public variables of this
	object and their use see above.

Functions have to return $line (doesn't matter if modified or not)
All conversion should take place inside $line.

Tokenizer functions should use $transform->replacements to store
the replacement strings. Also, they have to keep track of
$transform->tokencounter. See functions below. Back substitution
of tokenized strings is done by do_transform().
*/



	//////////////////////////////////////////////////////////
	// Tokenizer functions


function wtt_doublebrackets($match, &$trfrm)
{
	return '[';
}

function wtt_footnotes($match, &$trfrm)
{
	// FIXME: should this set HTML mode?
	$ftnt = trim(substr($match,1,-1)) + 0;
	$fntext = "[$ftnt]";
	$html = "<br>";

	$fnlist = $trfrm->user_data['footnotes'][$ftnt];
	if (!is_array($fnlist))
		return $html . $fntext;	
	
	$trfrm->user_data['footnotes'][$ftnt] = 'footnote_seen';

	while (list($k, $anchor) = each($fnlist))
	{
		$html .=  Element("a", array("name" => "footnote-$ftnt",
					"href" => "#$anchor",
					"class" => "footnote-rev"),
			$fntext);
		$fntext = '+';
	}
	return $html;
}

function wtt_footnoterefs($match, &$trfrm)
{
	$ftnt = trim(subStr($match,1,-1)) + 0;

	$footnote_definition_seen = false;

	if (empty($trfrm->user_data['footnotes']))
		$trfrm->user_data['footnotes'] = array();
	if (empty($trfrm->user_data['footnotes'][$ftnt]))
		$trfrm->user_data['footnotes'][$ftnt] = array();
	else if (!is_array($trfrm->user_data['footnotes'][$ftnt]))
		$footnote_definition_seen = true;
	

	$args['href'] = "#footnote-$ftnt";
	if (!$footnote_definition_seen)
	{
		$args['name'] = "footrev-$ftnt-" .
	  count($trfrm->user_data['footnotes'][$ftnt]);
		$trfrm->user_data['footnotes'][$ftnt][] = $args['name'];
	}
	
	return Element('sup', array('class' => 'footnote'),
		  QElement("a", $args, "[$ftnt]"));
}

function wtt_bracketlinks($match, &$trfrm)
{
	$link = ParseAndLink($match);
	if (strstr($link['link'], "</form>")) {
		 // FIXME: BIG HACK: see note in wtm_plugin.
		 return "</p>" . $link['link'] . "<p>";
	}
	return $link["link"];
}

// replace all URL's with tokens, so we don't confuse them
// with Wiki words later. Wiki words in URL's break things.
// URLs preceeded by a '!' are not linked
function wtt_urls($match, &$trfrm)
{
	if ($match[0] == "!")
		return htmlspecialchars(substr($match,1));
	return LinkURL($match);
}

// end of tokenizer functions
//////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////
// basic simple markup functions

// escape HTML metachars
function wtm_htmlchars($line, &$transformer)
{
	$line = str_replace('&', '&amp;', $line);
	$line = str_replace('>', '&gt;', $line);
	$line = str_replace('<', '&lt;', $line);
	return($line);
}

//  (emphasis
function wtm_emphasis($line, &$transformer) {
//gryu+
	$line = preg_replace("|(''')(.*?)(''')|", '<emphasis>\2</emphasis>', $line);
	return $line;
}

// ܼ ζ ±׵. {{tagname content }}  .  ...(ܼ ġȯ ).
/* 
Ű {{keycap F1}} => <keycap>F1</keycap>
*/

function wtm_simpleinlines($line, &$transformer)
{
	$line = preg_replace( "|{{([[:alnum:]]+) (.*?)}}|" , '<\1>\2</\1>' , $line);
	return $line;
}

//////////////////////////////////////////////////////////
// mode markup functions


// tabless markup for unordered, ordered, and dictionary lists
// ul/ol list types can be mixed, so we only look at the last
// character. Changes e.g. from "**#*" to "###*" go unnoticed.
// and wouldn't make a difference to the HTML layout anyway.

// unordered lists <UL>: "*"
// has to be registereed before list OL
function wtm_itemizedlist($line, &$trfrm) {
	if (preg_match("/^([#*;]*\*)[^#]/", $line, $matches)) {
		$numtabs = strlen($matches[1]);
		$line = preg_replace("/^([#*]*\*)/", '', $line);
		$html = $trfrm->SetHTMLMode('itemizedlist', $numtabs) . '<listitem><para>';
		$line = $html . $line . '</para></listitem>';
	}
	return $line;
}

function wtm_section_descending($line, &$trfrm) 
{
	global $prevSectionLevel;
	if (preg_match("/^(!{1,4})[^!]/", $line, $whichheading))
	{
		$currLevel  = 5 - strlen( $whichheading[1] );
		$line =  preg_replace("/^(!{1,4})[^!]/", "", $line);
		$html = '';
		while ( $prevSectionLevel >= $currLevel )
		{
			$html .= "</section>\n";
			$prevSectionLevel--;
		}
		$prevSectionLevel = $currLevel;
		$html .= $trfrm->SetHTMLMode('',0 );
		if( preg_match("/(.*) ::(.*)::(\s*)$/", $line, $match) )
		{
			$SectionTag = "\n<section id=\"$match[2]\">\n";
			$line = $match[1];
			if ( $currLevel == 1)
			{
				$trfrm->user_data['HasTopLevelId'] = true;
				$trfrm->user_data['TopLevelId'] = $match[2];
			}
		}
		else
			$SectionTag = "\n<section>\n";
			
		if ($currLevel > 1) 
		{
			$html .= $SectionTag;
			$line = $html. '<title>'. $line . "</title>\n";
		}
		else
		{
			$trfrm->user_data['TopLevelTitle'] = $line;
			$line = '';
		}
	}
	return  $line;
}

function wtm_section_ascending($line, &$trfrm) 
{
	global $prevSectionLevel;
	if (preg_match("/^(!{1,4})[^!]/", $line, $whichheading))
	{
		$currLevel  =  strlen( $whichheading[1] );
		$line =  preg_replace("/^(!{1,4})[^!]/", "", $line);
		$html = '';
		while ( $prevSectionLevel >= $currLevel )
		{
			$html .= "</section>\n";
			$prevSectionLevel--;
		}
		$prevSectionLevel = $currLevel;
		$html .= $trfrm->SetHTMLMode('',0 );
		if ($currLevel > 1) 
			$html .= "<section>\n";
		$line = $html. '<title>'. $line . "</title>\n";
	}
	return  $line;
}
// ordered lists <orderelist> : #
function wtm_orderedlist($line, &$trfrm) {
	if (preg_match("/^([#*;]*\#)/", $line, $matches)) {
		$numtabs = strlen($matches[1]);
		$line = preg_replace("/^([#*]*\#)/", "", $line);
		$html = $trfrm->SetHTMLMode('orderedlist', $numtabs) . '<listitem><para>';
		$line = $html . $line . '</para></listitem>';
	}
	return $line;
}

function wtm_block_image($line, &$trfrm) {

	preg_match("/^(\[\s*)(.+?)(\s*\])/", $line, $match);
	// match the contents 
	preg_match("/([^|]+)(\|)?([^|]+)?/", $match[2], $matches);

	// unnamed link of the form "[http://blippy.com/] or [wiki page]"
	$URL = trim($matches[1]);
	if ( preg_match("/($InlineImages)$/i", $URL)) {
		$html = $trfrm->SetHTMLMode('mediaobject');
		$line =$html .   '<imageobject><imagedata fileref="'. $URL . '" /></imageobject>';
	}
	return $line;
}

// definition lists <DL>: ";text:text"
function wtm_list_dl($line, &$trfrm) {
	if (preg_match("/^([#*;]*;)(.*?):(.*$)/", $line, $matches)) {
		$numtabs = strlen($matches[1]);
		$line = $trfrm->SetHTMLMode('variablelist', $numtabs);
 if(trim($matches[2]))
			$line .= '<varlistentry><term>' . $matches[2] ."</term>\n";
 $line .= '<listitem><para>' . $matches[3] ."</para></listitem>\n</varlistentry>\n";
	}
	return $line;
}

// mode: preformatted text, i.e. <pre>
function wtm_preformatted($line, &$trfrm) {
	if (preg_match("/^\s+/", $line)) {
		$line = $trfrm->SetHTMLMode('programlisting') . $line;
	}
	return $line;
}

//gryu sub, sup
function wtm_sub_sup($line, &$transformer) {

	$line = preg_replace("|(\^\()(.*?)(\)\^)|", '<superscript>\2</superscript>', $line);
	$line = preg_replace("|(\v\()(.*?)(\)\v)|", '<subscript>\2</subscript>', $line);
	return $line;
}

//gryu+ blockquotes
function wtm_blockquotes($line, &$trfrm) {
	if (preg_match('/^!c!/', $line)) {
 		$line = preg_replace("/^!c!/", '', $line);
		$line = $trfrm->SetHTMLMode('blockquote') . $line;
	}
	return $line;
}		

// markup for tables
function wtm_table($line, &$trfrm)
{
	$row = '';
	while (preg_match('/^(\|+)(v*)([<>^]?)([^|]*)/', $line, $m))
	{
		$line = substr($line, strlen($m[0]));
		$td = array();
	
		if (strlen($m[1]) > 1)
 			$td['colspan'] = strlen($m[1]);
		if (strlen($m[2]) > 0)
 			$td['rowspan'] = strlen($m[2]) + 1;
	
		if ($m[3] == '^')
 			$td['align'] = 'center';
		else if ($m[3] == '>')
 			$td['align'] = 'right';
		else
 			$td['align'] = 'left';
	
		$row .= $trfrm->token(StartTag('td', $td) . "&nbsp;");
		$row .= trim($m[4]);
		$row .= $trfrm->token("&nbsp;</td>");
	}
	assert(empty($line));
	$row = $trfrm->token("<tr>") . $row . $trfrm->token("</tr>");

	return $trfrm->SetHTMLMode(array('table',
				 array(//'align' => 'left',
				  'cellpadding' => 1,
				  'cellspacing' => 1,
				  'border' => 1))) .
	$row;
}

// four or more dashes to <hr>
// Note this is of type WT_MODE_MARKUP becuase <hr>'s aren't
// allowed within <p>'s. (e.g. "<p><hr></p>" is not valid HTML.)
function wtm_hr($line, &$trfrm) {
	if (preg_match('/^-{4,}(.*)$/', $line, $m)) {
 $line = $trfrm->SetHTMLMode('', 0) . '<hr>';
 if ($m[1])
	 $line .= $trfrm->SetHTMLMode('p') . $m[1];
	}
	return $line;
}

// default mode: simple text paragraph
function wtm_para($line, &$trfrm) {
	$line = $trfrm->SetHTMLMode('para') . $line;
	return $line;
}

?>