<?php

define('WT_SIMPLE_MARKUP', 0);
define('WT_TOKENIZER', 1);
define('WT_MODE_MARKUP', 2);

define("ZERO_LEVEL", 0);
define("NESTED_LEVEL", 1);

$FieldSeparator = "\x81";

class WikiTransform
{
	/*
	function WikiTransform() -- init

	function register($type, $function, [$regexp])
	Registers transformer functions
	This should be done *before* calling do_transform

	$type:
		WT_MODE_MARKUP
		If one WT_MODE_MARKUP really sets the html mode, then
		all successive WT_MODE_MARKUP functions are skipped
		WT_TOKENIZER
		The transformer function is called once for each match
		of the $regexp in the line.  The matched values are tokenized
		to protect them from further transformation.

	$function: function name

		$regexp:  Required for WT_TOKENIZER functions.  Optional for others.
		If given, the transformer function will only be called if the
		line matches the $regexp.
	
	function SetHTMLMode($tag, $tagtype, $level)
		This is a helper function used to keep track of what HTML
	block-level element we are currently processing.
	Block-level elements are things like paragraphs "<p>",
	pre-formatted text "<pre>", and the various list elements:
	"<ul>", "<ol>" and "<dl>".  Note that some of these elements
	can be nested, while others can not.  (In particular, according to
	the HTML 4.01 specification,  a paragraph "<p>" element is not
	allowed to contain any other block-level elements.  Also <pre>,
	<li>,  <dt>, <dd>, <h1> ... have this same restriction.)

	SetHTMLMode generates whatever HTML is necessary to get us into
	the requested element type at the requested nesting level.

	$tag ... type of HTML element to open.
				If $tag is an array, $tag[0] gives the element type,
		 and $tag[1] should be a hash containing attribute-value
		 pairs for the element.

		 If $tag is the empty string, all open elements (down to the
		 level requested by $level) are closed.  Use
		 SetHTMLMode('',0) to close all open block-level elements.
						
	$level ... requested nesting level for current element.
		 The nesting level for top level block is one (which is
		 the default).

		 Nesting is arbitrary limited to 10 levels

	function do_transform($html, $content)
	contains main-loop and calls transformer functions

	$html ... HTML header (if needed, otherwise '')
	$content ... wiki markup as array of lines
	*/


	// public variables (only meaningful during do_transform)
	var $linenumber;	// current linenumber
	var $replacements;	// storage for tokenized strings of current line
	var $user_data;	// can be used by the transformer functions
								// to store miscellaneous data.
	
	// private variables
	var $content;	// wiki markup, array of lines
	var $mode_set;	// stores if a HTML mode for this line has been set
	var $trfrm_func;	// array of registered functions
	var $stack;		// stack for SetHTMLMode (keeping track of open tags)

	// init function
	function WikiTransform()
	{
		$this->trfrm_func = array();
		$this->stack = new Stack;
	}

	// register transformation functions
	function register($type, $function, $regexp = false)
	{
		$this->trfrm_func[] = array ($type, $function, $regexp);
	}
	
	// sets current mode like list, preformatted text, plain text, ...
	// takes care of closing (open) tags
	function SetHTMLMode($tag, $level = 1)
	{
		if (is_array($tag)) {
	 $args = $tag[1];
	 $tag = $tag[0];
		}
		else {
	 $args = array();
		}

		$this->mode_set = 1;	// in order to prevent other mode markup
				// to be executed
		$retvar = '';
	 
		if ($level > 10) {
	 // arbitrarily limit tag nesting
	 ExitWiki(gettext ("Lists nested too deep in SetHTMLOutputMode"));
		}
		
		if ($level <= $this->stack->cnt()) {
	 // $tag has fewer nestings (old: tabs) than stack,
	 // reduce stack to that tab count
	 while ($this->stack->cnt() > $level) {
		 $closetag = $this->stack->pop();
		 assert('$closetag != false');
		 $retvar .= "</$closetag>\n";
	 }

	 // if list type isn't the same,
	 // back up one more and push new tag
	 if ($tag && $tag != $this->stack->top()) {
		 $closetag = $this->stack->pop();
		 $retvar .= "</$closetag>" . StartTag($tag, $args) . "\n";
		 $this->stack->push($tag);
	 }
	
		} else {// $level > $this->stack->cnt()
	 // Test for and close top level elements which are not allowed to contain
	 // other block-level elements.
	 if ($this->stack->cnt() == 1 and
		  preg_match('/^(p|pre|h\d)$/i', $this->stack->top()))
	 {
		 $closetag = $this->stack->pop();
		 $retvar .= "</$closetag>";
	 }
			 
	 // we add the diff to the stack
	 // stack might be zero
	 if ($this->stack->cnt() < $level) {
		 while ($this->stack->cnt() < $level - 1) {
			 // This is a bit of a hack:
			 //
			 // We're not nested deep enough, and have to make up some kind of block
			 // element to nest within.
			 //
			 // Currently, this can only happen for nested list element
			 // (either <ul> <ol> or <dl>).  What we used to do here is
			 // to open extra lists of whatever type was requested.
			 // This would result in invalid HTML, since and list is
			 // not allowed to contain another list without first containing
			 // a list item.  ("<ul><ul><li>Item</ul></ul>" is invalid.)
			 //
			 // So now, when we need extra list elements, we use a <dl>, and
			 // open it with an empty <dd>.
			 $retvar .= "<dl><dd>";
			 $this->stack->push('dl');
		 }

		 $retvar .= StartTag($tag, $args) . "\n";
		 $this->stack->push($tag);
			}
		}
		
		return $this->token($retvar);
	}
	// end SetHTMLMode


	// work horse and main loop
	// this function does the transform from wiki markup to HTML
	function do_transform($html, $content)
	{
		global $FieldSeparator;
		global $prevSectionLevel;
		$this->content = $content;
		$this->replacements = array();
		$this->user_data = array();
		
		// Loop over all lines of the page and apply transformation rules
		$numlines = count($this->content);
//gryu+
		$isPre = false;
		$isVerbatim = false;
//+gryu
		for ($lnum = 0; $lnum < $numlines; $lnum++)
		{
	 
			$this->linenumber = $lnum;
			$line = $this->content[$lnum];

//gryu+ {{{  }}} preformatted
			if (preg_match('/^{{{/', $line)) {
				$isPre = true;
				$tagname = trim( substr( $line, 3) );
				if ( $tagname == '') $tagname = 'programlisting';
				$line = $this->SetHTMLMode($tagname);
				$html .= $line;
				continue;
			}

			if (preg_match('/^}}}/', $line)) {
				$isPre = false;
				$line = $this->SetHTMLMode('', 0);
				$html .= $line . "\n";				
				continue;
			}

			if (preg_match('/^<<</', $line)) {
				$isVerbatim = true;
				continue;
			}

			if (preg_match('/^>>>/', $line)) {
				$isVerbatim = false;
				continue;
			}
			if ($isPre) {
				$html .= htmlspecialchars($line) . "\n";
				continue;
			}
			if ($isVerbatim) {
				$html .= $line . "\n";
				continue;
			}
			
			// blank lines clear the current mode (to force new paragraph)
			if (!strlen($line) || $line == "\r") {
				$html .= $this->SetHTMLMode('', 0);
				continue;
	 		}

	 		$this->mode_set = 0;

	 		// main loop applying all registered functions
	 		// tokenizers, markup, html mode, ...
	 		// functions are executed in order of registering
			for (reset($this->trfrm_func); list($flags, $func, $regexp) = current($this->trfrm_func);
			next($this->trfrm_func)) {

		 		// if HTMLmode is already set then skip all following
				// WT_MODE_MARKUP functions
				if ($this->mode_set && ($flags & WT_MODE_MARKUP) != 0) 
					continue;

				if (!empty($regexp) && !preg_match("/$regexp/", $line))
			 		continue;

		 		// call registered function
		 		if (($flags & WT_TOKENIZER) != 0)
			 		$line = $this->tokenize($line, $regexp, $func);
		 		else
			 		$line = $func($line, $this);
	 		}

			$html .= $line . "\n";
		}
		// close all tags
		$html .= $this->SetHTMLMode('', 0);
		//  ǵ  ݱ. (ֻ Ҹ )
		while ( $prevSectionLevel >= 2 )
		{
			$html .= "</section>\n";
			$prevSectionLevel--;
		}
		return $this->untokenize($html);
	}
	// end do_transfrom()

	// Register a new token.
	function token($repl) {
		global $FieldSeparator;
		$tok = $FieldSeparator . sizeof($this->replacements) . $FieldSeparator;
		$this->replacements[] = $repl;
		return $tok;
	}
	
	// helper function which does actual tokenizing
	function tokenize($str, $pattern, $func) {
		// Find any strings in $str that match $pattern and
		// store them in $orig, replacing them with tokens
		// starting at number $ntokens - returns tokenized string
		$new = '';      
		while (preg_match("/^(.*?)($pattern)/", $str, $matches)) {
	 $str = substr($str, strlen($matches[0]));
	 $new .= $matches[1] . $this->token($func($matches[2], $this));
		}
		return $new . $str;
	}

	function untokenize($line) {
		global $FieldSeparator;
		
		$chunks = explode ($FieldSeparator, "$line ");
		$line = $chunks[0];
		for ($i = 1; $i < count($chunks); $i += 2)
		{
	 $tok = $chunks[$i];
	 $line .= $this->replacements[$tok] . $chunks[$i + 1];
		}
		return $line;
	}
}
// end class WikiTransform


// (c-file-style: "gnu")
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
?>
