/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.Block;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.RegionBody;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BalancingColumnBreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;
import org.apache.fop.layoutmgr.inline.ContentLayoutManager;
import org.apache.fop.traits.MinOptMax;

public class PageSequenceLayoutManager
extends AbstractLayoutManager {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$PageSequenceLayoutManager == null ? (class$org$apache$fop$layoutmgr$PageSequenceLayoutManager = PageSequenceLayoutManager.class$("org.apache.fop.layoutmgr.PageSequenceLayoutManager")) : class$org$apache$fop$layoutmgr$PageSequenceLayoutManager));
    private AreaTreeHandler areaTreeHandler;
    private PageSequence pageSeq;
    private PageProvider pageProvider;
    private Page curPage = null;
    private FlowLayoutManager childFLM = null;
    private int startPageNum = 0;
    private int currentPageNum = 0;
    private Block separatorArea = null;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$PageSequenceLayoutManager;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$PageSequenceLayoutManager$PageProvider;

    public PageSequenceLayoutManager(AreaTreeHandler ath, PageSequence pseq) {
        super(pseq);
        this.areaTreeHandler = ath;
        this.pageSeq = pseq;
        this.pageProvider = new PageProvider(this.pageSeq);
    }

    public LayoutManagerMaker getLayoutManagerMaker() {
        return this.areaTreeHandler.getLayoutManagerMaker();
    }

    public PageProvider getPageProvider() {
        return this.pageProvider;
    }

    public void activateLayout() {
        this.startPageNum = this.pageSeq.getStartingPageNumber();
        this.currentPageNum = this.startPageNum - 1;
        LineArea title = null;
        if (this.pageSeq.getTitleFO() != null) {
            try {
                ContentLayoutManager clm = this.getLayoutManagerMaker().makeContentLayoutManager(this, this.pageSeq.getTitleFO());
                title = (LineArea)clm.getParentArea(null);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        this.areaTreeHandler.getAreaTreeModel().startPageSequence(title);
        log.debug((Object)"Starting layout");
        this.curPage = this.makeNewPage(false, false);
        Flow mainFlow = this.pageSeq.getMainFlow();
        this.childFLM = this.getLayoutManagerMaker().makeFlowLayoutManager(this, mainFlow);
        PageBreaker breaker = new PageBreaker(this);
        int flowBPD = this.getCurrentPV().getBodyRegion().getRemainingBPD();
        breaker.doLayout(flowBPD);
        this.finishPage();
    }

    public void finishPageSequence() {
        if (!this.pageSeq.getId().equals("")) {
            this.areaTreeHandler.signalIDProcessed(this.pageSeq.getId());
        }
        this.pageSeq.getRoot().notifyPageSequenceFinished(this.currentPageNum, this.currentPageNum - this.startPageNum + 1);
        this.areaTreeHandler.notifyPageSequenceFinished(this.pageSeq, this.currentPageNum - this.startPageNum + 1);
        this.pageSeq.releasePageSequence();
        log.debug((Object)"Ending layout");
    }

    public Page getCurrentPage() {
        return this.curPage;
    }

    public PageSequenceLayoutManager getPSLM() {
        return this;
    }

    public PageViewport getFirstPVWithID(String idref) {
        List list = this.areaTreeHandler.getPageViewportsContainingID(idref);
        if (list != null && list.size() > 0) {
            return (PageViewport)list.get(0);
        }
        return null;
    }

    public PageViewport getLastPVWithID(String idref) {
        List list = this.areaTreeHandler.getPageViewportsContainingID(idref);
        if (list != null && list.size() > 0) {
            return (PageViewport)list.get(list.size() - 1);
        }
        return null;
    }

    public void addIDToPage(String id) {
        if (id != null && id.length() > 0) {
            this.areaTreeHandler.associateIDWithPageViewport(id, this.curPage.getPageViewport());
        }
    }

    public boolean associateLayoutManagerID(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("associateLayoutManagerID(" + id + ")"));
        }
        if (!this.areaTreeHandler.alreadyResolvedID(id)) {
            this.areaTreeHandler.signalPendingID(id);
            return false;
        }
        return true;
    }

    public void notifyEndOfLayout(String id) {
        this.areaTreeHandler.signalIDProcessed(id);
    }

    public void addUnresolvedArea(String id, Resolvable res) {
        this.curPage.getPageViewport().addUnresolvedIDRef(id, res);
        this.areaTreeHandler.addUnresolvedIDRef(id, this.curPage.getPageViewport());
    }

    public RetrieveMarker resolveRetrieveMarker(RetrieveMarker rm) {
        AreaTreeModel areaTreeModel = this.areaTreeHandler.getAreaTreeModel();
        String name = rm.getRetrieveClassName();
        int pos = rm.getRetrievePosition();
        int boundary = rm.getRetrieveBoundary();
        Marker mark = (Marker)this.getCurrentPV().getMarker(name, pos);
        if (mark == null && boundary != 104) {
            PageViewport pv;
            boolean doc = boundary == 34;
            int seq = areaTreeModel.getPageSequenceCount();
            int page = areaTreeModel.getPageCount(seq) - 1;
            while (page < 0 && doc && seq > 1) {
                page = areaTreeModel.getPageCount(--seq) - 1;
            }
            while (page >= 0 && (mark = (Marker)(pv = areaTreeModel.getPage(seq, page)).getMarker(name, 74)) == null) {
                if (--page >= 0 || !doc || seq <= 1) continue;
                page = areaTreeModel.getPageCount(--seq) - 1;
            }
        }
        if (mark == null) {
            log.debug((Object)("found no marker with name: " + name));
            return null;
        }
        rm.bindMarker(mark);
        return rm;
    }

    private Page makeNewPage(boolean bIsBlank, boolean bIsLast) {
        if (this.curPage != null) {
            this.finishPage();
        }
        ++this.currentPageNum;
        this.curPage = this.pageProvider.getPage(bIsBlank, this.currentPageNum, 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.curPage.getPageViewport().getPageNumberString() + (bIsBlank ? "*" : "") + "]"));
        }
        this.addIDToPage(this.pageSeq.getId());
        return this.curPage;
    }

    private void layoutSideRegion(int regionID) {
        SideRegion reg = (SideRegion)this.curPage.getSimplePageMaster().getRegion(regionID);
        if (reg == null) {
            return;
        }
        StaticContent sc = this.pageSeq.getStaticContent(reg.getRegionName());
        if (sc == null) {
            return;
        }
        StaticContentLayoutManager lm = this.getLayoutManagerMaker().makeStaticContentLayoutManager(this, sc, reg);
        lm.doLayout();
    }

    private void finishPage() {
        this.curPage.getPageViewport().dumpMarkers();
        this.layoutSideRegion(35);
        this.layoutSideRegion(34);
        this.layoutSideRegion(38);
        this.layoutSideRegion(37);
        this.areaTreeHandler.tryIDResolution(this.curPage.getPageViewport());
        this.areaTreeHandler.getAreaTreeModel().addPage(this.curPage.getPageViewport());
        if (log.isDebugEnabled()) {
            log.debug((Object)("page finished: " + this.curPage.getPageViewport().getPageNumberString() + ", current num: " + this.currentPageNum));
        }
        this.curPage = null;
    }

    private void handleBreakTrait(int breakVal) {
        if (breakVal == 5) {
            this.curPage.getPageViewport().createSpan(true);
            return;
        }
        if (breakVal == 95) {
            this.curPage.getPageViewport().createSpan(false);
            return;
        }
        if (breakVal == 28 || breakVal <= 0) {
            PageViewport pv = this.curPage.getPageViewport();
            boolean forceNewPageWithSpan = false;
            RegionBody rb = (RegionBody)this.curPage.getSimplePageMaster().getRegion(36);
            if (breakVal < 0 && rb.getColumnCount() > 1 && pv.getCurrentSpan().getColumnCount() == 1) {
                forceNewPageWithSpan = true;
            }
            if (forceNewPageWithSpan) {
                this.curPage = this.makeNewPage(false, false);
                this.curPage.getPageViewport().createSpan(true);
            } else if (pv.getCurrentSpan().hasMoreFlows()) {
                pv.getCurrentSpan().moveToNextFlow();
            } else {
                this.curPage = this.makeNewPage(false, false);
            }
            return;
        }
        log.debug((Object)("handling break-before after page " + this.currentPageNum + " breakVal=" + breakVal));
        if (this.needBlankPageBeforeNew(breakVal)) {
            this.curPage = this.makeNewPage(true, false);
        }
        if (this.needNewPage(breakVal)) {
            this.curPage = this.makeNewPage(false, false);
        }
    }

    private boolean needBlankPageBeforeNew(int breakVal) {
        if (breakVal == 104 || this.curPage.getPageViewport().getPage().isEmpty()) {
            return false;
        }
        if (this.currentPageNum % 2 == 0) {
            return breakVal == 44;
        }
        return breakVal == 100;
    }

    private boolean needNewPage(int breakVal) {
        if (this.curPage.getPageViewport().getPage().isEmpty()) {
            if (breakVal == 104) {
                return false;
            }
            if (this.currentPageNum % 2 == 0) {
                return breakVal == 100;
            }
            return breakVal == 44;
        }
        return true;
    }

    public void doForcePageCount(Numeric nextPageSeqInitialPageNumber) {
        int forcePageCount = this.pageSeq.getForcePageCount();
        if (nextPageSeqInitialPageNumber != null && forcePageCount == 9) {
            if (nextPageSeqInitialPageNumber.getEnum() != 0) {
                int nextPageSeqPageNumberType = nextPageSeqInitialPageNumber.getEnum();
                forcePageCount = nextPageSeqPageNumberType == 11 ? 40 : (nextPageSeqPageNumberType == 10 ? 41 : 88);
            } else {
                int nextPageSeqPageStart = nextPageSeqInitialPageNumber.getValue();
                nextPageSeqPageStart = nextPageSeqPageStart > 0 ? nextPageSeqPageStart : 1;
                forcePageCount = nextPageSeqPageStart % 2 == 0 ? 41 : 40;
            }
        }
        if (forcePageCount == 43) {
            if ((this.currentPageNum - this.startPageNum + 1) % 2 != 0) {
                this.curPage = this.makeNewPage(true, false);
            }
        } else if (forcePageCount == 99) {
            if ((this.currentPageNum - this.startPageNum + 1) % 2 == 0) {
                this.curPage = this.makeNewPage(true, false);
            }
        } else if (forcePageCount == 40) {
            if (this.currentPageNum % 2 != 0) {
                this.curPage = this.makeNewPage(true, false);
            }
        } else if (forcePageCount == 41) {
            if (this.currentPageNum % 2 == 0) {
                this.curPage = this.makeNewPage(true, false);
            }
        } else if (forcePageCount == 88) {
            // empty if block
        }
        if (this.curPage != null) {
            this.finishPage();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class PageProvider {
        private Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$PageSequenceLayoutManager$PageProvider == null ? (class$org$apache$fop$layoutmgr$PageSequenceLayoutManager$PageProvider = PageSequenceLayoutManager.class$("org.apache.fop.layoutmgr.PageSequenceLayoutManager$PageProvider")) : class$org$apache$fop$layoutmgr$PageSequenceLayoutManager$PageProvider));
        public static final int RELTO_PAGE_SEQUENCE = 0;
        public static final int RELTO_CURRENT_ELEMENT_LIST = 1;
        private int startPageOfPageSequence;
        private int startPageOfCurrentElementList;
        private int startColumnOfCurrentElementList;
        private List cachedPages = new ArrayList();
        private int lastPageIndex = -1;
        private int indexOfCachedLastPage = -1;
        private int lastRequestedIndex = -1;
        private int lastReportedBPD = -1;

        public PageProvider(PageSequence ps) {
            this.startPageOfPageSequence = ps.getStartingPageNumber();
        }

        public void setStartOfNextElementList(int startPage, int startColumn) {
            this.log.debug((Object)("start of the next element list is: page=" + startPage + " col=" + startColumn));
            this.startPageOfCurrentElementList = startPage - this.startPageOfPageSequence + 1;
            this.startColumnOfCurrentElementList = startColumn;
            this.lastRequestedIndex = -1;
            this.lastReportedBPD = -1;
        }

        public void setLastPageIndex(int index) {
            this.lastPageIndex = index;
        }

        public int getAvailableBPD(int index) {
            if (this.lastRequestedIndex == index) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("getAvailableBPD(" + index + ") -> (cached) " + this.lastReportedBPD));
                }
                return this.lastReportedBPD;
            }
            int pageIndex = 0;
            int colIndex = this.startColumnOfCurrentElementList;
            Page page = this.getPage(false, pageIndex, 1);
            for (int c = index; c > 0; --c) {
                if (++colIndex < page.getPageViewport().getCurrentSpan().getColumnCount()) continue;
                colIndex = 0;
                page = this.getPage(false, ++pageIndex, 1);
            }
            this.lastRequestedIndex = index;
            this.lastReportedBPD = page.getPageViewport().getBodyRegion().getRemainingBPD();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("getAvailableBPD(" + index + ") -> " + this.lastReportedBPD));
            }
            return this.lastReportedBPD;
        }

        public int getStartingPartIndexForLastPage(int partCount) {
            int result = 0;
            int pageIndex = 0;
            int colIndex = this.startColumnOfCurrentElementList;
            Page page = this.getPage(false, pageIndex, 1);
            for (int idx = 0; idx < partCount; ++idx) {
                if (colIndex >= page.getPageViewport().getCurrentSpan().getColumnCount()) {
                    colIndex = 0;
                    page = this.getPage(false, ++pageIndex, 1);
                    result = idx;
                }
                ++colIndex;
            }
            return result;
        }

        public Page getPage(boolean isBlank, int index, int relativeTo) {
            if (relativeTo == 0) {
                return this.getPage(isBlank, index);
            }
            if (relativeTo == 1) {
                int effIndex = this.startPageOfCurrentElementList + index;
                return this.getPage(isBlank, effIndex += this.startPageOfPageSequence - 1);
            }
            throw new IllegalArgumentException("Illegal value for relativeTo: " + relativeTo);
        }

        private Page getPage(boolean isBlank, int index) {
            boolean isLastPage;
            boolean bl = isLastPage = this.lastPageIndex >= 0 && index == this.lastPageIndex;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("getPage(" + index + " " + (isBlank ? "blank" : "non-blank") + (isLastPage ? " <LAST>" : "") + ")"));
            }
            int intIndex = index - this.startPageOfPageSequence;
            if (this.log.isTraceEnabled()) {
                if (isBlank) {
                    this.log.trace((Object)("blank page requested: " + index));
                }
                if (isLastPage) {
                    this.log.trace((Object)("last page requested: " + index));
                }
            }
            while (intIndex >= this.cachedPages.size()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Caching " + index));
                }
                this.cacheNextPage(index, isBlank, isLastPage);
            }
            Page page = (Page)this.cachedPages.get(intIndex);
            boolean replace = false;
            if (page.getPageViewport().isBlank() != isBlank) {
                this.log.debug((Object)"blank condition doesn't match. Replacing PageViewport.");
                replace = true;
            }
            if (isLastPage && this.indexOfCachedLastPage != intIndex || !isLastPage && this.indexOfCachedLastPage >= 0) {
                this.log.debug((Object)"last page condition doesn't match. Replacing PageViewport.");
                replace = true;
                int n = this.indexOfCachedLastPage = isLastPage ? intIndex : -1;
            }
            if (replace) {
                this.disardCacheStartingWith(intIndex);
                page = this.cacheNextPage(index, isBlank, isLastPage);
            }
            return page;
        }

        private void disardCacheStartingWith(int index) {
            while (index < this.cachedPages.size()) {
                this.cachedPages.remove(this.cachedPages.size() - 1);
                if (PageSequenceLayoutManager.this.pageSeq.goToPreviousSimplePageMaster()) continue;
                this.log.warn((Object)"goToPreviousSimplePageMaster() on the first page called!");
            }
        }

        private Page cacheNextPage(int index, boolean isBlank, boolean isLastPage) {
            try {
                String pageNumberString = PageSequenceLayoutManager.this.pageSeq.makeFormattedPageNumber(index);
                SimplePageMaster spm = PageSequenceLayoutManager.this.pageSeq.getNextSimplePageMaster(index, this.startPageOfPageSequence == index, isLastPage, isBlank);
                Region body = spm.getRegion(36);
                if (!PageSequenceLayoutManager.this.pageSeq.getMainFlow().getFlowName().equals(body.getRegionName())) {
                    throw new FOPException("Flow '" + PageSequenceLayoutManager.this.pageSeq.getMainFlow().getFlowName() + "' does not map to the region-body in page-master '" + spm.getMasterName() + "'.  FOP presently " + "does not support this.");
                }
                Page page = new Page(spm, index, pageNumberString, isBlank);
                page.getPageViewport().setKey(PageSequenceLayoutManager.this.areaTreeHandler.generatePageViewportKey());
                page.getPageViewport().setForeignAttributes(spm.getForeignAttributes());
                this.cachedPages.add(page);
                return page;
            }
            catch (FOPException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
    }

    private class PageBreaker
    extends AbstractBreaker {
        private PageSequenceLayoutManager pslm;
        private boolean firstPart = true;
        private boolean pageBreakHandled;
        private boolean needColumnBalancing;
        private StaticContentLayoutManager footnoteSeparatorLM = null;

        public PageBreaker(PageSequenceLayoutManager pslm) {
            this.pslm = pslm;
        }

        protected void updateLayoutContext(LayoutContext context) {
            int flowIPD = PageSequenceLayoutManager.this.getCurrentPV().getCurrentSpan().getColumnWidth();
            context.setRefIPD(flowIPD);
        }

        protected LayoutManager getTopLevelLM() {
            return this.pslm;
        }

        protected PageProvider getPageProvider() {
            return PageSequenceLayoutManager.this.pageProvider;
        }

        protected PageBreakingAlgorithm.PageBreakingLayoutListener getLayoutListener() {
            return new PageBreakingAlgorithm.PageBreakingLayoutListener(){

                public void notifyOverflow(int part, FObj obj) {
                    Page p = PageSequenceLayoutManager.this.pageProvider.getPage(false, part, 1);
                    RegionBody body = (RegionBody)p.getSimplePageMaster().getRegion(36);
                    String err = FONode.decorateWithContextInfo("Content of the region-body on page " + p.getPageViewport().getPageNumberString() + " overflows the available area in block-progression dimension.", obj);
                    if (body.getOverflow() == 42) {
                        throw new RuntimeException(err);
                    }
                    log.warn((Object)err);
                }
            };
        }

        protected int handleSpanChange(LayoutContext childLC, int nextSequenceStartsOn) {
            this.needColumnBalancing = false;
            if (childLC.getNextSpan() != 0) {
                nextSequenceStartsOn = childLC.getNextSpan();
                boolean bl = this.needColumnBalancing = childLC.getNextSpan() == 5;
            }
            if (this.needColumnBalancing) {
                AbstractBreaker.log.debug((Object)"Column balancing necessary for the next element list!!!");
            }
            return nextSequenceStartsOn;
        }

        protected int getNextBlockList(LayoutContext childLC, int nextSequenceStartsOn, List blockLists) {
            if (!this.firstPart) {
                PageSequenceLayoutManager.this.handleBreakTrait(nextSequenceStartsOn);
            }
            this.firstPart = false;
            this.pageBreakHandled = true;
            PageSequenceLayoutManager.this.pageProvider.setStartOfNextElementList(PageSequenceLayoutManager.this.currentPageNum, PageSequenceLayoutManager.this.getCurrentPV().getCurrentSpan().getCurrentFlowIndex());
            return super.getNextBlockList(childLC, nextSequenceStartsOn, blockLists);
        }

        protected LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
            StaticContent footnoteSeparator;
            AbstractList contentList = null;
            while (!PageSequenceLayoutManager.this.childFLM.isFinished() && contentList == null) {
                contentList = PageSequenceLayoutManager.this.childFLM.getNextKnuthElements(context, alignment);
            }
            boolean bFootnotesPresent = false;
            if (contentList != null) {
                ListIterator contentListIterator = contentList.listIterator();
                while (contentListIterator.hasNext()) {
                    ListElement element = (ListElement)contentListIterator.next();
                    if (!(element instanceof KnuthBlockBox) || !((KnuthBlockBox)element).hasAnchors()) continue;
                    bFootnotesPresent = true;
                    LayoutContext footnoteContext = new LayoutContext(context);
                    footnoteContext.setStackLimit(context.getStackLimit());
                    footnoteContext.setRefIPD(PageSequenceLayoutManager.this.getCurrentPV().getRegionReference(36).getIPD());
                    LinkedList footnoteBodyLMs = ((KnuthBlockBox)element).getFootnoteBodyLMs();
                    ListIterator footnoteBodyIterator = footnoteBodyLMs.listIterator();
                    while (footnoteBodyIterator.hasNext()) {
                        FootnoteBodyLayoutManager fblm = (FootnoteBodyLayoutManager)footnoteBodyIterator.next();
                        fblm.setParent(PageSequenceLayoutManager.this.childFLM);
                        fblm.initialize();
                        ((KnuthBlockBox)element).addElementList(fblm.getNextKnuthElements(footnoteContext, alignment));
                    }
                }
            }
            if (bFootnotesPresent && (footnoteSeparator = PageSequenceLayoutManager.this.pageSeq.getStaticContent("xsl-footnote-separator")) != null) {
                PageSequenceLayoutManager.this.separatorArea = new Block();
                PageSequenceLayoutManager.this.separatorArea.setIPD(this.pslm.getCurrentPV().getRegionReference(36).getIPD());
                this.footnoteSeparatorLM = PageSequenceLayoutManager.this.getLayoutManagerMaker().makeStaticContentLayoutManager(this.pslm, footnoteSeparator, PageSequenceLayoutManager.this.separatorArea);
                this.footnoteSeparatorLM.doLayout();
                this.footnoteSeparatorLength = new MinOptMax(PageSequenceLayoutManager.this.separatorArea.getBPD());
            }
            return contentList;
        }

        protected int getCurrentDisplayAlign() {
            return PageSequenceLayoutManager.this.curPage.getSimplePageMaster().getRegion(36).getDisplayAlign();
        }

        protected boolean hasMoreContent() {
            return !PageSequenceLayoutManager.this.childFLM.isFinished();
        }

        protected void addAreas(PositionIterator posIter, LayoutContext context) {
            if (this.footnoteSeparatorLM != null) {
                StaticContent footnoteSeparator = PageSequenceLayoutManager.this.pageSeq.getStaticContent("xsl-footnote-separator");
                PageSequenceLayoutManager.this.separatorArea = new Block();
                PageSequenceLayoutManager.this.separatorArea.setIPD(PageSequenceLayoutManager.this.getCurrentPV().getRegionReference(36).getIPD());
                this.footnoteSeparatorLM = PageSequenceLayoutManager.this.getLayoutManagerMaker().makeStaticContentLayoutManager(this.pslm, footnoteSeparator, PageSequenceLayoutManager.this.separatorArea);
                this.footnoteSeparatorLM.doLayout();
            }
            PageSequenceLayoutManager.this.childFLM.addAreas(posIter, context);
        }

        protected void doPhase3(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
            if (this.needColumnBalancing) {
                this.doPhase3WithColumnBalancing(alg, partCount, originalList, effectiveList);
            } else if (!this.hasMoreContent() && PageSequenceLayoutManager.this.pageSeq.hasPagePositionLast()) {
                this.doPhase3WithLastPage(alg, partCount, originalList, effectiveList);
            } else {
                this.addAreas(alg, partCount, originalList, effectiveList);
            }
        }

        private void doPhase3WithLastPage(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
            boolean replaceLastPage;
            int newStartPos;
            int restartPoint = PageSequenceLayoutManager.this.pageProvider.getStartingPartIndexForLastPage(partCount);
            if (restartPoint > 0) {
                this.addAreas(alg, restartPoint, originalList, effectiveList);
                AbstractBreaker.PageBreakPosition pbp = (AbstractBreaker.PageBreakPosition)alg.getPageBreaks().get(restartPoint - 1);
                newStartPos = pbp.getLeafPos();
                if (newStartPos > 0) {
                    PageSequenceLayoutManager.this.handleBreakTrait(104);
                }
            } else {
                newStartPos = 0;
            }
            AbstractBreaker.log.debug((Object)"Last page handling now!!!");
            AbstractBreaker.log.debug((Object)"===================================================");
            AbstractBreaker.log.debug((Object)("Restarting at " + restartPoint + ", new start position: " + newStartPos));
            this.pageBreakHandled = true;
            PageSequenceLayoutManager.this.pageProvider.setStartOfNextElementList(PageSequenceLayoutManager.this.currentPageNum, PageSequenceLayoutManager.this.getCurrentPV().getCurrentSpan().getCurrentFlowIndex());
            PageSequenceLayoutManager.this.pageProvider.setLastPageIndex(PageSequenceLayoutManager.this.currentPageNum);
            PageBreakingAlgorithm algRestart = new PageBreakingAlgorithm(this.getTopLevelLM(), this.getPageProvider(), this.getLayoutListener(), alg.getAlignment(), alg.getAlignmentLast(), this.footnoteSeparatorLength, this.isPartOverflowRecoveryActivated(), false, false);
            int iOptPageCount = algRestart.findBreakingPoints(effectiveList, newStartPos, 1.0, true, 0);
            AbstractBreaker.log.debug((Object)("restart: iOptPageCount= " + iOptPageCount + " pageBreaks.size()= " + algRestart.getPageBreaks().size()));
            boolean bl = replaceLastPage = iOptPageCount <= PageSequenceLayoutManager.this.getCurrentPV().getBodyRegion().getColumnCount();
            if (replaceLastPage) {
                this.pslm.curPage = PageSequenceLayoutManager.this.pageProvider.getPage(false, PageSequenceLayoutManager.this.currentPageNum);
                effectiveList.ignoreAtStart = newStartPos;
                this.addAreas(algRestart, iOptPageCount, originalList, effectiveList);
            } else {
                effectiveList.ignoreAtStart = newStartPos;
                this.addAreas(alg, restartPoint, partCount - restartPoint, originalList, effectiveList);
                PageSequenceLayoutManager.this.pageProvider.setLastPageIndex(PageSequenceLayoutManager.this.currentPageNum + 1);
                this.pslm.curPage = PageSequenceLayoutManager.this.makeNewPage(true, true);
            }
            AbstractBreaker.log.debug((Object)"===================================================");
        }

        private void doPhase3WithColumnBalancing(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
            int newStartPos;
            AbstractBreaker.log.debug((Object)"Column balancing now!!!");
            AbstractBreaker.log.debug((Object)"===================================================");
            int restartPoint = PageSequenceLayoutManager.this.pageProvider.getStartingPartIndexForLastPage(partCount);
            if (restartPoint > 0) {
                this.addAreas(alg, restartPoint, originalList, effectiveList);
                AbstractBreaker.PageBreakPosition pbp = (AbstractBreaker.PageBreakPosition)alg.getPageBreaks().get(restartPoint - 1);
                newStartPos = pbp.getLeafPos();
                if (newStartPos > 0) {
                    PageSequenceLayoutManager.this.handleBreakTrait(104);
                }
            } else {
                newStartPos = 0;
            }
            AbstractBreaker.log.debug((Object)("Restarting at " + restartPoint + ", new start position: " + newStartPos));
            this.pageBreakHandled = true;
            PageSequenceLayoutManager.this.pageProvider.setStartOfNextElementList(PageSequenceLayoutManager.this.currentPageNum, PageSequenceLayoutManager.this.getCurrentPV().getCurrentSpan().getCurrentFlowIndex());
            BalancingColumnBreakingAlgorithm algRestart = new BalancingColumnBreakingAlgorithm(this.getTopLevelLM(), this.getPageProvider(), this.getLayoutListener(), this.alignment, 135, this.footnoteSeparatorLength, this.isPartOverflowRecoveryActivated(), PageSequenceLayoutManager.this.getCurrentPV().getBodyRegion().getColumnCount());
            int iOptPageCount = algRestart.findBreakingPoints(effectiveList, newStartPos, 1.0, true, 0);
            AbstractBreaker.log.debug((Object)("restart: iOptPageCount= " + iOptPageCount + " pageBreaks.size()= " + algRestart.getPageBreaks().size()));
            if (iOptPageCount > PageSequenceLayoutManager.this.getCurrentPV().getBodyRegion().getColumnCount()) {
                AbstractBreaker.log.warn((Object)"Breaking algorithm produced more columns than are available.");
            }
            effectiveList.ignoreAtStart = newStartPos;
            this.addAreas(algRestart, iOptPageCount, originalList, effectiveList);
            AbstractBreaker.log.debug((Object)"===================================================");
        }

        protected void startPart(AbstractBreaker.BlockSequence list, int breakClass) {
            AbstractBreaker.log.debug((Object)("startPart() breakClass=" + breakClass));
            if (PageSequenceLayoutManager.this.curPage == null) {
                throw new IllegalStateException("curPage must not be null");
            }
            if (!this.pageBreakHandled) {
                if (!this.firstPart) {
                    PageSequenceLayoutManager.this.handleBreakTrait(breakClass);
                }
                PageSequenceLayoutManager.this.pageProvider.setStartOfNextElementList(PageSequenceLayoutManager.this.currentPageNum, PageSequenceLayoutManager.this.getCurrentPV().getCurrentSpan().getCurrentFlowIndex());
            }
            this.pageBreakHandled = false;
            this.firstPart = false;
        }

        protected void handleEmptyContent() {
            PageSequenceLayoutManager.this.getCurrentPV().getPage().fakeNonEmpty();
        }

        protected void finishPart(PageBreakingAlgorithm alg, AbstractBreaker.PageBreakPosition pbp) {
            if (pbp.footnoteFirstListIndex < pbp.footnoteLastListIndex || pbp.footnoteFirstElementIndex <= pbp.footnoteLastElementIndex) {
                for (int i = pbp.footnoteFirstListIndex; i <= pbp.footnoteLastListIndex; ++i) {
                    LinkedList elementList = alg.getFootnoteList(i);
                    int firstIndex = i == pbp.footnoteFirstListIndex ? pbp.footnoteFirstElementIndex : 0;
                    int lastIndex = i == pbp.footnoteLastListIndex ? pbp.footnoteLastElementIndex : elementList.size() - 1;
                    SpaceResolver.performConditionalsNotification(elementList, firstIndex, lastIndex, -1);
                    LayoutContext childLC = new LayoutContext(0);
                    AreaAdditionUtil.addAreas(null, new KnuthPossPosIter(elementList, firstIndex, lastIndex + 1), childLC);
                }
                Footnote parentArea = PageSequenceLayoutManager.this.getCurrentPV().getBodyRegion().getFootnote();
                int topOffset = PageSequenceLayoutManager.this.getCurrentPV().getBodyRegion().getBPD() - parentArea.getBPD();
                if (PageSequenceLayoutManager.this.separatorArea != null) {
                    topOffset -= PageSequenceLayoutManager.this.separatorArea.getBPD();
                }
                parentArea.setTop(topOffset);
                parentArea.setSeparator(PageSequenceLayoutManager.this.separatorArea);
            }
            PageSequenceLayoutManager.this.getCurrentPV().getCurrentSpan().notifyFlowsFinished();
        }

        protected LayoutManager getCurrentChildLM() {
            return PageSequenceLayoutManager.this.childFLM;
        }

        protected void observeElementList(List elementList) {
            ElementListObserver.observe(elementList, "breaker", ((PageSequence)this.pslm.getFObj()).getId());
        }
    }
}

