/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMNodeList
implements NodeList {
    private SequenceExtent sequence;

    public DOMNodeList(SequenceExtent sequenceExtent) {
        this.sequence = sequenceExtent;
    }

    public static DOMNodeList checkAndMake(SequenceExtent sequenceExtent) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = sequenceExtent.iterate(null);
        Node[] nodeArray = new Node[sequenceExtent.getLength()];
        int n = 0;
        while ((item = sequenceIterator.next()) != null) {
            Object object = item;
            while (object instanceof VirtualNode) {
                object = ((VirtualNode)object).getUnderlyingNode();
            }
            if (!(object instanceof Node)) {
                throw new DynamicError("Supplied sequence contains an item that is not a DOM Node");
            }
            nodeArray[n++] = (Node)object;
        }
        return new DOMNodeList(sequenceExtent);
    }

    public int getLength() {
        return this.sequence.getLength();
    }

    public Node item(int n) {
        return (Node)((Object)this.sequence.itemAt(n));
    }
}

