/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class LetExpression
extends Assignation {
    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.declaration == null) {
            return this;
        }
        this.sequence = this.sequence.analyze(staticContext, itemType);
        RoleLocator roleLocator = new RoleLocator(3, this.getVariableName(staticContext.getNamePool()), 0);
        this.sequence = TypeChecker.staticTypeCheck(this.sequence, this.declaration.getRequiredType(), false, roleLocator, staticContext);
        ItemType itemType2 = this.sequence.getItemType();
        this.declaration.refineTypeInformation(itemType2, this.sequence.getCardinality(), this.sequence instanceof Value ? (Value)this.sequence : null, this.sequence.getSpecialProperties());
        this.declaration = null;
        this.action = this.action.analyze(staticContext, itemType);
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Value value = this.eval(xPathContext);
        xPathContext.setLocalVariable(this.slotNumber, value);
        return this.action.iterate(xPathContext);
    }

    protected Value eval(XPathContext xPathContext) throws XPathException {
        return ExpressionTool.lazyEvaluate(this.sequence, xPathContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Value value = this.eval(xPathContext);
        if (value == null) {
            System.err.println("Invalid null value from lazyEvaluate() in LetExpression");
            throw new NullPointerException("Please report this as a Saxon bug");
        }
        xPathContext.setLocalVariable(this.slotNumber, value);
        return this.action.evaluateItem(xPathContext);
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Value value = this.eval(xPathContext);
        xPathContext.setLocalVariable(this.slotNumber, value);
        this.action.process(xPathContext);
    }

    public ItemType getItemType() {
        return this.action.getItemType();
    }

    public int computeCardinality() {
        return this.action.getCardinality();
    }

    public int computeSpecialProperties() {
        return this.action.getSpecialProperties();
    }

    public boolean markTailFunctionCalls() {
        return ExpressionTool.markTailFunctionCalls(this.action);
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.sequence = this.sequence.promote(promotionOffer);
        if (promotionOffer.action == 12 || promotionOffer.action == 13) {
            this.action = this.action.promote(promotionOffer);
        }
        if (this.sequence instanceof VariableReference) {
            PromotionOffer promotionOffer2 = new PromotionOffer();
            promotionOffer2.action = 12;
            promotionOffer2.binding = this;
            promotionOffer2.containingExpression = this.sequence;
            this.action = this.action.promote(promotionOffer2);
            return this.action;
        }
        return this;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "let $" + this.getVariableName(namePool) + " :=");
        this.sequence.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n) + "return");
        this.action.display(n + 1, namePool, printStream);
    }
}

