/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xpath.XPathException;

public class CallTemplate
extends Instruction {
    private Template template = null;
    private WithParam[] actualParams = null;
    private WithParam[] tunnelParams = null;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private NamespaceResolver nsContext;

    public CallTemplate(Template template, WithParam[] withParamArray, WithParam[] withParamArray2, boolean bl, Expression expression, NamespaceResolver namespaceResolver) {
        this.template = template;
        this.actualParams = withParamArray;
        this.tunnelParams = withParamArray2;
        this.useTailRecursion = bl;
        this.calledTemplateExpression = expression;
        this.nsContext = namespaceResolver;
    }

    public int getInstructionNameCode() {
        return 133;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = (InstructionDetails)super.getInstructionInfo();
        if (this.template != null) {
            instructionDetails.setProperty("template", this.template);
        }
        return instructionDetails;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        WithParam.simplify(this.actualParams, staticContext);
        WithParam.simplify(this.tunnelParams, staticContext);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = this.calledTemplateExpression.simplify(staticContext);
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        WithParam.analyze(this.actualParams, staticContext, itemType);
        WithParam.analyze(this.tunnelParams, staticContext, itemType);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = this.calledTemplateExpression.analyze(staticContext, itemType);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (this.calledTemplateExpression != null) {
            arrayList.add(this.calledTemplateExpression);
        }
        WithParam.getXPathExpressions(this.actualParams, arrayList);
        WithParam.getXPathExpressions(this.tunnelParams, arrayList);
        return arrayList.iterator();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = this.calledTemplateExpression.promote(promotionOffer);
        }
        WithParam.promoteParams(this.actualParams, promotionOffer);
        WithParam.promoteParams(this.tunnelParams, promotionOffer);
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        Template template = this.getTargetTemplate(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.openStackFrame(template.getStackFrameMap());
        xPathContextMajor.setLocalParameters(Instruction.assembleParams(xPathContext, this.actualParams));
        xPathContextMajor.setTunnelParameters(Instruction.assembleTunnelParams(xPathContext, this.tunnelParams));
        TailCall tailCall = template.expand(xPathContextMajor);
        while (tailCall != null) {
            tailCall = tailCall.processLeavingTail(xPathContextMajor);
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        if (!this.useTailRecursion) {
            this.process(xPathContext);
            return null;
        }
        Template template = this.getTargetTemplate(xPathContext);
        ParameterSet parameterSet = Instruction.assembleParams(xPathContext, this.actualParams);
        ParameterSet parameterSet2 = Instruction.assembleTunnelParams(xPathContext, this.tunnelParams);
        if (parameterSet == null) {
            parameterSet = new ParameterSet();
        }
        return new CallTemplatePackage(template, parameterSet, parameterSet2, xPathContext);
    }

    public Template getTargetTemplate(XPathContext xPathContext) throws XPathException {
        if (this.calledTemplateExpression != null) {
            String string;
            String string2;
            Object object;
            Controller controller = xPathContext.getController();
            String string3 = this.calledTemplateExpression.evaluateAsString(xPathContext);
            try {
                object = Name.getQNameParts(string3);
                string2 = object[0];
                string = object[1];
            }
            catch (QNameException qNameException) {
                throw this.dynamicError("Invalid template name. " + qNameException.getMessage(), controller);
            }
            object = this.nsContext.getURIForPrefix(string2, false);
            if (object == null) {
                throw this.dynamicError("Namespace prefix " + string2 + " has not been declared", controller);
            }
            int n = controller.getNamePool().getFingerprint((String)object, string);
            Template template = controller.getExecutable().getNamedTemplate(n);
            if (template == null) {
                throw this.dynamicError("Template " + string3 + " has not been defined", controller);
            }
            return template;
        }
        return this.template;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "call-template");
    }

    private class CallTemplatePackage
    implements TailCall {
        private Template target;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private XPathContext evaluationContext;

        public CallTemplatePackage(Template template, ParameterSet parameterSet, ParameterSet parameterSet2, XPathContext xPathContext) {
            this.target = template;
            this.params = parameterSet;
            this.tunnelParams = parameterSet2;
            this.evaluationContext = xPathContext;
        }

        public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
            Controller controller = xPathContext.getController();
            XPathContextMajor xPathContextMajor = this.evaluationContext.newContext();
            xPathContextMajor.setOrigin(CallTemplate.this);
            xPathContextMajor.setLocalParameters(this.params);
            xPathContextMajor.setTunnelParameters(this.tunnelParams);
            xPathContextMajor.openStackFrame(this.target.getStackFrameMap());
            TailCall tailCall = this.target.expand(xPathContextMajor);
            return tailCall;
        }
    }
}

